//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Cylinder.cpp,v 1.3 2004/02/08 18:44:19 delpinux Exp $


// This class provides a toolkit to manipulate Cylinders. It inherits
// from the Shape class.

#include <Cylinder.hpp>
#include <TinyVector.hpp>

#include <cmath>

//! Copies a Cylinder.
const Cylinder&  Cylinder::operator = (const Cylinder& C)
{
  __center = C.__c1;
  __center = C.__c2;
  __center = C.__center;
  __radius = C.__radius;
  __radius2 = C.__radius2;
  __half_height = C.__half_height;
  __unaryVector = C.__unaryVector;

  __trans = C.__trans;

  return *this;
}

//! Copies a Cylinder.
Cylinder::Cylinder()
  : Shape(cylinder)
{
  ;
}


//! Constructs the Cylinder whose axis is defined \a a and \a b, and of radius \a r
Cylinder::Cylinder(const TinyVector<3, real_t>& a,
		   const TinyVector<3, real_t>& b, const real_t& r)
  : Shape(cylinder),
    __c1(a), __c2(b),
    __center(0.5*(a+b)),
    __radius (r),
    __radius2(r*r),
    __half_height(Norm(__center - __c1)),
    __unaryVector(1./(2.*__half_height)*(b-a))
{
  ;
}

//! Copy constructor.
Cylinder::Cylinder(const Cylinder& C)
  : Shape(C),
    __c1(C.__c1),
    __c2(C.__c2),
    __center(C.__center),
    __radius(C.__radius),
    __radius2(C.__radius2),
    __half_height(C.__half_height),
    __unaryVector(C.__unaryVector)
{
  ;
}

//! Prints the definition of the Cylinder in the stream \a s.
std::ostream& Cylinder::put(std::ostream& s) const
{
  s << "cylinder {\n" << __c1
    << ", " << __c2  << ", " << __radius << '\n';
  for (size_t i=0; i<nbTransform(); i++)
    s << (*__trans[i]).povWrite() << '\n';
  s << "}\n";
  return s;
}

