//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: PDEOperatorExpression.cpp,v 1.3 2005/11/11 17:32:37 delpinux Exp $

#include <PDEOperatorExpression.hpp>
#include <PDEOperator.hpp>

#include <UserFunction.hpp>

#include <DivMuGrad.hpp>
#include <SecondOrderOperator.hpp>

#include <FirstOrderOperator.hpp>

#include <MassOperator.hpp>

PDEOperatorExpression::PDEOperatorExpression(const PDEOperatorExpression& e)
  : Expression(e),
    __pdeOperatorType(e.__pdeOperatorType)
{
  ;
}

PDEOperatorExpression::
PDEOperatorExpression(PDEOperatorType t)
  : Expression(Expression::pdeOperator),
    __pdeOperatorType(t)
{
  ;
}

PDEOperatorExpression::~PDEOperatorExpression()
{
  ;
}

ReferenceCounting<PDEOperator>
PDEScalarOperatorExpression::pdeOperator()
{
  return __pdeOperator;
}

PDEScalarOperatorExpression::PDEScalarOperatorExpression(const PDEScalarOperatorExpression& e)
  : PDEOperatorExpression(e),
    __unknown(e.__unknown),
    __pdeOperator(e.__pdeOperator),
    __pdeScalarOperatorType(e.__pdeScalarOperatorType)
{
  ;
}

PDEScalarOperatorExpression::
PDEScalarOperatorExpression(ReferenceCounting<FunctionVariable> unknown,
			    PDEScalarOperatorType t)
  : PDEOperatorExpression(PDEOperatorExpression::scalar),
    __unknown(unknown),
    __pdeScalarOperatorType(t)
{
  ;
}

PDEScalarOperatorExpression::~PDEScalarOperatorExpression()
{
  ;
}


bool PDEScalarOperatorExpressionDivMuGrad::__checkBoundaryExpression() const
{
  return (*__mu).hasBoundaryExpression();
}

void PDEScalarOperatorExpressionDivMuGrad::__execute()
{
  (*__mu).execute();
  ReferenceCounting<UserFunction> mu
    = new UnaryMinusUserFunction(new UserFunctionLanguage(__mu));
  __pdeOperator = new DivMuGrad(mu);
}

bool PDEScalarOperatorExpressionOrderZero::__checkBoundaryExpression() const
{
  return (*__Alpha).hasBoundaryExpression();
}

void PDEScalarOperatorExpressionOrderZero::__execute()
{
  (*__Alpha).execute();
  ReferenceCounting<UserFunction> alpha
    = new UserFunctionLanguage(__Alpha);
  __pdeOperator = new MassOperator(alpha);
}

bool PDEScalarOperatorExpressionOrderOne::__checkBoundaryExpression() const
{
  for (size_t i=0; i<3; ++i) {
    if(__nu[i] != 0) {
      if ((*__nu[i]).hasBoundaryExpression()) {
	return true;
      }
    }
  }
  return false;
}

void PDEScalarOperatorExpressionOrderOne::__execute()
{
  this->preexec();

  ReferenceCounting<TinyVector<3, ReferenceCounting<UserFunction> > > nu
    = new TinyVector<3, ReferenceCounting<UserFunction> >;

  for (size_t i=0; i<3; ++i) {
    if(__nu[i] != 0) {
      (*nu)[i] = new UserFunctionLanguage(__nu[i]);
    } else {
      (*nu)[i] = new ConstUserFunction(0);
    }
  }

  __pdeOperator = new FirstOrderOperator(nu);
}


PDEVectorialOperatorExpression::
PDEVectorialOperatorExpression(const PDEVectorialOperatorExpression::
			       PDEScalarOperatorType& t)
  : PDEOperatorExpression(PDEOperatorExpression::vectorial),
    __pdeOperatorType(t)
{
  ;
}

PDEVectorialOperatorExpression::
PDEVectorialOperatorExpression(const PDEVectorialOperatorExpression& e)
  : PDEOperatorExpression(e),
    __pdeOperatorList(e.__pdeOperatorList),
    __pdeOperatorType(e.__pdeOperatorType)
{
  ;
}

PDEVectorialOperatorExpression::
~PDEVectorialOperatorExpression()
{
  ;
}

bool PDEVectorialOperatorExpressionOrderOne::
__checkBoundaryExpression() const
{
  for(FirstOrderSum::const_iterator i = __sum.begin();
      i != __sum.end(); ++i) {
    if ((*(*i).second).__checkBoundaryExpression()) {
      return true;
    }
  }
  for(FirstOrderSum::const_iterator i = __diff.begin();
      i != __diff.end(); ++i) {
    if ((*(*i).second).__checkBoundaryExpression()) {
      return true;
    }
  }
  return false;
}

bool PDEVectorialOperatorExpressionOrderTwo::
__checkBoundaryExpression() const
{
  typedef
    TinyMatrix<3,3,ReferenceCounting<FunctionExpression> > 
    FunctionMatrix;

  typedef
    std::map<FunctionVariable*,FunctionMatrix > 
    FunctionMatrixSet;
  FunctionMatrixSet matrixSet;
  
  typedef
    PDEVectorialOperatorExpressionOrderOne::FirstOrderSum::const_iterator
    PDEVectorialOperatorIterator;

  for (FirstOperatorList::const_iterator i = __firstOrderOp.begin();
       i != __firstOrderOp.end(); ++i) {
    const PDEVectorialOperatorExpressionOrderOne& pdeOpOrderOne
      = (*(*i).second);
    
    if (pdeOpOrderOne.__checkBoundaryExpression()) {
      return true;
    }
  }

  return false;
}

void PDEVectorialOperatorExpressionOrderTwo::__execute()
{
  typedef
    TinyMatrix<3,3,ReferenceCounting<FunctionExpression> > 
    FunctionMatrix;

  typedef
    std::map<FunctionVariable*,FunctionMatrix > 
    FunctionMatrixSet;
  FunctionMatrixSet matrixSet;
  
  typedef
    PDEVectorialOperatorExpressionOrderOne::FirstOrderSum::iterator
    PDEVectorialOperatorIterator;

  for (FirstOperatorList::iterator i = __firstOrderOp.begin();
       i != __firstOrderOp.end(); ++i) {
    int I = (*i).first;
    PDEVectorialOperatorExpressionOrderOne& pdeOpOrderOne
      = (*(*i).second);
    pdeOpOrderOne.preexec();
    
    for (PDEVectorialOperatorIterator j = pdeOpOrderOne.__sum.begin();
	 j != pdeOpOrderOne.__sum.end(); ++j) {
      PDEScalarOperatorExpressionOrderOne& operatorOrderOne = (*(*j).second);

      FunctionMatrix& A = matrixSet[(*j).first];

      for (size_t J=0; J<3; ++J) {
	if (operatorOrderOne.nu(J) != 0) {
	  if (A(I,J) == 0) {
	    A(I,J) = operatorOrderOne.nu(J);
	  } else {
	    A(I,J)
	      = new FunctionExpressionBinaryOperator<ExpressionPlus<FunctionExpression> >(A(I,J),operatorOrderOne.nu(J));
	  }
	}
      }
    }

    for (PDEVectorialOperatorIterator j = pdeOpOrderOne.__diff.begin();
	 j != pdeOpOrderOne.__diff.end(); ++j) {
      PDEScalarOperatorExpressionOrderOne& operatorOrderOne = (*(*j).second);

      FunctionMatrix& A = matrixSet[(*j).first];

      for (size_t J=0; J<3; ++J) {
	if (operatorOrderOne.nu(J) != 0) {
	  if (A(I,J) == 0) {
	    A(I,J) = new FunctionExpressionUnaryOperator<ExpressionUnaryMinus<FunctionExpression> >(operatorOrderOne.nu(J));
	  } else {
	    A(I,J)
	      = new FunctionExpressionBinaryOperator<ExpressionMinus<FunctionExpression> >(A(I,J),operatorOrderOne.nu(J));
	  }
	}
      }
    }
  }
  for (FunctionMatrixSet::iterator i = matrixSet.begin();
       i != matrixSet.end(); ++i) {
    FunctionMatrix& a = (*i).second;
    ReferenceCounting<SecondOrderOperator::Matrix> A
      = new SecondOrderOperator::Matrix;
    for (size_t m=0; m<3; ++m)
      for (size_t n=0; n<3; ++n) {
	if (a(m,n) != 0) {
	  (*A)(m,n) = new UnaryMinusUserFunction(new UserFunctionLanguage(a(m,n)));
	}
      }
    SecondOrderOperator* secondOrderOp = new SecondOrderOperator(A);
    __pdeOperatorList.insert(std::pair<FunctionVariable*,
			     ReferenceCounting<PDEOperator> >((*i).first,
							      secondOrderOp));
  }
}

PDEVectorialOperatorExpressionOrderTwo::
PDEVectorialOperatorExpressionOrderTwo()
  : PDEVectorialOperatorExpression(PDEVectorialOperatorExpression::
				   secondOrder)
{
  ;
}

PDEVectorialOperatorExpressionOrderTwo::
~PDEVectorialOperatorExpressionOrderTwo()
{
  ;
}

