//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001-2005 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: DegreeOfFreedomPositionsSet.hpp,v 1.4 2005/09/25 14:07:29 delpinux Exp $

#ifndef DEGREE_OF_FREEDOM_POSITIONS_SET_HPP
#define DEGREE_OF_FREEDOM_POSITIONS_SET_HPP

#include <DiscretizationType.hpp>
#include <Mesh.hpp>
#include <Connectivity.hpp>

#include <cassert>

class DegreeOfFreedomPositionsSet
{
private:
  Vector<TinyVector<3,real_t> > __positions;
  Vector<size_t> __dofNumber;
  size_t __numberOfDOFPerCell;

  class Builder;
  friend class Builder;

  void __build(const DiscretizationType& discretizationType,
	       const Mesh& mesh);

public:
  const TinyVector<3,real_t>&
  vertex(const size_t& i) const
  {
    return __positions[i];
  }

  const size_t& operator()(const size_t& cellNumber,
			   const size_t& localDOFNumber) const
  {
    return __dofNumber[cellNumber*__numberOfDOFPerCell + localDOFNumber];
  }

  const size_t& number() const
  {
    return __positions.size();
  }

  DegreeOfFreedomPositionsSet(const DiscretizationType& discretizationType,
			      const Mesh& mesh)
  {
    this->__build(discretizationType, mesh);
  }

  ~DegreeOfFreedomPositionsSet()
  {
    ;
  }
};

#endif // DEGREE_OF_FREEDOM_POSITIONS_SET_HPP
