IOdictionary conversionProperties
(
    IOobject
    (
        "conversionProperties",
        runTime.constant(),
        mesh,
        IOobject::MUST_READ,
        IOobject::NO_WRITE
    )
);


scalar startTime
(
    readScalar(conversionProperties.lookup("startTime"))
);

word vComp
(
    conversionProperties.lookup("vector")
);

word format
(
    conversionProperties.lookup("format")
);

if ( (format != "ascii") && (format != "ieeei4r8") )
{
    FatalError << "format type: " << format << " unknown." 
        << " Valid options are: ascii ieeei4r8"
        << abort(FatalError);

}   
word cells
(
    conversionProperties.lookup("cells")
);

if
(
    (cells != "hex")
)
{
    FatalError << "cells type: " << cells << " unknown."
        << abort(FatalError);
}

// ************************ vim: set sw=4 sts=4 et: ************************ //
