/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.plugin.ant;

import de.hunsicker.io.FileFormat;
import de.hunsicker.jalopy.Jalopy;
import de.hunsicker.jalopy.language.ClassRepository;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.History;
import de.hunsicker.jalopy.storage.Loggers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class AntPlugin
extends Task {
    private static final String EXT_JAVA = ".java";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("de.hunsicker.jalopy.plugin.ant.Bundle", Convention.getInstance().getLocale());
    private File _destDir;
    private File _file;
    private FileFormat _fileFormat = FileFormat.AUTO;
    private List _filesets;
    private History.Method _historyMethod;
    private final Object _lock = new Object();
    private Level _loglevel;
    private Path _classpath;
    private History.Policy _history;
    private String _convention;
    private String _encoding;
    private boolean _backup;
    private boolean _failOnError = true;
    private boolean _force;
    private boolean _fork;
    private boolean _isBackup = false;
    private boolean _isForce;
    private boolean _isThreads;
    private boolean _javadoc = true;
    private int _threads = 1;

    public void setBackup(boolean backup) {
        this._backup = backup;
        this._isBackup = true;
    }

    public void setClasspathRef(Reference reference) {
        this._classpath = new Path(this.project);
        this._classpath.setRefid(reference);
    }

    public void setConvention(String location) {
        File file = new File(location);
        if (!file.exists()) {
            File basedir = this.getProject().getBaseDir();
            this._convention = basedir.getAbsolutePath() + File.separator + location;
        }
        this._convention = location;
    }

    public void setDestdir(File destDir) {
        this._destDir = destDir;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setFailOnError(boolean fail) {
        this._failOnError = fail;
    }

    public void setFile(File file) {
        if (!file.exists()) {
            Object[] args = new Object[]{file};
            throw new IllegalArgumentException(MessageFormat.format(BUNDLE.getString("FILE_NOT_EXIST"), args));
        }
        this._file = file;
    }

    public void setFileFormat(String fileFormat) {
        String format = fileFormat.trim().toLowerCase();
        if (format.equals("dos") || format.equals(FileFormat.DOS.getLineSeparator())) {
            this._fileFormat = FileFormat.DOS;
        } else if (format.equals("default") || format.equals(FileFormat.DEFAULT.toString())) {
            this._fileFormat = FileFormat.DEFAULT;
        } else if (format.equals("unix") || format.equals(FileFormat.UNIX.getLineSeparator())) {
            this._fileFormat = FileFormat.UNIX;
        } else if (format.equals("mac") || format.equals(FileFormat.MAC.getLineSeparator())) {
            this._fileFormat = FileFormat.MAC;
        } else if (format.equals("auto") || format.equals(FileFormat.AUTO.toString())) {
            this._fileFormat = FileFormat.AUTO;
        } else {
            Object[] args = new Object[]{fileFormat};
            throw new IllegalArgumentException(MessageFormat.format(BUNDLE.getString("INVALID_FILE_FORMAT"), args));
        }
    }

    public void setForce(boolean force) {
        this._force = force;
        this._isForce = true;
    }

    public void setFork(boolean fork) {
        this._fork = fork;
    }

    public void setHistory(String policy) {
        if ((policy = policy.trim().toLowerCase()).equals("comment")) {
            this._history = History.Policy.COMMENT;
        } else if (policy.equals("file")) {
            this._history = History.Policy.FILE;
        } else if (policy.equals("none")) {
            this._history = History.Policy.DISABLED;
        } else {
            Object[] args = new Object[]{policy};
            throw new IllegalArgumentException(MessageFormat.format(BUNDLE.getString("INVALID_HISTORY_POLICY"), args));
        }
    }

    public void setHistoryMethod(String method) {
        if ("timestamp".equals(method = method.trim().toLowerCase())) {
            this._historyMethod = History.Method.TIMESTAMP;
        } else if ("crc32".equals(method)) {
            this._historyMethod = History.Method.CRC32;
        } else if ("adler32".equals(method)) {
            this._historyMethod = History.Method.ADLER32;
        } else {
            Object[] args = new Object[]{method};
            throw new IllegalArgumentException(MessageFormat.format(BUNDLE.getString("INVALID_HISTORY_METHOD"), args));
        }
    }

    public void setJavadoc(boolean javadoc) {
        this._javadoc = javadoc;
    }

    public void setLoglevel(String level) {
        if ((level = level.trim().toUpperCase()).equals("INFO")) {
            this._loglevel = Level.INFO;
        } else if (level.equals("DEBUG")) {
            this._loglevel = Level.DEBUG;
        } else if (level.equals("WARN")) {
            this._loglevel = Level.WARN;
        } else if (level.equals("ERROR")) {
            this._loglevel = Level.ERROR;
        } else {
            Object[] args = new Object[]{level};
            throw new IllegalArgumentException(MessageFormat.format(BUNDLE.getString("INVALID_LOGLEVEL"), args));
        }
    }

    public void setStyle(String location) {
        this.setConvention(location);
    }

    public void setThreads(String threads) {
        String number = threads.trim();
        try {
            this._threads = Integer.parseInt(number);
            if (this._threads < 1 || this._threads > 8) {
                Object[] args = new Object[]{threads};
                throw new IllegalArgumentException(MessageFormat.format(BUNDLE.getString("INVALID_TREAD_COUNT"), args));
            }
        }
        catch (NumberFormatException ex) {
            Object[] args = new Object[]{threads};
            throw new IllegalArgumentException(MessageFormat.format(BUNDLE.getString("INVALID_TREAD_COUNT"), args));
        }
        this._isThreads = true;
    }

    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    public void execute() throws BuildException {
        if (this._fork && System.getProperty("de.hunsicker.jalopy.plugin.ant.forked", "false").equals("false")) {
            try {
                CommandlineJava cmd = new CommandlineJava();
                cmd.createArgument().setValue("-Dde.hunsicker.jalopy.plugin.ant.forked=true");
                cmd.createArgument().setValue("-classpath");
                cmd.createArgument().setValue(System.getProperty("java.class.path"));
                cmd.createArgument().setValue("org.apache.tools.ant.Main");
                cmd.createArgument().setValue("-logger");
                cmd.createArgument().setValue("org.apache.tools.ant.NoBannerLogger");
                cmd.createArgument().setValue("-f");
                cmd.createArgument().setValue(this.project.getProperty("ant.file"));
                cmd.createArgument().setValue(this.getOwningTarget().getName());
                Execute exe = new Execute();
                exe.setAntRun(this.project);
                exe.setWorkingDirectory(this.project.getBaseDir());
                exe.setCommandline(cmd.getCommandline());
                exe.execute();
                if (exe.getExitValue() != 0) {
                    throw new BuildException(BUNDLE.getString("RUN_FAILED"));
                }
            }
            catch (Throwable ex) {
                throw new BuildException(ex);
            }
            return;
        }
        if (this._file == null) {
            if (this._filesets.size() == 0) {
                throw new BuildException(BUNDLE.getString("MISSING_SOURCE"));
            }
        } else if (this._file.exists()) {
            if (this._file.isDirectory()) {
                throw new BuildException(BUNDLE.getString("USE_FILESET_FOR_DIRECTORIES"));
            }
        } else {
            Object[] args = new Object[]{this._file};
            throw new BuildException(MessageFormat.format(BUNDLE.getString("FILE_NOT_EXIST"), args));
        }
        this.log("Jalopy Java Source Code Formatter " + Jalopy.getVersion());
        AntAppender appender = new AntAppender();
        if (this._loglevel != null) {
            this.initLoggers((Appender)appender, this._loglevel);
        } else {
            Loggers.initialize((Appender)appender);
        }
        if (this._classpath != null) {
            this.loadRepository(this._classpath.list());
        }
        if (!this._isThreads) {
            this._threads = Convention.getInstance().getInt(ConventionKeys.THREAD_COUNT, 1);
        }
        if (this._threads == 1) {
            this.formatSingleThreaded();
        } else {
            this.formatMultiThreaded();
        }
    }

    public void init() throws BuildException {
        this._filesets = new ArrayList(4);
    }

    private boolean isRunning(List threads) {
        int i = 0;
        int size = threads.size();
        while (i < size) {
            FormatThread thread = (FormatThread)threads.get(i);
            if (thread.running) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Jalopy createJalopy() {
        Jalopy jalopy = new Jalopy();
        if (this._convention != null) {
            try {
                Jalopy.setConvention((String)this._convention);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        Convention settings = Convention.getInstance();
        jalopy.setEncoding(this._encoding);
        jalopy.setFileFormat(this._fileFormat);
        jalopy.setInspect(settings.getBoolean(ConventionKeys.INSPECTOR, false));
        if (this._destDir != null) {
            jalopy.setDestination(this._destDir);
        }
        if (this._history != null) {
            jalopy.setHistoryPolicy(this._history);
        } else {
            History.Policy historyPolicy = History.Policy.valueOf((String)settings.get(ConventionKeys.HISTORY_POLICY, ConventionDefaults.HISTORY_POLICY));
            jalopy.setHistoryPolicy(historyPolicy);
        }
        if (this._historyMethod != null) {
            jalopy.setHistoryMethod(this._historyMethod);
        } else {
            History.Method historyMethod = History.Method.valueOf((String)settings.get(ConventionKeys.HISTORY_METHOD, ConventionDefaults.HISTORY_METHOD));
            jalopy.setHistoryMethod(historyMethod);
        }
        if (this._isBackup) {
            jalopy.setBackup(this._backup);
        } else {
            jalopy.setBackup(settings.getInt(ConventionKeys.BACKUP_LEVEL, 0) > 0);
        }
        if (this._isForce) {
            jalopy.setForce(this._force);
        } else {
            jalopy.setForce(settings.getBoolean(ConventionKeys.FORCE_FORMATTING, false));
        }
        return jalopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatMultiThreaded() {
        ArrayList<File> files = new ArrayList<File>(200);
        int i = 0;
        int size = this._filesets.size();
        while (i < size) {
            FileSet fs = (FileSet)this._filesets.get(i);
            DirectoryScanner scanner = fs.getDirectoryScanner(this.project);
            File fromDir = fs.getDir(this.project);
            String[] srcFiles = scanner.getIncludedFiles();
            int j = 0;
            while (j < srcFiles.length) {
                files.add(new File(fromDir, srcFiles[j]));
                ++j;
            }
            ++i;
        }
        if (this._file != null && this._file.getName().endsWith(EXT_JAVA)) {
            files.add(this._file);
        }
        this.logStart(files.size());
        int numThreads = this._threads;
        if (files.size() < this._threads) {
            numThreads = files.size();
        }
        ArrayList<FormatThread> threads = new ArrayList<FormatThread>(numThreads);
        Jalopy jalopy = null;
        int j = 0;
        while (j < numThreads) {
            FormatThread thread = new FormatThread(files);
            threads.add(thread);
            thread.start();
            jalopy = thread.jalopy;
            ++j;
        }
        try {
            Object thread = this._lock;
            synchronized (thread) {
                while (this.isRunning(threads)) {
                    this._lock.wait();
                }
            }
            boolean error = false;
            int count = 0;
            int i2 = 0;
            int size2 = threads.size();
            while (i2 < size2) {
                FormatThread thread2 = (FormatThread)threads.get(i2);
                count += thread2.count;
                if (!error) {
                    error = thread2.error;
                }
                ++i2;
            }
            this.logEnd(count);
            if (jalopy != null) {
                jalopy.cleanupBackupDirectory();
            }
            if (error) {
                throw new BuildException(BUNDLE.getString("RUN_FAILED"));
            }
        }
        catch (Throwable ex) {
            throw new BuildException(ex);
        }
    }

    private void formatSingleThreaded() {
        Jalopy jalopy = this.createJalopy();
        boolean error = false;
        if (this._file != null && this._file.getName().endsWith(EXT_JAVA)) {
            try {
                block19: {
                    jalopy.setInput(this._file);
                    try {
                        jalopy.setOutput(this._file);
                    }
                    catch (IllegalArgumentException ex) {
                        error = true;
                        Object[] args = new Object[]{this._file, this._destDir};
                        Loggers.IO.l7dlog((Priority)Level.ERROR, "INVALID_OUTPUT_TARGET", args, null);
                        if (!this._failOnError) break block19;
                        throw new BuildException(BUNDLE.getString("INVALID_OUTPUT_TARGET"));
                    }
                }
                jalopy.format();
                if (jalopy.getState() == Jalopy.State.ERROR) {
                    error = true;
                    if (this._failOnError) {
                        throw new BuildException(BUNDLE.getString("UNKNOWN_ERROR"));
                    }
                }
            }
            catch (FileNotFoundException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        try {
            int i = 0;
            int size = this._filesets.size();
            while (i < size) {
                FileSet fs = (FileSet)this._filesets.get(i);
                DirectoryScanner scanner = fs.getDirectoryScanner(this.project);
                File fromDir = fs.getDir(this.project);
                String[] srcFiles = scanner.getIncludedFiles();
                this.logStart(srcFiles.length);
                int count = 0;
                int j = 0;
                while (j < srcFiles.length) {
                    block20: {
                        File file = new File(fromDir, srcFiles[j]);
                        jalopy.setInput(file);
                        try {
                            jalopy.setOutput(file);
                        }
                        catch (IllegalArgumentException ex) {
                            error = true;
                            Object[] args = new Object[]{file, this._destDir};
                            Loggers.IO.l7dlog((Priority)Level.ERROR, "INVALID_OUTPUT_TARGET", args, null);
                            if (!this._failOnError) break block20;
                            throw new BuildException(BUNDLE.getString("INVALID_OUTPUT_TARGET"));
                        }
                    }
                    boolean success = jalopy.format();
                    if (jalopy.getState() == Jalopy.State.ERROR) {
                        error = true;
                        if (this._failOnError) {
                            throw new BuildException(BUNDLE.getString("UNKNOWN_ERROR"));
                        }
                    } else if (success) {
                        ++count;
                    }
                    ++j;
                }
                this.logEnd(count);
                ++i;
            }
            if (error) {
                throw new BuildException(BUNDLE.getString("RUN_FAILED"));
            }
            jalopy.cleanupBackupDirectory();
        }
        catch (FileNotFoundException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (Throwable ex) {
            throw new BuildException(ex);
        }
    }

    private void initLogger(Logger logger, Appender appender, Level level) {
        Appender currentAppender = logger.getAppender("JalopyAntAppender");
        if (currentAppender == null) {
            logger.addAppender(appender);
            logger.setLevel(level);
        }
    }

    private void initLoggers(Appender appender, Level level) {
        Loggers.ALL.removeAllAppenders();
        ResourceBundle bundle = ResourceBundle.getBundle("de.hunsicker.jalopy.storage.Bundle", Convention.getInstance().getLocale());
        Loggers.ALL.setResourceBundle(bundle);
        this.initLogger(Loggers.IO, appender, level);
        this.initLogger(Loggers.PARSER, appender, level);
        this.initLogger(Loggers.PRINTER, appender, level);
        this.initLogger(Loggers.TRANSFORM, appender, level);
        if (this._javadoc) {
            this.initLogger(Loggers.PARSER_JAVADOC, appender, level);
            this.initLogger(Loggers.PRINTER_JAVADOC, appender, level);
        }
    }

    private void loadRepository(String[] paths) {
        block7: {
            if (paths.length == 0) {
                return;
            }
            ClassRepository repository = ClassRepository.getInstance();
            File javaRuntime = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar");
            if (!javaRuntime.exists()) {
                this.log(BUNDLE.getString("RUNTIME_NOT_FOUND"), 1);
                return;
            }
            ArrayList<File> files = new ArrayList<File>(paths.length);
            files.add(javaRuntime);
            int i = 0;
            while (i < paths.length) {
                files.add(new File(paths[i]));
                ++i;
            }
            try {
                repository.loadAll(files);
            }
            catch (Throwable ex) {
                this.log(BUNDLE.getString("REPOSITORY_NOT_LOADED"), 1);
                if (repository == null || repository.isEmpty()) break block7;
                try {
                    repository.unloadAll(files);
                }
                catch (Throwable e) {
                    this.log(BUNDLE.getString("REPOSITORY_CLEANUP"), 0);
                }
            }
        }
    }

    private void logEnd(int files) {
        if (this._destDir == null) {
            Object[] args = new Object[]{new Integer(files)};
            this.log(MessageFormat.format(BUNDLE.getString("FORMATTED_FILES"), args), 2);
        } else {
            Object[] args = new Object[]{new Integer(files), this._destDir};
            this.log(MessageFormat.format(BUNDLE.getString("FORMATTED_FILES_DESTINATION"), args), 2);
        }
    }

    private void logStart(int files) {
        if (this._destDir == null) {
            Object[] args = new Object[]{new Integer(files)};
            this.log(MessageFormat.format(BUNDLE.getString("FORMAT_FILES"), args), 2);
        } else {
            Object[] args = new Object[]{new Integer(files), this._destDir};
            this.log(MessageFormat.format(BUNDLE.getString("FORMAT_FILES_DESTINATION"), args), 2);
        }
    }

    private class FormatThread
    extends Thread {
        Jalopy jalopy;
        List files;
        boolean error;
        volatile boolean running;
        int count;

        public FormatThread(List files) {
            this.files = files;
            this.jalopy = AntPlugin.this.createJalopy();
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            File file = null;
            try {
                this.running = true;
                while (!this.files.isEmpty()) {
                    block20: {
                        object = this.files;
                        synchronized (object) {
                            if (this.files.isEmpty()) {
                                break;
                            }
                            file = (File)this.files.remove(0);
                        }
                        try {
                            this.jalopy.setInput(file);
                        }
                        catch (FileNotFoundException ex) {
                            throw new BuildException((Throwable)ex);
                        }
                        try {
                            this.jalopy.setOutput(file);
                        }
                        catch (IllegalArgumentException ex) {
                            this.error = true;
                            Object[] args = new Object[]{file, AntPlugin.this._destDir};
                            Loggers.IO.l7dlog((Priority)Level.ERROR, "INVALID_OUTPUT_TARGET", args, null);
                            if (!AntPlugin.this._failOnError) break block20;
                            throw new BuildException(BUNDLE.getString("INVALID_OUTPUT_TARGET"));
                        }
                    }
                    boolean success = this.jalopy.format();
                    if (this.jalopy.getState() == Jalopy.State.ERROR) {
                        this.error = true;
                        if (!AntPlugin.this._failOnError) continue;
                        throw new BuildException(BUNDLE.getString("UNKNOWN_ERROR"));
                    }
                    if (!success) continue;
                    ++this.count;
                }
            }
            finally {
                object = AntPlugin.this._lock;
                synchronized (object) {
                    this.running = false;
                    AntPlugin.this._lock.notify();
                }
            }
        }
    }

    private class AntAppender
    extends AppenderSkeleton {
        static final String APPENDER_NAME = "JalopyAntAppender";

        public AntAppender() {
            this.name = APPENDER_NAME;
        }

        public void append(LoggingEvent ev) {
            switch (ev.getLevel().toInt()) {
                case 10000: {
                    AntPlugin.this.log(ev.getRenderedMessage(), 2);
                    break;
                }
                case 40000: 
                case 50000: {
                    AntPlugin.this.log(ev.getRenderedMessage(), 0);
                    String[] lines = ev.getThrowableStrRep();
                    if (lines == null) break;
                    int i = 0;
                    while (i < lines.length) {
                        AntPlugin.this.log(lines[i], 0);
                        ++i;
                    }
                    break;
                }
                case 20000: {
                    AntPlugin.this.log(ev.getRenderedMessage(), 2);
                    break;
                }
                case 30000: {
                    AntPlugin.this.log(ev.getRenderedMessage(), 1);
                    break;
                }
            }
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

