#include "moreIHM.h"

/*Message Boxes and default dialogs
UTILS_EXPORT void informativeMessageBox( const QString &text, const QString&infoText, const QString&detail = QString::null, const QString &title = QString::null );
UTILS_EXPORT void warningMessageBox( const QString &text, const QString&infoText, const QString&detail = QString::null, const QString &title = QString::null );
UTILS_EXPORT bool yesNoMessageBox( const QString &text, const QString&infoText, const QString&detail = QString::null, const QString &title = QString::null, const QPixmap &icon = QPixmap() );
UTILS_EXPORT int withButtonsMessageBox( const QString &text, const QString&infoText, const QString&detail, const QStringList &buttonsText, const QString &title = QString::null, bool withCancelButton = false );
UTILS_EXPORT int withButtonsMessageBox( const QString &text, const QString&infoText, const QString&detail, QMessageBox::StandardButtons buts, QMessageBox::StandardButton defaultButton, const QString &title = QString::null );
UTILS_EXPORT bool okCancelMessageBox( const QString &text, const QString&infoText, const QString&detail = QString::null, const QString &title = QString::null );
UTILS_EXPORT bool functionNotAvailableMessageBox( const QString &functionText );
*/

MoreIHM::MoreIHM(QObject * parent,TreeViewOfPrevention * treeView,QModelIndex index){
    setupUi(this);
    setParent(static_cast<QWidget*> (parent));
    setAutoFillBackground(true);
    setWindowFlags(Qt::Window);
    QPoint posOfMainWindow = static_cast<QWidget*>(parent->parent()) ->pos();
    int a = posOfMainWindow.x();
    int b = posOfMainWindow.y();
    move(a+50,b+50);
    const QString comboLabelText = "<html><body><font color=red size=3>"+trUtf8("Choose item")+
                                   "</font></body></html>";
    comboLabel->setText(comboLabelText);
    //quitButton->setShortcut(QKeySequence::InsertParagraphSeparator);
    quitButton->setDefault(true);
    saveButton->setShortcut(QKeySequence("CTRL+s"));
    QModelIndex parentIndex = treeView->model()->parent(index);
    QHash<int,QVariant> hashOfItems;
    hashOfItems = treeView->model()->childs(parentIndex);
    QStringList listForTheCombo;
    for (int i = 0; i < hashOfItems.size(); i += 1)
    {
    	  listForTheCombo << hashOfItems.value(i).toString();
        }
    m_io = new PreventIO(parent);
    m_db = m_io->getDatabase();
    textBrowser->setOpenExternalLinks(true);
    textBrowser->setReadOnly(false);
    comboItemsSameParent->addItems(listForTheCombo);
    connect(comboItemsSameParent,SIGNAL(activated(int)),this,SLOT(showDocumentAccordingToComboChoice(int)));
    connect(quitButton,SIGNAL(pressed()),this,SLOT(closeAndQuit()));
    connect(saveButton,SIGNAL(pressed()),this,SLOT(saveTextBrowser()));
    
}

MoreIHM::~MoreIHM(){}

/*void MoreIHM::mouseReleaseEvent(QMouseEvent *event){
    if(event->button() == Qt::RightButton){
        blockSignals(true);
        emit closeMoreWidget();
        blockSignals(false);
        }

    if(event->button() == Qt::LeftButton) {
        blockSignals(false);
        QWidget::mouseReleaseEvent(event);
        
    }
}*/

void MoreIHM::closeMoreWidget(){
    emit close();
}

void MoreIHM::showDocumentAccordingToComboChoice(int item)
{

}

void MoreIHM::closeAndQuit()
{
    QMessageBox mess;
    mess.setText(trUtf8("Do you want to save and close ?"));
    mess.setButtons(QMessageBox::Ok|QMessageBox::No);
    mess.setDefaultButton(QMessageBox::Ok);
    int ret = mess.exec();
    switch(ret){
        case QMessageBox::Ok :
            saveTextBrowser();
            close();
            break;
        case QMessageBox::No :
            close();
            break;
        default :
            break;    
        }
}

void MoreIHM::saveTextBrowser()
{
    
}




