/*
 * Decompiled with CFR 0.152.
 */
package bemused;

import bemused.BemusedProtocol;
import java.util.Vector;

public class Browser {
    BemusedProtocol protocol;
    String[] dirs;
    String[] files;
    String activeDir;
    boolean updateVisible;
    boolean dirChanged;

    public Browser(BemusedProtocol bemusedProtocol) {
        this.protocol = bemusedProtocol;
        this.activeDir = "";
        boolean bl = true;
        this.dirs = new String[0];
        this.files = new String[0];
        this.updateVisible = true;
        this.dirChanged = false;
    }

    public String activeDir() {
        int n = 0;
        int n2 = 0;
        while (n2 > -1) {
            n = n2;
            n2 = this.activeDir.indexOf("\\", n + 1);
        }
        return this.activeDir.substring(n, this.activeDir.length());
    }

    public String[] dirs() {
        return this.dirs;
    }

    public String[] files() {
        return this.files;
    }

    public void requestMenu() {
        this.protocol.requestMenu();
    }

    public int fetchIndex(String string) {
        int n;
        int n2 = string.length();
        string = string.toLowerCase();
        for (n = 0; n < this.dirs.length; ++n) {
            if (!this.dirs[n].substring(0, n2).toLowerCase().equals(string)) continue;
            return n;
        }
        for (n = 0; n < this.files.length; ++n) {
            if (!this.files[n].substring(0, n2).toLowerCase().equals(string)) continue;
            return n + this.dirs.length;
        }
        return 0;
    }

    public void setDirInfo(String[] stringArray) {
        int n;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            vector.addElement(stringArray[n]);
        }
        n = vector.size();
        this.dirs = new String[n < 1 ? 0 : n];
        for (int i = 0; i < n; ++i) {
            this.dirs[i] = (String)vector.elementAt(i);
        }
        if (this.updateVisible) {
            this.protocol.notifyStatusUpdate();
        }
    }

    public boolean dirChanged() {
        if (this.dirChanged) {
            this.dirChanged = false;
            return true;
        }
        return this.dirChanged;
    }

    private static void quicksort(String[] stringArray) {
        Browser.quicksort(stringArray, 0, stringArray.length - 1);
    }

    private static void quicksort(String[] stringArray, int n, int n2) {
        if (n2 <= n) {
            return;
        }
        int n3 = Browser.partition(stringArray, n, n2);
        Browser.quicksort(stringArray, n, n3 - 1);
        Browser.quicksort(stringArray, n3 + 1, n2);
    }

    private static int partition(String[] stringArray, int n, int n2) {
        while (true) {
            if (n < n2 && stringArray[n].toLowerCase().compareTo(stringArray[n2].toLowerCase()) < 0) {
                --n2;
                continue;
            }
            if (n < n2) {
                Browser.swap(stringArray, n++, n2);
            } else {
                return n;
            }
            while (n < n2 && stringArray[n].toLowerCase().compareTo(stringArray[n2].toLowerCase()) < 0) {
                ++n;
            }
            if (n >= n2) break;
            Browser.swap(stringArray, n, n2--);
        }
        return n2;
    }

    private static void swap(String[] stringArray, int n, int n2) {
        String string = stringArray[n];
        stringArray[n] = stringArray[n2];
        stringArray[n2] = string;
    }

    public void sendMenuItemSelected(String string) {
        this.protocol.sendMenuItemSelected(string);
        this.requestMenu();
    }

    public void menuSubmenu() {
        this.protocol.submenu();
        this.requestMenu();
    }

    public void menuMain() {
        this.protocol.mainMenu();
    }

    public void menuBack() {
        this.protocol.stop();
        this.requestMenu();
    }
}

