/*
 *  $Id: rk_main.c,v 1.3 2001/06/14 18:16:05 ura Exp $
 */

/*
 * FreeWnn is a network-extensible Kana-to-Kanji conversion system.
 * This file is part of FreeWnn.
 * 
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright FreeWnn Project 1999, 2000
 *
 * Maintainer:  FreeWnn Project   <freewnn@tomo.gr.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/***********************************************************************
                        rk_main.c
                                                88. 6.10   

        ޻Ѵ¾ϥɤѴץࡣ
        ASCIIɻѤȤƤ롣
        ΥեϡѴΥᥤ롼
***********************************************************************/

#include "rk_header.h"
#include "rk_extvars.h"
#include "rk_fundecl.h"

struct matchpair                /*    ߥޥåƤѿֹȡޥåʸ
                                   Ȥݻ */
{
  int hennum;
  letter ltrmch;
};

letter memory[SIZALL];          /* Ѵбɽ䡢ѿѰʤɤΰ */
struct dat data[LINALL];        /* бɽΰԤȤΥǡؤΥݥ */
letter *hensudefhyo[VARTOT];    /* ѿȤѰǡؤΥݥ */
struct matchpair henmatch[VARTOT];      /* ѿΥޥå򤿤Ƥ */

#ifdef KDSP
#  ifdef MVUX
letter displine[DSPLIN];        /* ǥХå  ɽΰʬ򵭲 */
#  endif
#endif

letter *curdis;
int codein_len;
letter *codeout, *remainkbf;
letter ungetc_buf = EOLTTR;     /* romkan_ungetcʸ򤷤ƤХåե */
letter unnext_buf = EOLTTR;     /* romkan_unnext                         */

letter (*keyin_method) ();      /* ؿΥɥ쥹 */
int (*bytcnt_method) ();        /* ХȥȴؿΥɥ쥹 */
int (*kbytcnt_method) ();       /* ϲѥХȥȴؿΥɥ쥹 */
char prv_modfnm[REALFN] = "\0"; /* ⡼ɽ̾ϤΥѥ̾ˤ¸ */
            /* ꤬ø! */

#define DISOUT ((flags & RK_NONISE) ? rk_output : disout)
 /* ե饰ͤromkan_init3()ꤵ졢RK_NONISEΥӥåȤͤ
    ɸ0äDISOUTɸͤdisoutrk_outputѤȡ
    ʽLTREOFˤڽФʤâϤɬ֤褦
    Ƥ˸¤ꡢEOLTTR֤ˡ */

char eofflg;                    /* romkan_next()LTREOF褿Ȥˡromkan_henkan()1
                                   ˤ롣ͤ0ʤѴбɽ(error)̵뤷ơ
                                   ܽХåե̤ꥳɤ⡢ŪѴ롣
                                   LTREOF褿̤ˤϤФ褦˻ꤵƤ
                                   νԤâνϵޤ館Դˡ
                                   eofflg2 */

letter evalbuf[2][2][OUTSIZ];
char ebf_sw = 0;
letter saishu_out[OUTSIZ];
letter delchr, delchr2 = EOLTTR, nisedl;        /* DELΥ饯ĤޤǻƤ */

modetyp chgmod (), incmod (), decmod ();


/* letter֤ؿڤʰˤcharΤΤ⺮äƤ */

static letter mchedsrc ();
letter romkan_next (), romkan_unnext ();
letter romkan_getc (), romkan_ungetc (), *romkan_henkan ();
letter to_zenalpha (), to_zenhira (), to_zenkata ();
 /* to_zenhira;kata ʸޤȤˤʤ */

void BUGreport ();
static void maeato_henkan (), add_at_eof (), rk_delete (), set_rubout (), mchevl (), codeout_chg (), ltrevlcpy ();
int match ();
static int p_eq (), hen_ikisrc (), henkan_ok (), rk_rst (), head_bytecount ();
extern void readdata (), romkan_reset (), hank_setup (), to_hankata (), to_digit (), dakuadd (), handakuadd (), allchgmod ();
extern int ltov ();

static letter *
ltrcpy (lp1, lp2)
     letter *lp1, *lp2;
{
  letter *org;

  org = lp1;
  while ((*lp1++ = *lp2++) != EOLTTR);
  return (org);
}

#ifdef notuse
letter *
ltrncpy (lp1, lp2, n)           /* 'EOLTTR'򥻥å */
     letter *lp1, *lp2;
     int n;
{
  letter *org;

  org = lp1;
  for (; n; --n)
    if (EOLTTR == (*lp1++ = *lp2++))
      return (org);
  *lp1 = EOLTTR;
  return (org);
}
#endif

 /** letter˰ʸĤʤ */
static letter *
ltr1cat (lp, l)
     letter *lp, l;
{
  letter *org;

  org = lp;
  totail (lp);
  *lp++ = l;
  *lp = EOLTTR;
  return (org);
}

 /** ʸ˰ʸĤʤ롣ltr1catchar */
char *
chrcat (s, c)
     char *s, c;
{
  char *org;

  org = s;
  strtail (s);
  *s++ = c;
  *s = '\0';
  return (org);
}

static letter *
ltrcat (lp1, lp2)
     letter *lp1, *lp2;
{
  letter *org;

  org = lp1;
  totail (lp1);
  ltrcpy (lp1, lp2);
  return (org);
}

 /** letterlp2γǤκǾ̥ӥåȤΩƤƤ顢lp1θˤĤʤ롣*/
static letter *
bitup_ltrcat (lp1, lp2)
     letter *lp1, *lp2;
{
  letter *org;

  org = lp1;
  totail (lp1);

  while ((*lp1 = *lp2++) != EOLTTR)
    *lp1++ |= HG1BIT;
         /** lp2 ƤκǾ̥ӥåȤΩƤ롣*lp2NISEBP(rk_spclval.h
             define)ʤɤΤȤϺǽ餫Ǿ̤ΩäƤ뤫褤 */

  return (org);
}

 /** ltrcatȡ̤ʸ˥ݥ󥿤äƤ*/
letter *
ltrgrow (lp1, lp2)
     letter *lp1, *lp2;
{
  totail (lp1);
  while ((*lp1 = *lp2++) != EOLTTR)
    lp1++;
  return (lp1);
}

static int
ltrlen (lp)
     letter *lp;
{
  letter *org;

  for (org = lp; *lp != EOLTTR; lp++);
  return (lp - org);
}

 /**    letterκǸʸؤΥݥ󥿤֤âʸФƤ
        Τޤ֤*/
letter *
ltrend (lp)
     letter *lp;
{
  return ((*lp != EOLTTR) ? (lp + ltrlen (lp) - 1) : lp);
}

 /**    ʸκǸʸؤΥݥ󥿤֤ltrend()charǡltrend()
        Ʊ͡ʸΤȤ㤬롣*/
char *
strend (s)
     char *s;
{
  return (*s ? (s + strlen (s) - 1) : s);
}

int
ltrcmp (lp1, lp2)
     letter *lp1, *lp2;
{
  for (; *lp1 == *lp2; lp1++, lp2++)
    if (*lp1 == EOLTTR)
      return (0);
  return (*lp1 > *lp2 ? 1 : -1);
}

#ifdef notuse
int
ltrncmp (lp1, lp2, n)
     letter *lp1, *lp2;
     int n;
{
  for (; n && *lp1 == *lp2; n--, lp1++, lp2++)
    if (*lp1 == EOLTTR)
      return (0);
  return (n == 0 ? 0 : (*lp1 > *lp2 ? 1 : -1));
}

letter *
ltr_index (lp, l)
     letter l, *lp;
{
  for (; *lp != EOLTTR; lp++)
    if (*lp == l)
      return (lp);
  return (NULL);
}
#endif

static letter *
ltr_rindex (lp, l)
     letter l, *lp;
{
  letter *lp2;

  for (lp += ltrlen (lp2 = lp); lp2 != lp;)
    if (*--lp == l)
      return (lp);
  return (NULL);
}

 /** ʸʸ򥫥åȤ롣*/
letter *
ltr1cut (lp)
     letter *lp;
{
  int l;

  if (0 == (l = ltrlen (lp)))
    BUGreport (0);              /* Illegal POP */
  *(lp + --l) = EOLTTR;
  return (lp);
}

 /** letterΰʸĹʸѴ */
static letter *
ltr_to_ltrseq (lp, l)
     letter *lp, l;
{
  *lp++ = l;
  *lp-- = EOLTTR;
  return (lp);
}

 /** char󤫤letterļФâ'\0'EOLTTRѤ */
/* *INDENT-OFF* */
letter
letterpick (lbfpptr)
     uns_chr **lbfpptr;
/* *INDENT-ON* */
{
  letter l = 0;
  register int i;

  for (i = (*bytcnt_method) (*lbfpptr); i; i--)
    l = (l << 8) + *(*lbfpptr)++;
  return (l == 0 ? EOLTTR : l);
}

 /**    Ϥ줿ɤʸñ̤ˤޤȤ롣âEOFLTREOFrk_spclval.h
        ˤˤѤ롣*/
/* *INDENT-OFF* */
letter
romkan_next ()
/* *INDENT-ON* */
{
  letter in;
  int i, n;
  uns_chr c;

  /* unnextƤϡФ */
  if (unnext_buf != EOLTTR)
    return (in = unnext_buf, unnext_buf = EOLTTR, in);

  if ((letter) EOF == (in = (*keyin_method) ()))
    return (LTREOF);
  c = (in &= 0xff);
  n = (*kbytcnt_method) (&c);
  for (i = 1; i < n; i++)
    in = (in << 8) + ((*keyin_method) () & 0xff);
  return (in);
}

 /*     letterʸ l charʸ c ӡɥޡƱΡletter
    ɥޡEOLTTRcharΤ'\0'ˤפȤߤʤ */
#define ltrchreq(l, c) ((l) == ((c) != 0 ? (c) : EOLTTR))

 /** letterʸcharʸ â羮ӤʤȤƤ */
int
ltrstrcmp (l, s)
     register letter *l;
     register char *s;
{
  for (; ltrchreq (*l, *s); l++, s++)
    if (*s == 0)
      return (0);
  return ((*l < (uns_chr) * s || *l == EOLTTR) ? -1 : 1);
}

 /** Ǹ˥ޥåʸ ĤޤurabufκǸ塣urabufEOLTTR֤ */
static letter
lastmch ()
{
  return (*(ltrend (urabuf)));
}

/* end of 'letter' functions */


#ifdef  OMAKE
 /**     
        ԣ֥˥ΤʰûޤˡλϤɤ줫ġ
        -1ʤƤϤʳʤ鲿Ϥʤξ⡢ǡ
        θĿ֤*/
takeoka (i)
     int i;
{
#define OPIMAX (numberof(opinion))

  static char *opinion[] = {
    "ˡΥɥ ѥƥ桼ߡפɤȤbyݲ",
    "ֵưΥদפϵԤɤȤby",
    "ˡΥ ޥ륨ߡפɤȤbyݲ",
    "ʻͰոˡ֥ޥ륨ߡ͡פɤ˥by",
    "ˡŷ ꥣߡޥߡפɤȤbyݲ",
    "֥פɤȤby",
    "֥ࡼߥפɤȤby",
    "֥ޥפΥɥʡ꡼ɤȤby",
    "֥ס󤪤ФפɤȤby",
    "֤Ϥʹ֥㡼ȥ륺פɤȤbyٱ",
    "ֱεΥƥåޥפɤȤby",
    "Ųʹ֥٥פɤȤby",
    "֥ץξϥפɤȤbyٱ",
    "֤Ȥ᤭ȥʥȡפɤȤby",
    "֤Υ硼פɤȤä͡byΩڡʤĤ",
    "֤ޤ쥪󥸡ɡפɤȤby",
    "֥åܡסʡ֥åܣǡפޤˤɤȤby",
    "֥ƥäסʡ֤ҥפΤȡˤɤȤby",
    "֥ޥԥ졼פɤȤby",
    "־פɤȤby",
    "̩⥴󥸥㡼פɤȤby",
    "ΡˡŴ28פɤȤby"
  };

  if (i >= 0)
    printf ("%s\n", opinion[i % OPIMAX]);
  else if (i == -1)
    for (i = 0; i < OPIMAX; i++)
      printf ("%s\n", opinion[i]);
  return (OPIMAX);
}
#endif /* OMAKE */


 /** ѴХåեΥꥢ */
void
romkan_clear ()
{
#ifdef KDSP
#  ifdef MVUX
  *displine = EOLTTR;
#  endif
#endif
  ungetc_buf = *keybuf = *urabuf = *disout = *rk_output = EOLTTR;
  curdis = DISOUT;
  lastoutlen = lastkbflen = 0;
}

 /**    ɽɤ߹Ѵν򤹤롣part 1*/
int
romkan_init (modhyo, delchr_, chmoutf, keyinfn, bytcntfn)
     char *modhyo, chmoutf;
     letter delchr_;
letter (*keyinfn) ();
     int (*bytcntfn) ();        /* ξܺ٤romkan_init3򻲾 */
{
  return (romkan_init2 (modhyo, delchr_, chmoutf, keyinfn, bytcntfn, 0, 0, 0));
}

#define ifflg(a, b) ((a) ? (b) : 0)

 /**    ɽɤ߹Ѵν򤹤롣part 2: ϤФɬ
        ֤褦ˤ뤫Хåե򥯥ꥢ뤫ɤʤɤġ*/
int
romkan_init2 (modhyo, delchr_, chmoutf, keyinfn, bytcntfn, keyackf, restartf, nonisecodf)
     char *modhyo, chmoutf, keyackf, restartf, nonisecodf;
     letter delchr_;
letter (*keyinfn) ();
     int (*bytcntfn) ();        /* ξܺ٤romkan_init3򻲾 */
{
  return (romkan_init3 (modhyo, delchr_, toNISE (delchr_), EOLTTR,
                        keyinfn, bytcntfn, (int (*)()) NULL, restartf, ifflg (chmoutf, RK_CHMOUT) | ifflg (keyackf, RK_KEYACK) | ifflg (nonisecodf, RK_NONISE) | RK_DSPNIL));
}

 /**    ɽɤ߹Ѵν򤹤롣part 3*/
int
romkan_init3 (modhyo, delchr_, nisedl_, delchr2_, keyinfn, bytcntfn, kbytcntfn, restartf, flags_)
     char *modhyo;              /* ⡼ɽ̾ϤΥѥ̾ */
     letter delchr_;            /* DELȤƻȤ */
     letter nisedl_;            /* DELȤƻȤ */
     letter delchr2_;           /* DELȤƻȤɤĤ礽Τ⤦ */
letter (*keyinfn) ();           /* ؿ */
     int (*bytcntfn) ();        /* Хȥȴؿ */
     int (*kbytcntfn) ();       /* βѥХȥȴؿNULLλ
                                   bytcntfnƱΤȤ */
     char restartf;
 /*     rk_rst()⤫ƤФ줿Ωĥե饰줬ΩĤȡХåե򥯥ꥢ
    ˺Ѥޤλϥ顼лΥå⾯ۤʤ */
     int flags_;
 /* ʲΥե饰Ѳġrk_spclval.hˤ
    RK_CHMOUT:⡼ɥ󥸤Τ餻륳ɤ֤
    RK_KEYACK:Фɬ֤
    RK_DSPNIL:romkan_disp(off)modeΥǥեȤʸˤ뤫
    RK_NONISE:ɤФʤ褦ˤ뤫
    RK_REDRAW:Wnnüե饰redrawѤΥե饰Фɤ
    RK_SIMPLD:deleteưñˤ뤫
    RK_VERBOS:verbose⡼ɤǵ
  */
{
  int errcod;                   /* ν1Τ */

  /* ɤФromkan_clearǻȤΤǡե饰
     ˤäƤʤȤʤ */
  if ((flags = flags_) & RK_VERBOS)
    {
      fprintf (stderr, "romkan_init invoked.\r\n");
      fflush (stderr);
    }

#ifdef  OMAKE
  if (modhyo == NULL)
    takeoka (-1);               /* ޤ̾ϼ¹Ԥʤ */
#endif /* OMAKE */

  keyin_method = keyinfn;
  bytcnt_method = (bytcntfn == NULL ? head_bytecount : bytcntfn);
  kbytcnt_method = (kbytcntfn == NULL ? bytcnt_method : kbytcntfn);
  strcpy (prv_modfnm, modhyo);

  delchr = delchr_;
  nisedl = nisedl_;
  delchr2 = delchr2_;
 /**    ¤DELΥ饯ĤޤǻƤ롣ܡdelchr2ϡ̤
        ȤͤEOLTTRˤ̵뤵롣ʳϡdelchr2Ϥ
        delchrϤ줿ΤƱ񤤤򤹤롣*/

  if ((errcod = setjmp (env0)) != 0)
    {
      fprintf (stderr, "romkan_init failed.");
      if (!restartf)
        {
          romkan_reset ();
          /*     fprintf(stderr,
             "No conversion is currently performed."); */
          fprintf (stderr, "\r\n");
        }
      else
        {
          fprintf (stderr, "Conversion method was unchanged.\r\n");
        }
    }
  else
    {
      readdata (memory, data, hensudefhyo, modhyo);
      if (!restartf)
        {
          romkan_clear ();
          hank_setup ();
        }
    }

  if (!errcod && (flags & RK_VERBOS))
    {
      fprintf (stderr, "romkan_init finished.\r\n");
      fflush (stderr);
    }
  return (errcod);              /* ｪλʤ0 */
}

 /**    ХȥȴؿΥǥեȡsλؤƤäƤΤ
        Хȥɤ֤
        romkan_nextաǤϡХȥȴؿͤ
        ΰʸܤˤΤ߰¸ȲꤷƤ롣*/
static int
head_bytecount (s)
     uns_chr *s;
{
#ifdef IKIS
  return ((*s <= 0xa0 || *s == 0xff) ? 1 : 2);
#else
  return (((*s <= 0xa0 && *s != HNKAK1) || *s == 0xff) ? 1 : 2);
#endif
}

 /** Ѵ줿ʸ缡֤ */
/* *INDENT-OFF* */
letter
romkan_getc ()
/* *INDENT-ON* */
{
  letter l;

  /* ungetcƤϡФ */
  if (ungetc_buf != EOLTTR)
    return (l = ungetc_buf, ungetc_buf = EOLTTR, l);

  while (*curdis == EOLTTR)
    {
      /* romkan_next()ͤLTREOFλ⡢Τޤɤ */
      curdis = romkan_henkan (romkan_next ());

      /* keyackflg0ʤ顢󤬤ɬ֤
         ᡢ֤٤ΤʤEOLTTR֤Ȥˤ롣 */
      if (flags & RK_KEYACK)
        break;
    }

  if (EOLTTR != (l = *curdis))
    curdis++;
  return (l);
  /* ʪʸʤ顢HG1BITΩäƤ롣 */
  /* ̤ʥ(㤨еBEEPȤNISEBP)֤Ȥ롣
     rk_spclval.hƤ롣 */
}

 /**    romkan_getcβ̴ؿȤơϤʸä
        Ѵ̤ʸϤ롣*/
letter *
romkan_henkan (mae_in)
     letter mae_in;
{
  letter mae_out[2], *p;

  /* if(*curdis != EOLTTR){p = curdis; curdis = nil; return(p);} */
  /* Ǥmae_in̵뤵 */
  curdis = nil;

  /* ؤϤϾˤʸ */
  mae_out[0] = mae_out[1] = EOLTTR;

  eofflg = rk_errstat = 0;
  *rk_output = *disout = EOLTTR;

  maeato_henkan (mae_in, mae_out, usemaehyo);
  rk_input = *mae_out;

  if (rk_input == LTREOF)
    {
      /* LTREOF褿硢(error)̵뤷ܽХåե
         Ѵ롣Τeofflg1ˤ롣θ塢̤
         ˡLTREOF褿̥ɡʻꤵƤСˤȡ
         LTREOFĤʤ */
      eofflg = 1;
      match ();

      eofflg = 2;
      add_at_eof ();            /* codeoutˡLTREOF褿Фɤ롣 */
      ltr1cat (codeout, LTREOF);

      ltrcat (disout, codeout);
      ltrcat (rk_output, codeout);
    }
  else if (rk_input == EOLTTR)
    {
      /* EOLTTR褿⡢ƱͤνԤLTREOF
         Ĥʤʤʤromkan_getc()ƤǤ
         ʤromkan_next()EOLTTR֤ʤˡ */
      eofflg = 1;
      match ();
    }
  else if (rk_input == delchr || rk_input == delchr2)
    {
      /* delchr2̤ʤ餽ͤEOLTTRʤΤrk_inputʤ */
      rk_delete (rk_input);
    }
  else
    {
      ltr1cat (keybuf, rk_input);
      ltr1cat (disout, toNISE (rk_input));
      match ();
    }

  if (!(flags & RK_CHMOUT))
    {
      /* chmoutflg0λϡCHMSIGФʤ */
      for (p = DISOUT;; p++)
        {
          while (*p == CHMSIG)
            ltrcpy (p, p + 1);
          if (*p == EOLTTR)
            break;
        }
    }

  if ((flags & RK_REDRAW) && NULL != (p = ltr_rindex (disout, nisedl)))
    {
      for (p++; *p != EOLTTR || (ltr1cat (disout, REDRAW), 0); p++)
        if (!isSPCL (*p))
          break;
    }
  /* wnnredrawΥե饰ΩäƤơdisoutnisedlʸü쥳ɤΤ
     ǽäƤ顢REDRAWФơWnnѴԤredraw򤵤롣 */

  return (DISOUT);
}


 /* ǥХåѴؿ */
#ifdef KDSP
#  ifdef MVUX

void
pridbg2 (a, b, c)
     char *a, *c;
     letter *b;
{
  printf ("%s", a);
  dump_fordbg (b);
  printf ("%s", c);
}

int
ltr_displen (l)
     letter l;
{
  while (l >= 256)
    l >>= 8;

  if (l == 0)
    return (0);
  if (l < ' ')
    return (0);
  if (168 <= l && l <= 170)
    return (1);
  return (l > 160 ? 2 : 1);
}

void
dump_fordbg (lp)
     letter *lp;
{
  while (*lp != EOLTTR)
    printf ("%x/", *lp++);
}

void
print_fordbg (lp)
     letter *lp;
{
  while (*lp != EOLTTR)
    putletter (*lp++ & ~HG1BIT);
}

void
print_ltrseq (lp)
     letter *lp;
{
  while (*lp != EOLTTR)
    print_ltr (*lp++ & ~HG1BIT);
}

void
print_ltr (l)
     letter l;
{
  letter *disptail;
  int i;

  if (!isSPCL (l))
    l &= ~HG1BIT;

  if (l == CHMSIG)
#ifdef CHMDSP
    printf ("...mode=%s\n", romkan_dispmode ())
#endif
      ;
  else
#define BEEPCH  '\007'
#define NEWLIN  '\n'
  if (l == BEEPCH || l == NISEBP)
    putchar (BEEPCH);
  else if (l == NEWLIN)
    {
      *displine = *keybuf = *urabuf = EOLTTR;
      lastoutlen = lastkbflen = 0;
      putchar (l);
    }
  else if (l == delchr || l == nisedl)
    {
      if (*displine == EOLTTR)
        putchar (BEEPCH);
      else
        {
          disptail = ltrend (displine);
          for (i = ltr_displen (*disptail); i; i--)
            printf ("\031 \031");
          *disptail = EOLTTR;
        }
    }
  else
    {
      ltr1cat (displine, l);
      putletter (l);
    }
}

#  endif /* of #ifdef MVUX */
#endif
/* ǥХåѴؿ */


 /** DELϤ줿Ȥν򤹤 */
static void
rk_delete (input_del)
     letter input_del;
{
  if (ltrlen (keybuf) > ((flags & RK_SIMPLD) ? 0 : lastkbflen))
    {
      ltr1cut (keybuf);
      set_rubout (disout, 1, nisedl);
    }
  else
    {
      if (*urabuf != EOLTTR && !(flags & RK_SIMPLD))
        {
          ltr1cut (ltrcpy (keybuf, urabuf));
          *urabuf = EOLTTR;

          set_rubout (rk_output, lastoutlen, input_del);

          set_rubout (disout, lastkbflen, nisedl);
          bitup_ltrcat (ltrcat (disout, rk_output), keybuf);

          lastkbflen = lastoutlen = 0;
        }
      else
        {
          set_rubout (disout, 1, input_del);
          set_rubout (rk_output, 1, input_del);
        }
    }
}

 /**    letter lp1  lp2 Υޥåߤ롣ͤϡlp1lp2Ƭ
        פλ -1lp1ޤϤƬlp2פΤȤϰĹlp2
        ʸλޤࡣξͤ0ˡʳ -2
        lp2¦˼ޤޤƤɾ򤹤롣lp1¦ˤϼޤǤϤ */
static int
prefixp (lp1, lp2)
     letter *lp1, *lp2;
{
  /* 1ԥޥå뤴Ȥˡޤmatch򥯥ꥢƤ顣
     Ĥޤꡢhenmatch[0] . ltrmch = EOLTTR; ȤƤ */

  register int mch_len = 0, d_len;

  for (;;)
    {
      if (*lp2 == EOLTTR)
        return (mch_len);
      if (*lp1 == EOLTTR)
        return (-1);
      if ((d_len = p_eq (&lp2, &lp1)) < 0)
        return (d_len);
      mch_len += d_len;
    }
}

 /** numܤѿˤʸȥޥåƤȲꤷơʸ֤ */
static letter
mchedsrc (num)
     int num;
{
  struct matchpair *pairptr;

  for (pairptr = henmatch; pairptr->ltrmch != EOLTTR; pairptr++)
    {
      if (num == pairptr->hennum)
        return (pairptr->ltrmch);
    }
  return (BUGreport (8), 0);
}

 /**    numܤѿʸ l ȥޥå뤫Ĵ٤롣ѿunboundä
         l bind롣ޥå(bindλޤ)1ʤ0֤ */
static int
mchsrc (num, l)
     int num;
     letter l;
{
  struct matchpair *pairptr;

  if (hen_ikisrc (num, l) == 0)
    return (0);
  for (pairptr = henmatch; pairptr->ltrmch != EOLTTR; pairptr++)
    {
      if (num == pairptr->hennum)
        return (pairptr->ltrmch == l);
    }

  pairptr->ltrmch = l;
  pairptr->hennum = num;
  (++pairptr)->ltrmch = EOLTTR;
  return (1);
}

 /**    l1pñ̤äɾʸl2Ȱפ뤫ɤ֤ɾ
        ̤ʸˤʤʤä顢פʤ*/
static int
l_eq (l1p, l2)
     letter *l1p, l2;
{
  letter evlrsl[RSLMAX];

  switch (SHUBET (*l1p))
    {
    case 0:
      return (*l1p == l2);
    case 1:
      return (mchsrc ((int) LWRMSK (*l1p), l2));
    case 2:
      mchevl (&l1p, evlrsl);
      return (evlrsl[0] == l2 && evlrsl[1] == EOLTTR);
    default:
      return (BUGreport (1), 0);
    }
}

 /**    prefixpǻ  âνϵաʤޤޤ줦Τl1pp¦
        Τߡl1ppñ̤֤äɾΤl2ppΥޥåߤ롣
        l2ppޤϤƬȥޥåаĹ֤l1ppɾ̤ʸ
        λޤࡣξͤ0ˡդl1ppɾ̤Ƭl2ppޥ
         -1֤ޥåԤͤ -2*/
static int
p_eq (l1pp, l2pp)
     register letter **l1pp, **l2pp;
{
  int num;
  letter evlrsl[RSLMAX], *rslptr;
  register int retval = -2;

  /*  l2pp¦ˤϼޤޤʤȦ */
  if (!is_HON (**l2pp))
    {
      /*  if(is_HON(**l1pp)) retval = p_eq(l2pp, l1pp); else  */
      BUGreport (9);
    }
  else
    {
      switch (SHUBET (**l1pp))
        {
        case 0:         /* ʸƱ */
          retval = (*(*l1pp)++ == *(*l2pp)++ ? 1 : -2);
          break;
        case 1:         /* ѿʸ */
          num = LWRMSK (*(*l1pp)++);
          retval = (mchsrc (num, *(*l2pp)++) ? 1 : -2);
          break;
        case 2:         /* ʸ */
          mchevl (l1pp, rslptr = evlrsl);
          for (retval = 0; *rslptr != EOLTTR; retval++)
            {
              if (**l2pp == EOLTTR)
                {
                  retval = -1;
                  break;
                }
              else if (*rslptr++ != *(*l2pp)++)
                {
                  retval = -2;
                  break;
                }
            }
          break;
        default:
          BUGreport (2);
        }
    }

  return (retval);
}

 /** l1pñɾl2p */
static void
mchevl (l1pp, l2p)
     letter **l1pp, *l2p;
{
  letter *l1p, tmpevl[RSLMAX];

  l1p = *l1pp;

  switch (SHUBET (*l1p))
    {
    case 0:
      *l2p++ = *l1p++;
      break;
    case 1:
      *l2p++ = mchedsrc ((int) LWRMSK (*l1p++));
      break;
    case 2:                     /* toupper, tolower, error,  */
      switch (LWRMSK (*l1p++))
        {
        case 2:
          mchevl (&l1p, tmpevl);
          *l2p++ = to_upper (*tmpevl);
          break;
        case 3:
          mchevl (&l1p, tmpevl);
          *l2p++ = to_lower (*tmpevl);
          break;
        case 4:
          *l2p++ = CHMSIG;
          *l2p++ = LWRMSK (*l1p++);
          *l2p++ = 0;
          break;                /* EOLǤϤʤ */
        case 5:
          *l2p++ = CHMSIG;
          *l2p++ = LWRMSK (*l1p++);
          *l2p++ = 1;
          break;
        case 6:
          *l2p++ = CHMSIG;
          *l2p++ = XY2INT (2, LWRMSK (*l1p++));
          *l2p++ = 1;
          break;
        case 7:
          mchevl (&l1p, tmpevl);
          *l2p++ = to_updown (*tmpevl);
          break;
        case 8:
          mchevl (&l1p, tmpevl);
          *l2p++ = to_zenalpha (*tmpevl);
          break;
        case 9:
          mchevl (&l1p, tmpevl);
          *l2p++ = to_hira (*tmpevl);
          break;
        case 10:
          mchevl (&l1p, tmpevl);
          *l2p++ = to_kata (*tmpevl);
          break;
        case 11:
          mchevl (&l1p, tmpevl);
          to_hankata (*tmpevl, &l2p);
          break;                /* ü */
        case 12:
          mchevl (&l1p, tmpevl);
          *l2p++ = to_zenhira (*tmpevl);
          break;
        case 13:
          mchevl (&l1p, tmpevl);
          *l2p++ = to_zenkata (*tmpevl);
          break;
        case 14:
          mchevl (&l1p, tmpevl);
          *l2p = *tmpevl;
          mchevl (&l1p, tmpevl);
          *l2p += *tmpevl;
          LWRCUT (*l2p++);
          break;
        case 15:
          mchevl (&l1p, tmpevl);
          *l2p = *tmpevl;
          mchevl (&l1p, tmpevl);
          *l2p -= *tmpevl;
          LWRCUT (*l2p++);
          break;
        case 16:
          mchevl (&l1p, tmpevl);
          *l2p = *tmpevl;
          mchevl (&l1p, tmpevl);
          *l2p *= *tmpevl;
          LWRCUT (*l2p++);
          break;
        case 17:
          mchevl (&l1p, tmpevl);
          *l2p = *tmpevl;
          mchevl (&l1p, tmpevl);
          if (!*tmpevl)
            *l2p = LTRHUG;
          else
            *l2p /= *tmpevl;
          LWRCUT (*l2p++);
          break;
        case 18:
          mchevl (&l1p, tmpevl);
          *l2p = *tmpevl;
          mchevl (&l1p, tmpevl);
          if (!*tmpevl)
            *l2p = LTRHUG;
          else
            *l2p %= *tmpevl;
          LWRCUT (*l2p++);
          break;
          /* 192130ϡȶʸ
             ǤʤUNUSDCʸȤ֤ */
        case 19:
          mchevl (&l1p, tmpevl);
          if (lastmch () != *tmpevl)
            *l2p++ = UNUSDC;
          break;
        case 20:
          if (!modesw[LWRMSK (*l1p++)].curmode)
            *l2p++ = UNUSDC;
          break;
        case 21:
          if (modesw[LWRMSK (*l1p++)].curmode)
            *l2p++ = UNUSDC;
          break;
        case 22:
          *l2p++ = REASIG;
          break;
        case 23:
          *l2p++ = delchr;
          break;
        case 24:
          *l2p++ = CHMSIG;
          *l2p++ = XY2INT (1, 0);
          /* ǡallפɽ */
          *l2p++ = 0;
          break;
        case 25:
          *l2p++ = CHMSIG;
          *l2p++ = XY2INT (1, 0);
          *l2p++ = 1;
          break;
        case 26:
          mchevl (&l1p, tmpevl);
          *l2p = *tmpevl;
          mchevl (&l1p, tmpevl);
          *l2p &= *tmpevl;
          LWRCUT (*l2p++);
          break;
        case 27:
          mchevl (&l1p, tmpevl);
          *l2p = *tmpevl;
          mchevl (&l1p, tmpevl);
          *l2p |= *tmpevl;
          LWRCUT (*l2p++);
          break;
        case 28:
          mchevl (&l1p, tmpevl);
          *l2p = ~(*tmpevl);
          LWRCUT (*l2p++);
          break;
        case 29:
          *l2p++ = URBFCL;
          break;
        case 30:
          if (eofflg != 2 || *keybuf != EOLTTR)
            *l2p++ = UNUSDC;
          break;
        case 31:
          {
            letter code, basenum;

            mchevl (&l1p, tmpevl);
            code = *tmpevl;
            mchevl (&l1p, tmpevl);
            if ((basenum = *tmpevl) <= 1 || BASEMX < basenum)
              basenum = 10;
            to_digit (code, basenum, &l2p);
          }
          break;
        case 32:
          mchevl (&l1p, tmpevl);
          dakuadd (*tmpevl, &l2p);
          break;                /* ü */
        case 33:
          mchevl (&l1p, tmpevl);
          handakuadd (*tmpevl, &l2p);
          break;                /* ü */
        case 34:
          mchevl (&l1p, tmpevl);
          *l2p++ = ltov (*tmpevl);
          break;
        case 35:
          *l2p++ = ERRCOD;
          break;
          /* case 36: omitted */
        case 37:
          *l2p++ = CHMSIG;
          *l2p++ = LWRMSK (*l1p++);
          *l2p++ = *l1p++;
          break;
        case 38:
          *l2p++ = CHMSIG;
          *l2p++ = XY2INT (2, LWRMSK (*l1p++));
          *l2p++ = *l1p++;
          break;
        case 39:
          *l2p++ = CHMSIG;
          *l2p++ = XY2INT (3, LWRMSK (*l1p++));
          *l2p++ = *l1p++;
          break;
        case 40:
          {
            letter modnum;

            modnum = LWRMSK (*l1p++);
            if (modesw[modnum].curmode != *l1p++)
              *l2p++ = UNUSDC;
            break;
          }
        case 41:
          {
            letter modnum;

            modnum = LWRMSK (*l1p++);
            if (modesw[modnum].curmode == *l1p++)
              *l2p++ = UNUSDC;
            break;
          }
        case 42:
          {
            letter modnum;

            modnum = LWRMSK (*l1p++);
            if (modesw[modnum].curmode >= *l1p++)
              *l2p++ = UNUSDC;
            break;
          }
        case 43:
          {
            letter modnum;

            modnum = LWRMSK (*l1p++);
            if (modesw[modnum].curmode <= *l1p++)
              *l2p++ = UNUSDC;
            break;
          }
        case 44:
          mchevl (&l1p, tmpevl);
          *l2p++ = SENDCH;
          *l2p++ = *tmpevl;
          break;
        default:                /* case 0ڤӾ嵭ʳ */ ;
          BUGreport (7);
        }
    }

  *l2p = EOLTTR;
  *l1pp = l1p;
}

 /** numܤѿѰ褬ʸ l ޤफɤ֤ */
static int
hen_ikisrc (num, l)
     int num;
     letter l;
{
  letter *defptr;

  defptr = hyo_n[hyonum].hensudef[num];
  if (*defptr == VARRNG)
    {
      for (defptr++; *defptr != EOLTTR;)
        if (*defptr++ <= l && l <= *defptr++)
          return (1);
      return (0);
    }

  for (; *defptr != EOLTTR; defptr++)
    {
      if (l == *defptr)
        return (1);
    }
  return (0);
}

 /**    ѴΥᥤ롼ܽԤĤǤ˸äƤ롣
        ʤߤϡromkan_getcβ̴ؿromkan_henkanǡ
        δؿƤˤäƤ롣
        δؿϡromkan_nextʸ٤˸ƤФ롣ƤӽФ줿ľ
        output϶ʸdisoutˤϥɰʸäƤ롣
        δؿʸ󤬡romkan_henkanϤꡢ
        romkan_getcϡʸȤʬ򤷤֤
        (error)ǥ顼줿0֤ｪλ1֤ */
int
match ()
{
  int henkanflg = 0, okcode = 0, chm_exist;
  letter *p;
  letter urabufcreate[KBFSIZ], orgkeybuf[KBFSIZ], kbftail[KBFSIZ];
  letter *urabufjunbi, *outcutptr, *dis_end;

  if (*keybuf == EOLTTR)
    {
      *urabuf = EOLTTR;
      return (1);
    }

  ltrcpy (urabufjunbi = orgkeybuf, keybuf);
  outcutptr = rk_output;

  while ((okcode = henkan_ok ()) > 0)
    {
      henkanflg = 1;

      codeout_chg ();
      ltrcat (rk_output, codeout);

      ltrcpy (kbftail, keybuf + codein_len);
      ltrcat (ltrcpy (keybuf, remainkbf), kbftail);

      if (okcode == 2)
        {
          ltrcpy (urabufjunbi = urabufcreate, keybuf);
          totail (outcutptr);
        }
    }

  if (okcode == 0)
    {
      ltr1cut (ltrcpy (keybuf, orgkeybuf));
      ltr_to_ltrseq (disout, NISEBP);
      *rk_output = EOLTTR;
      return (0);
    }
  if (henkanflg)
    {
      ltrcpy (urabuf, urabufjunbi);

      set_rubout (disout, ltrlen (orgkeybuf) - 1, nisedl);

      dis_end = disout;
      totail (dis_end);
      ltrcpy (dis_end, rk_output);

      /* ⡼ɥ󥸤ľΤ餻뤿 CHMSIG
         flagsRK_CHMOUTΩäƤʤȡȤǰʸĤ
         ʬ򤹤ǡCHMSIG򥫥åȡˡ
         ârk_outputϡCHMSIGȴ
         ޤCHMSIGˣ󤷤Ϥʤ
         ʣʾ夢äƤ⡢ˤޤȤơ֤ˡ */
      for (chm_exist = 0, p = rk_output;; p++)
        {
          while (*p == CHMSIG)
            {
              chm_exist = 1;
              if (ltrcpy (p, p + 1) < outcutptr)
                outcutptr--;
            }
          if (*p == EOLTTR)
            break;
        }
      if (chm_exist)
        {
          /* CHMSIG򣱤ĤˤޤȤ᤿Τdis_endˤĤʤľ
             ifʸ򥫥åȤСCHMSIGΤȤޤȤϤʤ */
          ltr1cat (ltrcpy (dis_end, rk_output), CHMSIG);
        }

      bitup_ltrcat (disout, keybuf);
      lastoutlen = ltrlen (outcutptr);
      lastkbflen = ltrlen (keybuf);
    }
  return (1);
}

 /**    LTREOFäȤˡФ褦˻ꤵƤ뤫Ĵ٤ơ
        codeout򤽤η̤ʸʻ꤬ʤäˤ˥ݥȤ롣
        Ķޤ館ǡü쥳ϰ̵뤹롣*/
static void
add_at_eof ()
{
  register struct dat *datptr;
  register int i;
  int hyoseq;
  letter evlrsl[RSLMAX], *p;

  for (hyoseq = 0; (hyonum = usehyo[hyoseq]) != -1; hyoseq++)
    {
      for (i = 0, datptr = hyo_n[hyonum].data; NULL != (p = datptr[i].code[0]); i++)
        {
          henmatch[0].ltrmch = EOLTTR;
          while (*p != EOLTTR)
            {
              switch (SHUBET (*p))
                {
                case 0: /* ʸ */
                case 1: /* ѿ */
                  /* 餬ϡNULLȤ
                     ޥåʤ */
                  goto Pass;
                case 2: /*  */
                  mchevl (&p, evlrsl);
                  if (*evlrsl != EOLTTR)
                    goto Pass;
                  /* ϥˡɾ
                     ʸˤʤΤ¾ˤϤʤ
                     Ȥ */
                }
            }

          ltrevlcpy (codeout = p = evalbuf[0][0], datptr[i].code[1]);
          while (*p != EOLTTR)
            {
              if (isSPCL (*p))
                ltrcpy (p, p + 1);
              else
                p++;
            }
          codeout_chg ();
          return;

        Pass:;
        }
    }
  codeout = nil;
}

 /**    ޥåߤ롣ͤϡޥåƳꤷ1ʥ⡼ɥ󥸤
        äƤ2ˡޥå̤λ-1ޥåʤä0
        ¹ϡѿ l ˡޤǤ˰פĹκǹ⵭ϿƤꡢ
        ĹפΤĤ뤴Ȥˡ򹹿롣lͤϡޥå
        ƤƤ0ˤʤ뤳Ȥ⤢롣p_eq() ڤ prefixp() ʸ򻲾ȡ*/
static int
henkan_ok ()
{
  register struct dat *datptr;
  register int i, k;
  int l, j, hyoseq;
  char urabuf_clrf;             /* ⡼ɥ󥸤ʤɤǡurabuf򥯥ꥢɬפ
                                   Ϥ줬Ωη̡henkan_ok()
                                   1֤٤Ȥ2֤򸫤ơ
                                   match()urabufʤɤĴ򤹤롣 */
  register letter *p;

  if (*keybuf == EOLTTR)
    return (-1);

  for (l = -1, hyoseq = 0; (hyonum = usehyo[hyoseq]) != -1; hyoseq++)
    {
      for (i = 0, datptr = hyo_n[hyonum].data; NULL != (p = datptr[i].code[0]); i++)
        {
          henmatch[0].ltrmch = EOLTTR;
          switch (k = prefixp (keybuf, p))
            {
            case -2:
              break;
            case -1:
              if (eofflg != 0)
                break;
              /* eofflgΩäƤ顢̤βǽ
                 ΤƤ롣 */

              return (-1);
            default:
              if (k > l)
                {
                  ebf_sw = !ebf_sw;
                  for (j = 1; j <= 2; j++)
                    {
                      ltrevlcpy (evalbuf[ebf_sw][j - 1], datptr[i].code[j]);
                    }

                  l = k;
                }
            }
        }
    }

  if (l >= 0)
    {
      codein_len = l;
      codeout = evalbuf[ebf_sw][0];
      remainkbf = evalbuf[ebf_sw][1];

      for (urabuf_clrf = 0, p = codeout; *p != EOLTTR;)
        {
          switch (*p)
            {
            case CHMSIG:
              p++;
              /* codeout1Хܤ˴ؿΥåȥ⡼ֹ桢
                 2Хܤ˥⡼ɤο֤äƤ */
              switch (SHUBET (*p))
                {
                case 0:
                  chgmod ((int) *p, (modetyp) * (p + 1));
                  break;
                case 1:
                  allchgmod ((modetyp) * (p + 1));
                  break;
                case 2:
                  incmod ((int) LWRMSK (*p), (modetyp) * (p + 1));
                  break;
                case 3:
                  decmod ((int) LWRMSK (*p), (modetyp) * (p + 1));
                  break;
                }
              ltrcpy (p, p + 2);
              /* CHMSIGĤ1,2Хcut */

              urabuf_clrf = 1;
              break;
            case URBFCL:
              /* urabufΥꥢŪ˻ꤹ */
              urabuf_clrf = 1;
              ltrcpy (p, p + 1);
              break;
            default:
              p++;
            }
        }

      if (*codeout == ERRCOD)
        {
          if (eofflg == 0)
            {
              rk_errstat = 1;
              return (0);
            }

          /* (error)ǤäơeofflgΩäƤ顢keybuf
             ޤǡΤޤ޽Ф */
          codein_len = ltrlen (keybuf);
          codeout = ltrcpy (evalbuf[ebf_sw][0], keybuf);
          remainkbf = nil;
          rk_errstat = 2;

          return (1);
        }
      /* (error)ñȤǤ񤱤ʤΤǡ顼ФϤǽʬ */

      if (*codeout == REASIG)
        {
          *codeout = (rk_rst () != 0 ? EOLTTR : CHMSIG);
          /* readǥä⡼ɥ󥸤ΤϤʤ */

          urabuf_clrf = 1;
        }
      /* ɽκreadâ줬äȤ򳰤Τ餻ΤCHMSIG
         ΥɤΤΤϳؽФʤ(restart)ϡ(error)Ʊ͡
         ñȤǤ񤱤ʤΤǡФϤǽʬ */

      return (urabuf_clrf ? 2 : 1);
    }

  /* ɽ˸ƤʤɤϤΤޤ֤ */

  codein_len = 1;
  *(codeout = oneletter) = *keybuf;
  remainkbf = nil;
  return (1);
}

 /* rk_rstǻȤޥ */
#define taihi(X, Y, N) {for(i = 0; i < N; i++) X[i] = Y[i];}
#define recov(X, Y, N) taihi(Y, X, N)

 /**    ɽưŪɤ߹ߤ򤹤롣ߤɽ򤷡Ʊ
        ǥ쥯ȥʤˡߤΤȤˤɽɤ߹ࡣ⤷
        ɤ߹˥顼򸡽ФСȤǡ褷0֤*/
static int
rk_rst ()
{
  register int i;
  int j;

  letter memoryt[SIZALL];
  struct dat datat[LINALL];
  struct hyo hyo_nt[HYOMAX];
  letter *hensudefhyot[VARTOT];
  struct modestat modeswt[MODMAX];
  char hyoshut[HYOMAX];
  char *modmeibgnt[MODMAX], modmeimem_t[MODMEI];
  char *dspnambgnt[DMDMAX], dspcod_t[DMDCHR];
  int usemaehyot[HYOMAX], usehyot[HYOMAX], useatohyot[HYOMAX];
  int naibu_t[NAIBMX];
  char *dspmodt[2][2];

  taihi (memoryt, memory, SIZALL);
  taihi (datat, data, LINALL);
  taihi (hyo_nt, hyo_n, HYOMAX);
  taihi (hensudefhyot, hensudefhyo, VARTOT);
  taihi (modeswt, modesw, MODMAX);
  taihi (hyoshut, hyoshu, HYOMAX);
  taihi (modmeibgnt, modmeibgn, MODMAX);
  taihi (modmeimem_t, modmeimem_, MODMEI);
  taihi (dspnambgnt, dspnambgn, DMDMAX);
  taihi (dspcod_t, dspcod_, DMDCHR);
  taihi (usemaehyot, usemaehyo, HYOMAX);
  taihi (usehyot, usehyo, HYOMAX);
  taihi (useatohyot, useatohyo, HYOMAX);
  taihi (naibu_t, naibu_, NAIBMX);
  for (i = 0; i < 2; i++)
    for (j = 0; j < 2; j++)
      dspmodt[i][j] = dspmod[i][j];

  if (0 == romkan_init3 (prv_modfnm, delchr, nisedl, delchr2, keyin_method, bytcnt_method, kbytcnt_method, 1, flags & ~RK_VERBOS))
    return (0);                 /* ｪλ */

  recov (memoryt, memory, SIZALL);
  recov (datat, data, LINALL);
  recov (hyo_nt, hyo_n, HYOMAX);
  recov (hensudefhyot, hensudefhyo, VARTOT);
  recov (modeswt, modesw, MODMAX);
  recov (hyoshut, hyoshu, HYOMAX);
  recov (modmeibgnt, modmeibgn, MODMAX);
  recov (modmeimem_t, modmeimem_, MODMEI);
  recov (dspnambgnt, dspnambgn, DMDMAX);
  recov (dspcod_t, dspcod_, DMDCHR);
  recov (usemaehyot, usemaehyo, HYOMAX);
  recov (usehyot, usehyo, HYOMAX);
  recov (useatohyot, useatohyo, HYOMAX);
  recov (naibu_t, naibu_, NAIBMX);
  for (i = 0; i < 2; i++)
    for (j = 0; j < 2; j++)
      dspmod[i][j] = dspmodt[i][j];
  return (1);
}

 /** lp2ɾʸlp1˥ԡ */
static void
ltrevlcpy (lp1, lp2)
     letter *lp1, *lp2;
{
  while (*lp2 != EOLTTR)
    {
      mchevl (&lp2, lp1);
      totail (lp1);
    }
  *lp1 = EOLTTR;
}

static void
set_rubout (lp, n, del)
 /** lp delnĤ򥻥åȤ롣 del  'delchr''nisedl' */
     letter *lp, del;
     int n;
{
  for (; n; n--)
    *lp++ = del;
  *lp = EOLTTR;
}

 /** 줬¹Ԥ줿Хâ¹ԤϤΤޤ³ */
void
BUGreport (n)
     int n;
{
  fprintf (stderr, "\r\nromkan-Bug%d!!\r\n", n);
}

 /** (mae_inmae_out)ϸ(ato_inato_out)Ԥ*/
static void
maeato_henkan (in, outp, m_a_hyo)
     letter in;                 /* Ϥΰʸ */
     letter *outp;              /* ϤϤ */
     int *m_a_hyo;              /* ɤɽ򤵤Ƥ뤫ξ */
{
  struct dat *datptr;
  int i, hyoseq;
  letter *curdat;

  if (isSPCL (in))
    {
      /* LTREOFCHMSIG褦Τǡü쥳ɤϤΤޤ֤褦
         ٹƤʤȤʤ */
      ltr_to_ltrseq (outp, in);
      return;
    }

  for (hyoseq = 0; (hyonum = m_a_hyo[hyoseq]) != -1; hyoseq++)
    {
      for (i = 0, datptr = hyo_n[hyonum].data; NULL != (curdat = datptr[i].code[0]); i++)
        {
          henmatch[0].ltrmch = EOLTTR;
          if (!l_eq (curdat, in))
            continue;

          ltrevlcpy (outp, datptr[i].code[1]);
          return;
        }
    }
  ltr_to_ltrseq (outp, in);
}

 /**  */
static void
codeout_chg ()
{
  letter *saishu_outp;

  *(saishu_outp = saishu_out) = EOLTTR;

  for (; *codeout != EOLTTR; codeout++)
    {
      maeato_henkan (*codeout, saishu_outp, useatohyo);
      totail (saishu_outp);
    }

  codeout = saishu_out;
}

 /** ʸץå塦Хå */
/* *INDENT-OFF* */
letter
romkan_ungetc (l)
     letter l;
/* *INDENT-ON* */
{
  return (ungetc_buf = l);
}

 /** romkan_nextФʸץå塦Хå */
/* *INDENT-OFF* */
letter
romkan_unnext (l)
     letter l;
/* *INDENT-ON* */
{
  return (unnext_buf = l);
}

 /**    deleteȤƻȤ饯ʵdeleteˡ¹Ը
        romkan_clear¹ԤƤʤȺΤȤˤʤޤ*/
/*      ѻߡ
void
romkan_setdel(delchr_, nisedl_)
letter  delchr_, nisedl_;
{
        delchr = delchr_;
        nisedl = nisedl_;
}
*/
