/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.PropertyPermission;

public final class FWJavaScriptClassLoader
extends SecureClassLoader {
    URL baseURL;
    CodeSource myCodeSource;
    private static final String[] props = new String[]{"file.separator", "path.separator", "java.class.version", "java.vendor", "java.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.vendor.url", "java.vm.name", "java.vm.vendor", "java.vm.version", "java.vm.specification.name", "java.vm.specification.vendor", "java.vm.specification.version", "line.separator", "os.name", "os.arch", "os.version"};

    public FWJavaScriptClassLoader(String string) {
        try {
            this.baseURL = new URL(string);
            this.myCodeSource = new CodeSource(this.baseURL, null);
        }
        catch (MalformedURLException malformedURLException) {
            throw new InternalError("Script URL malformed: " + string);
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        System.err.println("LOADING CLASS '" + string + "'");
        try {
            byte[] byArray = this.readFile(string.replace('.', '/') + ".class");
            return this.defineClass(string, byArray, 0, byArray.length, this.myCodeSource);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string);
        }
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions permissions = new Permissions();
        URL uRL = codeSource.getLocation();
        permissions.add(new SocketPermission(uRL.getHost(), "connect,accept"));
        if (uRL.getProtocol().equals("file")) {
            String string = uRL.getFile().replace('/', File.separatorChar);
            string = string.substring(0, string.lastIndexOf(File.separatorChar) + 1);
            permissions.add(new FilePermission(string + "*", "read,write,delete"));
        }
        int n = 0;
        while (n < props.length) {
            permissions.add(new PropertyPermission(props[n], "read"));
            ++n;
        }
        System.err.println("Script permission are " + permissions);
        return permissions;
    }

    private byte[] readFile(String string) throws IOException {
        int n;
        InputStream inputStream = this.getResourceAsStream(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected URL findResource(String string) {
        try {
            System.err.println("LOADING RESOURCE '" + string + "'");
            return new URL(this.baseURL, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected Enumeration findResources(String string) throws IOException {
        URL uRL = new URL(this.baseURL, string);
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

