/*
 * Decompiled with CFR 0.152.
 */
package vrml.external.FreeWRLEAI;

import vrml.external.FreeWRLEAI.Message;

class MessageQueue {
    private Message head = null;
    private Message tail = null;

    public synchronized void enqueue(Message message) {
        message.next = this.head;
        message.prev = null;
        if (this.head == null) {
            this.tail = message;
        } else {
            this.head.prev = message;
        }
        this.head = message;
    }

    public synchronized void enqueueUnique(Message message) {
        Message message2 = this.head;
        while (message2 != null) {
            if (message2.id == message.id && message2.field == message.field) {
                message2.value = message.value;
                return;
            }
            message2 = message2.next;
        }
        this.enqueue(message);
    }

    public synchronized Message dequeue() {
        if (this.tail == null) {
            return null;
        }
        Message message = this.tail;
        this.tail = this.tail.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        message.next = null;
        message.prev = null;
        return message;
    }

    public boolean isEmpty() {
        return this.head == null;
    }
}

