/*
 * Decompiled with CFR 0.152.
 */
package vrml.external.FreeWRLEAI;

import java.io.IOException;
import vrml.external.FreeWRLEAI.Message;
import vrml.external.FreeWRLEAI.MessageQueue;
import vrml.external.FreeWRLEAI.VFieldOutputStream;
import vrml.external.FreeWRLEAI.WriterThreadObserver;

class WriterThread
extends Thread {
    private VFieldOutputStream output;
    private MessageQueue transientMessages = new MessageQueue();
    private MessageQueue messages = new MessageQueue();
    private boolean running;
    private boolean timerSet;
    private long timeout;
    private static final long TIMEOUT = 100L;
    private WriterThreadObserver observer;

    WriterThread(VFieldOutputStream vFieldOutputStream, WriterThreadObserver writerThreadObserver) {
        this.output = vFieldOutputStream;
        this.observer = writerThreadObserver;
    }

    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Message message;
                WriterThread writerThread = this;
                synchronized (writerThread) {
                    if (this.timerSet) {
                        long l = this.timeout - System.currentTimeMillis();
                        if (l > 0L) {
                            this.wait(l);
                        }
                    } else {
                        this.wait();
                    }
                    if (this.timerSet && System.currentTimeMillis() > this.timeout) {
                        Message message2;
                        while ((message2 = this.transientMessages.dequeue()) != null) {
                            this.messages.enqueue(message2);
                        }
                        this.timerSet = false;
                    }
                }
                while ((message = this.messages.dequeue()) != null) {
                    this.sendMessage(message);
                }
            }
            catch (InterruptedException interruptedException) {
                this.running = false;
            }
        }
    }

    public synchronized void send(Message message) {
        if (message.field < 0) {
            this.messages.enqueue(message);
        } else if (this.timerSet) {
            this.transientMessages.enqueueUnique(message);
        } else {
            this.messages.enqueue(message);
            this.timeout = System.currentTimeMillis() + 100L;
            this.timerSet = true;
        }
        this.notify();
    }

    public synchronized void stopThread() {
        this.running = false;
        this.notify();
    }

    private void sendMessage(Message message) {
        try {
            this.output.writeInt(message.id);
            this.output.writeShort(message.field);
            this.output.writeField(message.value);
            this.output.flush();
        }
        catch (IOException iOException) {
            this.observer.onError(iOException);
        }
    }
}

