(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3024,        109]*)
(*NotebookOutlinePosition[      3665,        132]*)
(*  CellTagsIndexPosition[      3621,        128]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(n\  = \ {nx, ny, nz}\)], "Input"],

Cell[BoxData[
    \({nx, ny, nz}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p\  = \ {0, y, 0}\)], "Input"],

Cell[BoxData[
    \({0, y, 0}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p0\  = \ {px, py, pz}\)], "Input"],

Cell[BoxData[
    \({px, py, pz}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Solve[n\  . \ \((p\  - \ p0)\)\  \[Equal] 0, \ y]]\)], "Input"],

Cell[BoxData[
    \({{y \[Rule] \(nx\ px + ny\ py + nz\ pz\)\/ny}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(p1\  = \ {p1x, 0, p1z};\)\), "\[IndentingNewLine]", 
    \(\(p2\  = \ {p2x, 0, p2z};\)\), "\[IndentingNewLine]", 
    \(\(q1\  = \ {q1x, 0, q1z};\)\), "\[IndentingNewLine]", 
    \(q2\  = \ {q2x, 0, q2z}\)}], "Input"],

Cell[BoxData[
    \({q2x, 0, q2z}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Solve[p1 + k\ p2\  \[Equal] \ q1 + l\ q2, {k, l}]]\)], "Input"],

Cell[BoxData[
    \({{k \[Rule] \(p1z\ q2x - q1z\ q2x - p1x\ q2z + q1x\ q2z\)\/\(\(-p2z\)\ \
q2x + p2x\ q2z\), 
        l \[Rule] \(p1z\ p2x - p1x\ p2z + p2z\ q1x - p2x\ q1z\)\/\(\(-p2z\)\ \
q2x + p2x\ q2z\)}}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{688, 755},
WindowMargins->{{150, Automatic}, {Automatic, 52}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 53, 1, 27, "Input"],
Cell[1795, 54, 46, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1878, 60, 50, 1, 27, "Input"],
Cell[1931, 63, 43, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2011, 69, 54, 1, 27, "Input"],
Cell[2068, 72, 46, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2151, 78, 92, 1, 27, "Input"],
Cell[2246, 81, 80, 1, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2363, 87, 240, 4, 75, "Input"],
Cell[2606, 93, 47, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2690, 99, 92, 1, 27, "Input"],
Cell[2785, 102, 223, 4, 47, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

