(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2421,         87]*)
(*NotebookOutlinePosition[      3061,        110]*)
(*  CellTagsIndexPosition[      3017,        106]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(n = {nx, ny, nz}\)], "Input"],

Cell[BoxData[
    \({nx, ny, nz}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p = {px, py, pz}\)], "Input"],

Cell[BoxData[
    \({px, py, pz}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p + k\ n\)], "Input"],

Cell[BoxData[
    \({k\ nx + px, k\ ny + py, k\ nz + pz}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Solve[p\  + \ k\ n\  == \ {x, 0, z}, {x, z, k}]]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] px - \(nx\ py\)\/ny, 
        z \[Rule] \(-\(\(nz\ py\)\/ny\)\) + pz, 
        k \[Rule] \(-\(py\/ny\)\)}}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{884, 788},
WindowMargins->{{58, Automatic}, {Automatic, 15}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 49, 1, 27, "Input"],
Cell[1791, 54, 46, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1874, 60, 49, 1, 27, "Input"],
Cell[1926, 63, 46, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2009, 69, 41, 1, 27, "Input"],
Cell[2053, 72, 70, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2160, 78, 90, 1, 27, "Input"],
Cell[2253, 81, 152, 3, 44, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

