'''OpenGL extension SGIX.dmbuffer

This module customises the behaviour of the 
OpenGL.raw.GLX.SGIX.dmbuffer to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces a new type of GLXPbuffer, a DM or Digital
	Media pbuffer.  A DM pbuffer is a GLXPbuffer that adopts one or more 
	of its buffers from an externally defined and allocated DMbuffer. 
	In this way it resembles a GLXPixmap that attaches to an existing
	X pixmap.  Like a standard pbuffer it can be used as a non-displayable
	rendering area, or as a read source for pixel data.  The externally
	defined buffers of the DM pbuffer can be sequentially associated 
	with other DM buffers of the same size and configuration.  
	
	.  The DM pbuffer is described with a new attrib passed to 
	   glXCreateGLXPbuffer.  
	
	.  A new GLX command allows associating a compatible DMbuffer with 
	   the DM GLXPbuffer.  At associate time the DM buffers described 
	   by the DMparams are used directly as the corresponding 
	   buffers of the GLXPbuffer drawable, as described by the FBconfig.  
	   All other buffers that are part of the config will be created by
	   GL without externally referenceable names.  A DM pbuffer must be
	   associated with a compatible DMbuffer before it can be made current
	   to a GLX context. 
	
	.  The externally defined buffers of the DM pbuffer can be changed at 
	   any time by successfully associating a new DMbuffer with the GLXPbuffer 
	   through the associate command.  It will be the application's 
	   responsibility to synchronize DMedia, GLX, and GL commands that 
	   effect the contents of the DM pbuffer.
	
	.  Any direct GLX rendering context that satisfies config compatibility
	   can be used to render to or read from a DM GLXPbuffer.
	   A currently associated DMbuffer may simultaneously be in use by 
	   other clients on the same Display, but will not be destroyed
	   while associated with a GLXPbuffer.  When the GLXpbuffer is
	   destroyed, all buffers that have no remaining clients, including
	   the DMbuffer, will be freed.
	
	DM GLXPbuffers are proposed as a means for OpenGL to access buffers
	generated by the VL, compression, and other digital media libraries in 
	a uniform way.  The DMbuffer and DMparams descriptors are left 
	intentionally abstract so that the GLX extension can adapt to future 
	DM library changes.  
	The initial implementation will require that the DMparams descriptor
	supply at least pixel format and packing information, and that the  
	DMbuffer provide the size and location of a colorbuffer.  GLX will do 
	compatibility checking when possible based on the config, params, and 
	buffer information at associate time. 

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIX/dmbuffer.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper

import ctypes
from OpenGL.raw.GLX import _types
from OpenGL.raw.GLX.SGIX.dmbuffer import *
from OpenGL.raw.GLX.SGIX.dmbuffer import _EXTENSION_NAME

def glInitDmbufferSGIX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION