dnl       Copyright (C) 1998 Claus-Justus Heine
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
dnl
dnl 
dnl $RCSfile: acinclude.m4,v $
dnl $Revision: 1.4 $
dnl $Date: 1998/12/18 22:59:00 $
dnl
dnl     set prefix to its proper value, so that one can define substitutions
dnl     depending on the value of prefix
dnl
dnl     $Log: acinclude.m4,v $
dnl     Revision 1.4  1998/12/18 22:59:00  cvs
dnl     Replaced the $Source: $ keywords substitution by the $RCSfile: $
dnl     keyword substitution.
dnl
dnl     Revision 1.3  1998/08/06 13:05:31  claus
dnl     Include more sgml2info test cases
dnl
dnl     Revision 1.2  1998/08/06 04:30:24  claus
dnl     Check for sgml-tools-1.0.7 broken sgml2info and use own version if
dnl     necessary.
dnl
dnl     Revision 1.1.1.1  1998/08/05 16:13:11  claus
dnl     imported faq sources
dnl
dnl     Revision 1.1.1.1  1998/08/03 16:12:10  claus
dnl     The Ftape HOWTO
dnl
dnl     Revision 1.1  1998/08/03 10:44:09  claus
dnl     Initial revision
dnl
dnl     Revision 1.1.1.1  1998/07/29 05:47:09  claus
dnl     Imported Sources
dnl

AC_DEFUN(AC_SET_PREFIX,
[test "x$prefix" = xNONE && prefix=$ac_default_prefix
# Let make expand exec_prefix.
test "x$exec_prefix" = xNONE && exec_prefix='${prefix}'
])

dnl
dnl check whether sgml2info is still broken
dnl
AC_DEFUN(_FT_CHECK_SGML2INFO,
[unset ac_cv_path_SGML2INFO
AC_PATH_PROGS(SGML2INFO, sgml2info)
AC_MSG_CHECKING([whether $SGML2INFO is broken])
cat > conftest.sgml << __EOF__
<!doctype linuxdoc system>

<article>

<title>The Foo File
<author>The Foo-Man

<toc>

<sect>How do I: "..." with tar?<p>

<code>
&lcub; silly test case &rcub
</code>

And the silly footnote test<footnote>This is a footnote</footnote>

And the silly quotation

<lq><p>
The silly quotation
</lq>

And the silly file
<file>
Silly file
</file>

And the silly cparam, what this is ...
<cparam>foo</cparam>


</article>
__EOF__
$SGML2INFO -d conftest.sgml 1>&5 2>&5
if test -f conftest.info ; then	
	AC_MSG_RESULT(no)
else
	AC_MSG_RESULT(yes)
	unset SGML2INFO
	unset ac_cv_path_SGML2INFO
fi
rm -f conftest*])

AC_DEFUN(FT_CHECK_SGML2INFO,
[_FT_CHECK_SGML2INFO
if test z$SGML2INFO = z ; then
	AC_MSG_CHECKING(for own version ... )
	(
		AC_OUTPUT_SUBDIRS(sgml-tools)
	) 1>&5 2>&5 3>&5 4>&5
	AC_MSG_RESULT(ready)
	PATH=sgml-tools:$PATH
	_FT_CHECK_SGML2INFO
	if test z$SGML2INFO != z ; then
		SGML2INFO='$(top_srcdir)/sgml-tools/sgml2info'
		AC_MSG_RESULT(Using $SGML2INFO)
	fi		
fi])
