% -*- slang -*-

% This file provides a mode for editing FTM rules.
% This mode requires DFA syntax highlighting and jed >= 0.99.14
%
% Copyright (C) 2002 Abraham vd Merwe <abz@blio.com>
%
% Last updated: 2003-03-08

variable ftm = "ftm";

create_syntax_table (ftm);
set_syntax_flags (ftm,0x04);

% colors
set_color ("keyword","brightblue","black");
set_color ("keyword1","yellow","black");
set_color ("operator","brown","black");
set_color ("preprocess","cyan","black");
set_color ("number","green","black");
set_color ("string","red","black");
set_color ("...","lightgray","black");

#ifdef HAS_DFA_SYNTAX
%%% DFA_CACHE_BEGIN %%%

static define setup_dfa_callback (name)
{
   % DFA color rules
   dfa_enable_highlight_cache ("ftm.dfa",name);

   % rates
   dfa_define_highlight_rule ("[0-9]+(kbit|mbit|kbps|mbps|bps)","number",name);

   % comments
   dfa_define_highlight_rule ("#.*","comment",name);

   % commands
   dfa_define_highlight_rule ("table|chain|monitor|comment","keyword",name);
   dfa_define_highlight_rule ("description|bandwidth|network","keyword",name);

   % parameters
   dfa_define_highlight_rule ("incoming|outgoing|peak","operator",name);

   % values
   dfa_define_highlight_rule ("INPUT|OUTPUT|FORWARD","keyword1",name);
   dfa_define_highlight_rule ("filter|mangle|nat","keyword1",name);

   % strings
   dfa_define_highlight_rule("\"[^\"]*\"","string",name);

   % networks
   dfa_define_highlight_rule ("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+(/[0-9]+)?","preprocess",name);

   % the rest
   dfa_define_highlight_rule ("[a-zA-Z0-9]([0-9a-zA-Z_]|\\.|-)*","...",name);

   dfa_build_highlight_table(name);
}
dfa_set_init_callback (&setup_dfa_callback, "ftm");
%%% DFA_CACHE_END %%%
#endif

define ftm_mode ()
{
   set_mode (ftm,4);
   use_syntax_table (ftm);
}

