.TH FUNIONFS 8 "15 June 2006" "" ""
.SH NAME
funionfs \- user-space directory concatenation.
.SH SYNOPSIS
.B "funionfs "
.I upper_dir mountpoint [ option ] ...
.SH OPTIONS
    -o opt,[opt...]        mount options
    -h   --help            print help
    -V   --version         print version

Mount options include:
   funionfs_debug      print some debugging information
   dirs=LIST           A colon separated list of directories
      /branch1=rw      a directory in a read-write mode
      /branch1         if no permission is specified, the branch
                       is in a read-write mode
      /branch2=ro      a directory in a read-only mode
   copyupuid=N         uid of the copied-up files (no default)
   copyupgid=N         gid of the copied-up files (no default)
   copyupmode=N        mode of the copied-up files (no default)
   del_string=N        string to mark a deleted file(default: _DELETED~ )
   delete=TYPE         specifies how funionfs deletes and renames
      all (default)    delete all objects in read-write branch (default)
                       and add a whiteout file if objects exists in
                       read-only branches.
      whiteout         only add a whiteout file in upper (rw) branch
                       or delete file in upper branch.
   copyup=TYPE         specifies how to manage attributes
      preserve         preserve uid, gid and mode of object (default)
      currentuser      the object owns to the user doing the operation
      mounter          the object owns to the mounter

There is no implementation of -o delete and -o copyup for now.

You could use the mount command instead :
   mount -t fuse funionfs#/upper_dir mountpoint [ options ]

If you want to name all directories in '-o dirs=', then pass "none" as upper_dir

.SH DESCRIPTION
.I funionfs
concatenates directories mentioned in options (and
.I upper_dir
) to
.I mountpoint. 
Also, although some (but not all) of the directories are 
read-only, you still can write in resulting mounted directory.
For example, if you have files 
.I a/a 
and 
.I b/b 
and mount mountpoint 
.I r
with "-o dirs=a=ro:b=ro:w=rw", then you will see files 
.I r/a
and
.I r/b.
You will be able to write to them, and original files will remain intact 
(changes will go to
.I w
). Note that it is impossible to have file with name ending by 
.I del_string
value, if you create 
.I r/a_DELETED~
in mentioned example, it will dissapear together with a.
.SH "SEE ALSO"
The source..
.SH BUGS
You cannot mount an overlay on / (the program that list the content of / will hang). This is probably due to a loop call of the fuse driver. There is no known solution for now.

Probably minor (or major) mistakes in not-so-frequent cases.

Not enough tested.
