/*
 *
 * Copyright (c) 2003 The Regents of the University of California.  All 
 * rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Neither the name of the University nor the names of its
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
 

/*
 *
 * zombietest.c: A test program as part of FUSD.
 *
 * This regression test program checks to make sure that clients see a
 * valid close(), even if the device has zombified.
 *
 * $Id: zombietest2.c,v 1.3 2003/07/11 22:29:40 cerpa Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/wait.h>
#include <signal.h>
#include <string.h>

#include "fusd.h"

#define DEVNAME "/dev/testfusd/zombietest"

#define ITERATIONS 1

#define FORK \
  tmp = fork(); \
  if (tmp < 0) { perror("can't fork"); exit(1); } \
  if (tmp == 0)

int n;

void done(int signo)
{
  static int num_done = 0;
  int status;
  pid_t pid;

  while ((pid = waitpid(-1, &status, WNOHANG)) > 0) {
    printf("pid [%d] done\n", pid);
    num_done++;
  }

  /* if all N clients, plus the server, are done... we're done */
  if (num_done == n+1) {
    printf("test complete\n");
    exit(1);
  }
}



int _open(struct fusd_file_info *file)
{
  printf("[%d] exiting without responding\n", getpid());
  exit(1);
}


int main(int argc, char *argv[])
{
  int tmp;

  n = 1;

  printf("master is pid %d\n", getpid());
  signal(SIGCHLD, done);

  /* fork server */
  FORK {
    fusd_file_operations_t fops = {
      open: _open
    };
    int fd;

    if ((fd = fusd_register(DEVNAME, 0666, 0, &fops)) < 0) {
      perror("Register failed");
      exit(1);
    }
    printf("[%d] register succeeded, running...\n", getpid());
    fusd_run();
    exit(1);
  }

  sleep(3);

  FORK {
    int fd;

    printf("[%d] trying to open...\n", getpid());
    fd = open(DEVNAME, O_RDWR);
    printf("[%d] got %d (%m)\n", getpid(), fd);
    sleep(2);
    printf("[%d] trying to close\n", getpid());
    fd = close(fd);
    printf("[%d] got %d (%m)\n", getpid(), fd);
    exit(1);
  }

  /* parent: wait for children to all exit */
  while (1)
    pause();
}

