/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.applications.hwiki;

import hypergraph.applications.hwiki.GraphPanel;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphSystem;
import hypergraph.graphApi.GraphSystemFactory;
import hypergraph.graphApi.Node;
import hypergraph.visualnet.ForceDirectedWeight;
import hypergraph.visualnet.GenericMDSLayout;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JOptionPane;

public class HWikiApplet
extends JApplet {
    static Graph graph;

    public void init() {
        String string = this.getParameter("startPage");
        String string2 = this.getParameter("wikiURL");
        if (string == null) {
            string = "Main";
        }
        GraphSystem graphSystem = null;
        try {
            graphSystem = GraphSystemFactory.createGraphSystem("hypergraph.graph.GraphSystemImpl", null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(8);
        }
        graph = graphSystem.createGraph();
        URL uRL = null;
        try {
            graph.createNode(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GraphPanel graphPanel = new GraphPanel(graph, this);
        graphPanel.setRpcClientName(string2);
        String string3 = this.getParameter("properties");
        if (string3 != null) {
            try {
                uRL = new URL(this.getCodeBase(), string3);
                graphPanel.loadProperties(uRL.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(null, "Could not find propertyfile " + uRL.getFile() + ". \n" + "Start applet with default properties", "File not found", 0);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "General error while reading file " + uRL.getFile() + ". \n" + "Exception : " + exception + ". \n" + "Start applet with default properties", "General error", 0);
                System.out.println(uRL);
                System.out.println("Exception : " + exception);
                exception.printStackTrace(System.out);
            }
        }
        graphPanel.getPropertyManager().setProperty("visualnet.GenericMDSLayout.repulsingForce", new Double(0.1));
        graphPanel.getPropertyManager().setProperty("visualnet.GenericMDSLayout.repulsingForceCutOff", new Double(5.0));
        graphPanel.getPropertyManager().setProperty("visualnet.GenericMDSLayout.connectedDisparity", new Double(0.2));
        ForceDirectedWeight forceDirectedWeight = new ForceDirectedWeight();
        forceDirectedWeight.setGraph(graph);
        GenericMDSLayout genericMDSLayout = new GenericMDSLayout(null, graphPanel.getModel(), graph, graphPanel.getPropertyManager());
        graphPanel.setGraphLayout(genericMDSLayout);
        graphPanel.addRelatedUrls(string, 0);
        graphPanel.centerNode((Node)graph.getElement(string));
        this.getContentPane().add(graphPanel);
    }
}

