/*****************************************************************************
     This file is part of FWatch. 

     Copright (C)2003  Frank Hemer <frank@hemer.org>

     FWatch is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

     FWatch is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with FWatch; if not, write to the Free Software
     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*******************************************************************************/

/* $Id: fwatch.h,v 1.3 2003/05/18 22:49:01 frank Exp $ */ 

#ifndef FWATCH_H
#define FWATCH_H

/* #define FWATCH_HAVENAMES */

#define FWATCH_OPENW 1
#define FWATCH_OPENR 2 /*currently not supported*/
#define FWATCH_RMDIR 4
#define FWATCH_MKDIR 8
#define FWATCH_SYMLINK 16
#define FWATCH_LINK 32
#define FWATCH_UNLINK 64
#define FWATCH_CREATE 128
#define FWATCH_CLOSE 256
#define FWATCH_RENAME 512 
#define FWATCH_CHOWN 1024
#define FWATCH_CHMOD 2048
#define FWATCH_STAT 4096
#define FWATCH_FSTAT 8192
#define FWATCH_WRITE 16384 /*currently not supported*/ 
#define FWATCH_UTIME 32768

#define FWATCH_NONE 0
#define FWATCH_ISFILE 1
#define FWATCH_ISDIR 2
#define FWATCH_OVERFLOW 128

#define FWATCH_EMERGENCYUNLOAD 0
#define FWATCH_SETMODE 1


#ifdef FWATCH_HAVENAMES
#define FWATCH_PATHSIZE 256
#define FWATCH_MAXMSGSIZE FWATCH_PATHSIZE * 2 + 14
#endif

typedef struct {
  long st_dev;
  long st_ino;
  int mask;
  int func;
  long st_pdev;
  long st_pino;
#ifdef FWATCH_HAVENAMES
  char name[FWATCH_MAXMSGSIZE];
  char pname[FWATCH_MAXMSGSIZE];
#endif
} fwatch_data_t;

#endif
