/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: AboutDialog.cc,v 1.10 2003/03/02 08:12:43 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "fwbuilder/libfwbuilder-config.h"

#include "config.h"
#include "AboutDialog.hh"

#include "fwbuilder/Constants.hh"
#include "helpers.hh"
#include "PixmapButton.hh"

using namespace libfwbuilder;

AboutDialog::AboutDialog()
{
    about_dlg=this;
    about_dlg->set_name("about");
    delete_event.connect(SigC::slot(this,&AboutDialog::on_delete));

    string s=title->get_text();
    s=s+VERSION;
    if (string(RELEASE_NUM)!="")
    {
        s=s+"-" RELEASE_NUM;
    }
    title->set_text(s);

#ifdef HAVE_LIBSNMP
    snmp_support->set_text(_("Yes"));
#else
    snmp_support->set_text(_("No"));
#endif

#ifdef HAVE_LIBSSL
    ssl_support->set_text(_("Yes"));
#else
    ssl_support->set_text(_("No"));
#endif

#ifdef HAVE_GOODLIBRESOLV
    dns_support->set_text(_("Yes"));
#else
    dns_support->set_text(_("No"));
#endif


    widgetModifyFont(title,
		     "-*-helvetica-bold-o-*-*-18-*-*-*-*-*-*-*");

    s=using_libfwbuilder->get_text();
    s=s+Constants::getLibraryDescription()+" "+Constants::getLibraryVersion();
    using_libfwbuilder->set_text(s);

    PixmapButton::addPixmapAndText( *ok_button , "Ok"     , _("OK")     );



    
    ok_button->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    ok_button->grab_focus();
    ok_button->grab_default();

//    set_usize(400,300);
}

AboutDialog*   AboutDialog::about_dlg=NULL;

void AboutDialog::showAboutDialog()
{
    if (about_dlg==NULL) {
	about_dlg=new AboutDialog();
	about_dlg->show_all();
#ifdef __MINGW32__
    __fwb_win32_loadIcon("FWBuilderWin32Ico",about_dlg);
#endif
    }
}

gint AboutDialog::on_delete(GdkEventAny* ev)
{   
    destroy();
    about_dlg=NULL;
    return false;
}

void AboutDialog::on_ok_clicked()
{   
    destroy();
    about_dlg=NULL;
}
