/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: BuiltinDialog.cc,v 1.62 2002/11/15 07:20:17 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "fwbuilder/Group.hh"
#include "fwbuilder/IPv4.hh"
#include "fwbuilder/Policy.hh"
#include "fwbuilder/InterfacePolicy.hh"
#include "fwbuilder/NAT.hh"


#include "FWObjectDatabaseGUI.hh"

#include "BuiltinDialog.hh"
#include "main_window.hh"
#include "helpers.hh"

#include "DialogPlugin.hh"
#include "DialogFactory.hh"

#include "FWObjectBook.hh"
#include "ObjectTree.hh"

#include "PixmapButton.hh"
#include "StockButton.hh"

#include <unistd.h>

#include <assert.h>

#include <gtk--.h>

#include <algorithm>
#include <functional>
#include <stack>

using namespace libfwbuilder;

BuiltinDialog::BuiltinDialog(main_window *_mw, const string &id)
{
    mw=_mw;

    set_name("BuiltinDialog");
    glademm_set_Widget("BuiltinDialog", this);
    


    
    data_changed=false;
    original=FWObjectDatabase::db->getById( id , true);

    assert(original!=NULL);

    dialog_body = DialogFactory::createDialog(original);
    assert(dialog_body!=NULL);

    dialog_body->setMainWindow(mw);

/*
 *  Building dialog body
 */    
    vbox = new Gtk::VBox(false,0);
    add(*vbox,
        GTK_SIDE_TOP,
        GTK_ANCHOR_CENTER,
        GTK_PACK_EXPAND | GTK_FILL_X | GTK_FILL_Y
    );
    vbox->show();

    save_btn    = NULL;
    undo_btn    = NULL;
    separator   = NULL;
    action_area = NULL;
    
    if(dialog_body->needDialogButtons() &&
       Resources::global_res->getObjResourceBool(original,"write") ) 
    {
        
        action_area = new Gtk::HBox(false,5);
        action_area->set_border_width(10);
        action_area->set_usize(-1, 50);
        action_area->set_name("action_area");
        action_area->set_border_width(10);


	save_btn=new StockButton(StockButton::APPLY);
	undo_btn=new StockButton(StockButton::UNDO);
	    
        action_area->pack_end(*undo_btn,false,false,0);
        action_area->pack_end(*save_btn,false,false,0);

        vbox->pack_end(*action_area,false,true,0);

        save_btn->set_sensitive(false);
        undo_btn->set_sensitive(false);

        save_btn->show();
        undo_btn->show();
        action_area->show();

        separator = new Gtk::HSeparator();
        vbox->pack_end(*separator,false,true,0);
        separator->show();

        save_btn->clicked.connect(SigC::slot((BuiltinDialog*)this, 
                                             &BuiltinDialog::on_save_clicked));
      
        undo_btn->clicked.connect(SigC::slot((BuiltinDialog*)this, 
                                             &BuiltinDialog::on_undo_clicked));

    }

    vbox->pack_end( *dialog_body,true,true,0);

    dialog_body->show();
    show_all();

//    dialog_body->wrk2dlg(); 
//    data_changed_flag(false);


    if(undo_btn)
        undo_btn->set_sensitive(false);

    // this should be done after we initialize entry fields
    ConnectSignals();     
    
}

BuiltinDialog::~BuiltinDialog()
{
    if (save_btn)    {
        action_area->remove( *save_btn );
        delete save_btn;
    }
    if (undo_btn)    {
        action_area->remove( *undo_btn );
        delete undo_btn;
    }
    if (action_area) {
        vbox->remove( *action_area );
        delete action_area;
    }
    if (separator)   {
        vbox->remove( *separator );
        delete separator;
    }
    if (dialog_body) {
        vbox->remove( *dialog_body );
        delete dialog_body;
    }

    if (vbox)        delete vbox;

    glademm_set_Widget("BuiltinDialog", NULL);
}

void BuiltinDialog::set_policy(gint allow_shrink, 
			       gint allow_grow, 
			       gint auto_shrink){}

void BuiltinDialog::set_position(GtkWindowPosition position){}

void BuiltinDialog::set_title(const Gtk::nstring& title){}


  
void BuiltinDialog::dialog_set_changed_callback_helper(Gtk::Widget *wp)
{
  Gtk::Editable     *ed;
  Gtk::ToggleButton *tb;

  if (wp==NULL) return;

  if ( Gtk::Editable::isA(wp) ) {
      ed=(Gtk::Editable*)(wp);
      ed->changed.connect(SigC::slot((BuiltinDialog*)this, 
				     &BuiltinDialog::OnDataChanged));
      return;
  }
  if (Gtk::ToggleButton::isA(wp)) {
      tb=(Gtk::ToggleButton*)(wp);
      tb->toggled.connect(SigC::slot((BuiltinDialog*)this, 
				     &BuiltinDialog::OnDataChanged));
      return;
  }
  if (Gtk::Combo::isA(wp)) {
      ((Gtk::Combo*)wp)->get_entry()->changed.connect(
	  SigC::slot((BuiltinDialog*)this, 
		     &BuiltinDialog::OnDataChanged));
      return;
  }
  if ( Gtk::Box::isA(wp) || Gtk::Fixed::isA(wp) ) {
    Gtk::Box      *bptr=(Gtk::Box*)wp;
    Gtk::Box_Helpers::BoxList   bl= bptr->children();
    Gtk::Box_Helpers::BoxList::iterator bl_i;
    Gtk::Box_Helpers::Child    *ch;
    
    for (bl_i=bl.begin(); bl_i!=bl.end(); bl_i++) {
      ch= *bl_i;
      dialog_set_changed_callback_helper( ch->get_widget() );
    }
  }
  if ( Gtk::Packer::isA(wp) ) {
    Gtk::Packer      *bptr=(Gtk::Packer*)wp;
    Gtk::Packer_Helpers::PackerList   bl= bptr->children();
    Gtk::Packer_Helpers::PackerList::iterator bl_i;
    Gtk::Packer_Helpers::Child    *ch;
    
    for (bl_i=bl.begin(); bl_i!=bl.end(); bl_i++) {
      ch= *bl_i;
      dialog_set_changed_callback_helper( ch->get_widget() );
    }
  }
  if ( Gtk::Notebook::isA(wp) ) {
    for (int i=0; i<20; ++i)
      dialog_set_changed_callback_helper
	(((Gtk::Notebook*)wp)->get_nth_page(i) );
    return;
  }
  if ( Gtk::Bin::isA(wp) ) {
    dialog_set_changed_callback_helper( ((Gtk::Bin*)wp)->get_child() );
    return;
  }

/*
 *   TODO:
 *
 *   This is broken in gtk-- 1.2.3  Since this is what is shipped with
 *   RedHat 6.2, we will provide workarounds until we either completely
 *   switch to RedHat 7.0 (for which gtk-- 1.2.5 is available as rpms) or
 *   newer version of gtk-- will be available as rpm for RH 6.2
 *
 *   As a workaround we are going to have to attach "on_changed" callback
 *   to dialog elements which are positioned inside tables, or we won't use
 *   tables where possible
 *

  if ( Gtk::Table::isA(wp) ) {
      Gtk::Table_Helpers::TableList lst= ((Gtk::Table*)wp)->children();
      Gtk::Table_Helpers::TableList::iterator m;
      for (m=lst.begin(); m!=lst.end(); m++) {
	  if ( (*m)==NULL ) continue;
	  Gtk::Widget *w = (*m);
	  dialog_set_changed_callback_helper(w);
      }
  }
*/
}


void BuiltinDialog::ConnectSignals()
{
   dialog_set_changed_callback_helper( dialog_body );
}

void BuiltinDialog::data_changed_flag(bool f)
{
    if (save_btn!=NULL) {

	save_btn->set_sensitive(f);
	undo_btn->set_sensitive(f);

	data_changed=f;

/*
	Gdk_Color    btn_color;
	btn_color.parse((f)?"red":"black");
	


	
	Gtk::Style       *btn_style;

	btn_style= save_btn->get_child()->get_style () -> copy ();
	btn_style->set_fg( GTK_STATE_NORMAL      , btn_color );
	save_btn->get_child()->set_style( *btn_style );
	btn_style->unref();
	save_btn->show();
*/
    }

    main_window::clearStatusbar();
    main_window::showSaveStatusbar(f);
}

void BuiltinDialog::LoadData()
{
    dialog_body->wrk2dlg(); 
    data_changed_flag(false);
    /*
     * If name is empty, this is brand new object
     */
    if(original->getTypeName()!=Policy::TYPENAME &&
       original->getTypeName()!=InterfacePolicy::TYPENAME &&
       original->getTypeName()!=NAT::TYPENAME ) 
    {
        if (original->getName()=="") 
            data_changed_flag(true);
    }
//    original->setDirty(false,true);
}

void BuiltinDialog::SaveData()
{
    string old_prop=ObjectTree::get_properties(original);
    string old_tree_label=ObjectTree::get_tree_label(original);

    if (data_changed && dialog_body!=NULL && dialog_body->dlg2wrk() ) 
    {
	data_changed_flag(false);

        if (old_tree_label!=ObjectTree::get_tree_label(original) ||
            old_prop!=ObjectTree::get_properties(original))
        {
            FWObjectBook *w=mw->getObjectBook();
            if (w!=NULL) {
                main_window::changeLabelInAllObjectBooks( original->getId() );
                if (IPv4::isA(original))
                {
                    main_window::changeLabelInAllObjectBooks( original->getParent()->getId() );
                    main_window::changeLabelInAllObjectBooks( original->getParent()->getParent()->getId() );
                }
                w->showObject( original->getId() );
            }
            mw->updateNavbar(original);
        }

	original->setDirty(true,true);

        main_window::conditionalRefreshAllDialogs(original,mw);
    }
}

void BuiltinDialog::UndoChanges()
{
    if (dialog_body!=NULL) {
	if (data_changed) {
	    LoadData();
	    if (original->getTypeName()!=Policy::TYPENAME &&
		original->getTypeName()!=NAT::TYPENAME ) {
		if (original->getName()=="")  data_changed_flag(true);
	    }
	}
    }
}


void BuiltinDialog::OnDataChanged()
{
    data_changed_flag(true);
}

gint BuiltinDialog::on_focus_out_event(GdkEventFocus *ev)
{
  return(0);
}

void BuiltinDialog::OnHide()
{
}

void  BuiltinDialog::on_save_clicked()
{
  SaveData();
}

void  BuiltinDialog::on_undo_clicked()
{
  UndoChanges();
}

