/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: CustomServiceDialog.cc,v 1.11 2003/04/07 01:04:40 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "fwbuilder/CustomService.hh"
#include "fwbuilder/Resources.hh"

#include "CustomServiceDialog.hh"

#include "helpers.hh"

using namespace libfwbuilder;

CustomServiceDialog::CustomServiceDialog(libfwbuilder::FWObject *obj) 
{ 
    object=obj;


//    platforms=Resources::global_res->getListOfPlatforms();
    platforms=Resources::getPlatforms();

    platform->set_menu(platforms);
    platform->changed.connect(SigC::slot(this,&CustomServiceDialog::on_platform_changed));
    platform->show_all();
}

/**
 *   this callback is called when user changes firewall platform
 */
void CustomServiceDialog::on_platform_changed()
{
    string new_platform=platform->get_value();
    code->set_text( codes[new_platform] );
}

void CustomServiceDialog::on_code_changed()
{
    string cur_platform=platform->get_value();
    codes[ cur_platform ] = code->get_text();
    on_changed();
}

void CustomServiceDialog::wrk2dlg()
{
    CustomService *cs=CustomService::cast(object);

    name->set_text(object->getName());

    comment->set_point(0);
    comment->forward_delete( comment->get_length() );
    comment->insert(object->getComment());

    map<string,string>::iterator i;
    string   active_item;
    for (i=platforms.begin(); i!=platforms.end(); ++i) {
        string s=cs->getCodeForPlatform( (*i).first );
	codes[ (*i).first ] = s;
	if ( ! s.empty() ) active_item= (*i).first;
    }

    platform->set_active_item_by_label( active_item );
    on_platform_changed();

    name->grab_focus();
}

bool CustomServiceDialog::dlg2wrk()
{
    CustomService *cs=CustomService::cast(object);

    object->setName( name->get_text() );
    object->setComment( comment->get_chars(0,comment->get_length()) );

    map<string,string>::iterator i;
    for (i=platforms.begin(); i!=platforms.end(); ++i) 
	cs->setCodeForPlatform( (*i).first , codes[(*i).first] );

    return(true);
}

void CustomServiceDialog::on_changed()
{
  data_changed_flag(true);
}


