/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Zaliva lord@crocodile.org

  $Id: DialogFactory.hh,v 1.7 2002/08/29 00:34:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _DIALOG_FACTORY_HH_
#define _DIALOG_FACTORY_HH_

#include "config.h"

#include "fwbuilder/FWObject.hh"
#include "DialogPlugin.hh"

class DialogFactory
{
    public:
    
    static DialogFactory *instance;
    
    static DialogPlugin* createDialog(libfwbuilder::FWObject *o) 
    {
        return instance->create(o);
    }
    
    static DialogPlugin* createDialog(libfwbuilder::FWObject *o,
                                      const std::string &target) 
    {
        return instance->create(o,target);
    }
    
    static bool haveDialogFor(libfwbuilder::FWObject *o) 
    {
        return instance->haveDialog(o);
    }
    
    static bool haveDialogFor(const std::string &target)
    {
        return instance->haveDialog(target);
    }

    protected:
    
    std::map<std::string,void*> dl_handles;

    DialogFactory() {}
    virtual ~DialogFactory() {}

    /**
     * Creates DialogPlugin for corresponding data
     * object. If no plugin defined for this type,
     * returns NULL.
     */
    virtual DialogPlugin* create(libfwbuilder::FWObject *o) = 0;

    /**
     * Creates DialogPlugin for corresponding platform or OS
     * Possibly loads external dynamic library using dlopen.
     * If no plugin defined for this type returns NULL.
     */
    virtual DialogPlugin* create(libfwbuilder::FWObject *o,
                                 const std::string &target) = 0;

    /**
     * returns true if dialog can be created for the object 'o'
     */
    virtual bool haveDialog(libfwbuilder::FWObject *o) = 0;

    /**
     * returns true if dialog can be created for target platform or OS
     */
    virtual bool haveDialog(const std::string &target) = 0;
};

#endif
