/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: IPAddressWidget.cc,v 1.14 2003/04/07 01:04:40 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "IPAddressWidget.hh"

#include "helpers.hh"
#include "MessageDialog.hh"

using namespace libfwbuilder;




gint IPAddressWidget::AddressComponentWidget::key_press_event_impl(GdkEventKey* p0)
{
    if (p0->keyval==GDK_period || 
	p0->keyval==GDK_KP_Separator ||
	p0->keyval==GDK_KP_Decimal ) 
    {
	jump_to_next(); /* calls signal */
	return(true);
    }

    return Gtk::Entry::key_press_event_impl(p0);
}


IPAddressWidget::IPAddressWidget() : Gtk::HBox()
{
    construct();
}

IPAddressWidget::IPAddressWidget( const IPAddress& addr ) : Gtk::HBox()
{
    construct();
    setAddress(addr);
}

IPAddressWidget::IPAddressWidget( const string& addr ) : Gtk::HBox()
{
    construct();
    setAddress(addr);
}

IPAddressWidget::~IPAddressWidget()
{
}

void    IPAddressWidget::construct()
{
    associated_netmask=NULL;

    show_all_zeroes = false;
    ignore_changed  = false;

    set_name("IPAddressWidget");

    AddressComponentWidget*  a1;

    for (int i=0; i<4; ++i) 
    {
	a1 = manage(new class AddressComponentWidget());
	a1->set_usize(35, -1);
	a1->set_editable(true);
	pack_start(*a1, false, false, 5);
	a.push_back(a1);

	a1->changed.connect(SigC::slot(this,
				       &IPAddressWidget::on_changed ) );
	a1->focus_out_event.connect(SigC::slot(this,
				       &IPAddressWidget::on_set_netmask ) );
	a1->jump_to_next.connect(SigC::slot(this,
				       &IPAddressWidget::on_next ) );

	if (i<3) 
        {
	    Gtk::Label *label349 = manage(new class Gtk::Label("."));
	    label349->set_alignment(0.5, 0.5);
	    label349->set_padding(5, 0);
	    pack_start(*label349, false, false, 0);
	}
    }

    show_all();
}

void IPAddressWidget::on_next()
{
    for (int i=2; i>=0; --i) 
	if ( a[i]->has_focus()) a[i+1]->grab_focus();
}

gint IPAddressWidget::on_set_netmask(GdkEventFocus *ev)
{
    if ( ! empty() ) 
    {
	try 
        {
	    getAsIPAddress();  /* checks address for validity */

	    if ( associated_netmask && 
		 associated_netmask->getAsString()=="0.0.0.0" ) 
            {
		Netmask n( getAsIPAddress() );
		associated_netmask->setAddress(n);
	    }

	} catch (FWException ex) {
	    ;
//	    MessageDialog::Error(ex.toString());
	}

    }
    return 1;
}

void IPAddressWidget::setAssociatedNetmaskWidget( IPAddressWidget* nm )
{
    associated_netmask=nm;
}

void IPAddressWidget::setAddress(const IPAddress& addr)
{
    setAddress( addr.toString() );
}

void IPAddressWidget::setAddress(const string& addr)
{
    int   n;
    string::size_type i,j;
    j=0;

    ignore_changed=true;

    if (addr=="0.0.0.0" && ! show_all_zeroes ) 
    {
	for (n=0; n<4; n++) a[n]->set_text("");
    } else {

	for (n=0; n<4; n++) 
        {
	    i=addr.find(".",j);
	    if ( i==string::npos ) 
            {
		a[n]->set_text(addr.substr(j));
		break;
	    }
	    a[n]->set_text( addr.substr(j,i-j) );
	    j=i+1;
	}
    }

    ignore_changed=false;
    on_changed();
}

/**
 *
 *  this method returns string representation of IP address. All empty
 *  entry fields are replaced with "0", so totally empty widget
 *  returns "0.0.0.0".  This ensures that widget always returns valid
 *  IP address
 */
string    IPAddressWidget::getAsString()
{
    string s;

    for (int n=0; n<4; n++) 
    {
	if (! a[n]->get_text().empty())       s+=a[n]->get_text();
	else                                  s+="0";
	if (n<3)
	    s+=".";
    }
    return s;
}

IPAddress IPAddressWidget::getAsIPAddress() throw(FWException)
{
    return IPAddress( getAsString() );
}

void IPAddressWidget::clear()
{
    setAddress("0.0.0.0");
}


bool IPAddressWidget::empty()
{
    bool r=true;
    for (int n=0; n<4; n++) 
	r = r && a[n]->get_text().empty();

    return r;
}

void IPAddressWidget::on_changed()
{
    if (ignore_changed) return;
#if 0
    if ( ! empty() ) 
    {
	try 
        {
	    getAsIPAddress();  /* checks address for validity */

	} catch(const FWException &ex) 
        {
	    MessageDialog::Error(ex.toString(), this);
	}

    }
#endif
    /* call signal now */
    changed();
}
