/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: IPv4Dialog.cc,v 1.7 2003/09/22 05:12:40 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "helpers.hh"

#include "IPv4Dialog.hh"
#include "IPAddressWidget.hh"
#include "helpers.hh"
#include "MessageDialog.hh"
#include "main_window.hh"

#include "fwbuilder/dns.hh"
#include "fwbuilder/Management.hh"
#include "fwbuilder/Firewall.hh"

using namespace libfwbuilder;


IPv4Dialog::IPv4Dialog(FWObject *obj)
{
    object=obj; 

    object_parameters.push_back( DialogOption( ipv4_name  , "name"     ) );
    object_parameters.push_back( DialogOption( comment    , "comment"  ) );

    obj_addr=manage(new IPAddressWidget());
    addr_table->attach(*obj_addr, 1, 2, 1, 2, GTK_FILL, 0, 0, 0);
    obj_addr->changed.connect(SigC::slot(this,&IPv4Dialog::on_changed));

    obj_netm=manage(new IPAddressWidget());
    addr_table->attach(*obj_netm, 1, 2, 2, 3, GTK_FILL, 0, 0, 0);
    obj_netm->changed.connect(SigC::slot(this,&IPv4Dialog::on_changed));

//    obj_addr->setAssociatedNetmaskWidget( obj_netm );

    object_parameters.push_back( DialogOption( obj_addr  , "address"  ) );
    object_parameters.push_back( DialogOption( obj_netm  , "netmask"  ) );

}

IPv4Dialog::~IPv4Dialog()
{
}


void IPv4Dialog::on_changed()
{  
    data_changed_flag(true);
}

void IPv4Dialog::on_dns_clicked()
{
    vector<IPAddress> addr;

    try {
        addr=DNS::getHostByName( ipv4_name->get_text() );
    } catch (FWException &e)
    {
        MessageDialog::Error( e.toString(), this );
        return;
    }

    obj_addr->setAddress( addr.front() );
}

void IPv4Dialog::wrk2dlg()
{
    loadPageOptions(object,  object_parameters );
    ipv4_name->grab_focus();
}

bool IPv4Dialog::dlg2wrk()
{
    try
    {
        checkIPaddress( obj_addr->getAsString() );
        checkNetmask(   obj_netm->getAsString() );
    } catch(FWException &ex)
    {
        MessageDialog::Error(ex.toString(),find_my_toplevel_window(this));
        return true;
    }

    savePageOptions(object,  object_parameters );
    return(true);
}

/**
 *  enable and disable menu items which make sence only for this object
 */
void IPv4Dialog::updateMainMenu()
{
    Gtk::MenuBar *main_menubar=main_w->getMainMenuBar();
    Gtk::Widget *itm;

    DialogPlugin::updateMainMenu();

    FWObject *p=object;
    while (p!=NULL && !Firewall::isA(p)) p=p->getParent();

    if (p!=NULL && Firewall::isA(p))
    {
        itm=find_widget("policy",main_menubar);
        if (itm) itm->set_sensitive(true);

        itm=find_widget("rules_druid",main_menubar);
        if (itm) itm->set_sensitive(true);

        itm=find_widget("compile_policy",main_menubar);
        if (itm) itm->set_sensitive(true);

        Management *mgmt=(Firewall::cast(p))->getManagementObject();
        assert(mgmt!=NULL);
        PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();

        itm=find_widget("install_policy",main_menubar);
        if (itm) itm->set_sensitive( pis->isEnabled() && pis->getCommand()!="" );
    }
}


