/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: InterfaceTblWidget.cc,v 1.2 2003/07/17 06:21:19 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "InterfaceTblWidget.hh"

#include <sstream>


using namespace libfwbuilder;
using namespace std;

InterfaceTblWidget::InterfaceTblWidget() : Gtk::Table(1,4)
{
    selected=-1;

    title1=NULL;
    title2=NULL;
    title3=NULL;
    title4=NULL;
}

InterfaceTblWidget::~InterfaceTblWidget()
{
    if (title1!=NULL) delete title1;
    if (title2!=NULL) delete title2;
    if (title3!=NULL) delete title3;
    if (title4!=NULL) delete title4;

    for (map<int,entry>::iterator i=interfaces.begin(); i!=interfaces.end(); i++)
    {
        Gtk::Widget *w;
        Gtk::Widget *pw;

        w=i->second.name_w;      pw=w->get_parent();

        delete pw;
        delete w;

        w=i->second.addr_w;      pw=w->get_parent();

        delete pw;
        delete w;

        w=i->second.label_w;     pw=w->get_parent();

        delete pw;
        delete w;

        w=i->second.sl_w;        pw=w->get_parent();

        delete pw;
        delete w;
    }    
}

void InterfaceTblWidget::setTitle()
{
    string sl_title= (sec_levels)?_("Security Level"):_("External");

    if (title1!=NULL) { remove(*title1); delete title1; }
    if (title2!=NULL) { remove(*title2); delete title2; }
    if (title3!=NULL) { remove(*title3); delete title3; }
    if (title4!=NULL) { remove(*title4); delete title4; }

    title1=new Gtk::Button( _("Name") );
    title2=new Gtk::Button( _("Address") );
    title3=new Gtk::Button( _("Label") );
    title4=new Gtk::Button( sl_title );

    attach( *title1 , 0,1, 0,1, GTK_FILL|GTK_EXPAND, 0);
    attach( *title2 , 1,2, 0,1, GTK_FILL|GTK_EXPAND, 0);
    attach( *title3 , 2,3, 0,1, GTK_FILL|GTK_EXPAND, 0);
    attach( *title4 , 3,4, 0,1, 0, 0);
}

void InterfaceTblWidget::removeEl(Gtk::Widget *w)
{
    Gtk::EventBox *pw=dynamic_cast<Gtk::EventBox*>(w->get_parent());
    assert(pw!=NULL);

    pw->remove();
    remove(*pw);

    delete w;
    delete pw;
}

void InterfaceTblWidget::clear()
{
    for (map<int,entry>::iterator i=interfaces.begin(); i!=interfaces.end(); i++)
    {
        removeEl( i->second.name_w  );
        removeEl( i->second.addr_w  );
        removeEl( i->second.label_w );
        removeEl( i->second.sl_w    );
    }

    interfaces.clear();
}

void   InterfaceTblWidget::select(unsigned idx)
{
    if (idx<unsigned(getSize()))
    {
        if (selected>=0)           deactivateRow(selected);
        activateRow(idx);
        selected=idx;
    }
}

void InterfaceTblWidget::activateRow(unsigned r)
{
    interfaces[r].name_w->get_parent()->set_state(GTK_STATE_SELECTED);
    interfaces[r].addr_w->get_parent()->set_state(GTK_STATE_SELECTED);
    interfaces[r].label_w->get_parent()->set_state(GTK_STATE_SELECTED);
    interfaces[r].sl_w->get_parent()->set_state(GTK_STATE_SELECTED);
}

void InterfaceTblWidget::deactivateRow(unsigned r)
{
    interfaces[r].name_w->get_parent()->set_state(GTK_STATE_NORMAL);
    interfaces[r].addr_w->get_parent()->set_state(GTK_STATE_NORMAL);
    interfaces[r].label_w->get_parent()->set_state(GTK_STATE_NORMAL);
    interfaces[r].sl_w->get_parent()->set_state(GTK_STATE_NORMAL);
}

gint InterfaceTblWidget::on_button_press_event(GdkEventButton *ev)
{
    GdkWindow  *wnd=ev->window;

    for (map<int,entry>::iterator i=interfaces.begin(); i!=interfaces.end(); i++)
    {
        if (i->second.name_w->gtkobj()->window==wnd ||
            i->second.addr_w->gtkobj()->window==wnd ||
            i->second.label_w->gtkobj()->window==wnd ||
            i->second.sl_w->gtkobj()->window==wnd) 
        { 
            select( i->first ); 
            break; 
        }
    }

    return 0;
}

int  InterfaceTblWidget::getSelectedInterfaceNum()
{
    return selected;
}

void InterfaceTblWidget::addInterface(const InterfaceData &_idata)
{
    int n=interfaces.size();

    Gtk::Widget      *sl;
    Gtk::EventBox    *eb;
    Gtk::Label       *name;
    Gtk::Label       *addr;
    Gtk::Label       *label;
    Gtk::Label       *lvl;
    Gtk::CheckButton *cb;


    eb=new Gtk::EventBox();
    name= new Gtk::Label( _idata.name  );
    eb->add(*name);
    attach( *eb , 0,1, n+1,n+2, GTK_FILL|GTK_EXPAND, 0);
    eb->button_press_event.connect(slot(this, &InterfaceTblWidget::on_button_press_event));

    eb=new Gtk::EventBox();
    addr= new Gtk::Label( _idata.address  );
    eb->add(*addr);
    attach( *eb , 1,2, n+1,n+2, GTK_FILL|GTK_EXPAND, 0);
    eb->button_press_event.connect(slot(this, &InterfaceTblWidget::on_button_press_event));

    eb=new Gtk::EventBox();
    label= new Gtk::Label( _idata.label );
    eb->add(*label);
    attach( *eb, 2,3, n+1,n+2, GTK_FILL|GTK_EXPAND, 0);
    eb->button_press_event.connect(slot(this, &InterfaceTblWidget::on_button_press_event));

    if (sec_levels)
    {
        ostringstream str;
        str << _idata.securityLevel;
        lvl= new Gtk::Label( str.str() );
        sl=lvl;
    } else
    {
        cb=new Gtk::CheckButton();
        cb->set_active( _idata.securityLevel==0 );
        sl=cb;
    }
    eb=new Gtk::EventBox();
    eb->add(*sl);
    attach( *eb, 3,4, n+1,n+2, GTK_FILL, 0);
    eb->button_press_event.connect(slot(this, &InterfaceTblWidget::on_button_press_event));

    interfaces[n].idata   = _idata;
    interfaces[n].name_w  = name;
    interfaces[n].addr_w  = addr;
    interfaces[n].label_w = label;
    interfaces[n].sl_w    = sl;
}



InterfaceData InterfaceTblWidget::getInterface(unsigned row)
{
    return interfaces[row].idata;
}

list<InterfaceData> InterfaceTblWidget::getInterfaces()
{
    list<InterfaceData> res;

    for (map<int,entry>::iterator i=interfaces.begin(); i!=interfaces.end(); i++)
    {
        if (!sec_levels)
            i->second.idata.securityLevel=
                (dynamic_cast<Gtk::CheckButton*>(i->second.sl_w)->get_active())?0:100;
        res.push_back( i->second.idata );
    }
    return res;
}

void InterfaceTblWidget::setInterfaces( list<InterfaceData> &ifaces)
{
    clear();
    for (list<InterfaceData>::iterator i=ifaces.begin(); i!=ifaces.end(); i++)
        addInterface(*i);
    show_all();
}

int InterfaceTblWidget::getSize()
{
    return interfaces.size();
}

