/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Navbar.cc,v 1.6 2002/11/06 07:47:28 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "Navbar.hh"

#include "FWObjectDatabaseGUI.hh"

#include "main_window.hh"
#include "helpers.hh"

#include "FWObjectBook.hh"

#include "PixmapButton.hh"
#include "StockButton.hh"

#include <unistd.h>

#include <gtk--.h>

#include <algorithm>
#include <functional>
#include <stack>

using namespace libfwbuilder;

Navbar::Navbar(main_window* _mw)
{
    mw=_mw;

    set_name("navbar");



    navbar_location_lbl=manage(new Gtk::Label(_("Location: ")));


    add(*navbar_location_lbl, GTK_SIDE_LEFT,GTK_ANCHOR_CENTER,0,0,10 );

    Gtk::Frame *frm=manage(new Gtk::Frame());
    frm->set_usize(300, -1);
    frm->set_shadow_type(GTK_SHADOW_IN);

    navbar_location=manage(new Gtk::Label());
    navbar_location->set_name("navbar_location");
    navbar_location->set_alignment(0.0,0.5);

    frm->add(*navbar_location);
    add(*frm, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER,0,0,0,2 );

    navbar_up  = manage(new Gtk::Button(""));
    navbar_up->set_relief(GTK_RELIEF_NONE);
    navbar_prev= manage(new Gtk::Button(""));
    navbar_prev->set_relief(GTK_RELIEF_NONE);
    navbar_next= manage(new Gtk::Button(""));
    navbar_next->set_relief(GTK_RELIEF_NONE);

    Gtk::Arrow *a;
    a= manage(new Gtk::Arrow(GTK_ARROW_UP   ,GTK_SHADOW_NONE) );
    navbar_up->remove();
    navbar_up->add( *a );
    a->show();

    a= manage(new Gtk::Arrow(GTK_ARROW_LEFT ,GTK_SHADOW_NONE) ); 
    navbar_prev->remove();
    navbar_prev->add( *a );
    a->show();

    a= manage(new Gtk::Arrow(GTK_ARROW_RIGHT,GTK_SHADOW_NONE) );
    navbar_next->remove();
    navbar_next->add( *a );
    a->show();


    add(*(manage(new Gtk::Label(""))),   // blank
                GTK_SIDE_LEFT, GTK_ANCHOR_CENTER,0,0,20 );


    add(*(manage(new Gtk::Label(_("Navigate:")))), 


                GTK_SIDE_LEFT, GTK_ANCHOR_CENTER,0,0,0 );

    add(*navbar_up  , GTK_SIDE_LEFT, GTK_ANCHOR_CENTER,0,0,10 );
    add(*navbar_prev, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER,0,0,10 );
    add(*navbar_next, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER,0,0,10 );
    navbar_up->clicked.connect(SigC::slot(this,   &Navbar::on_up_clicked));
    navbar_prev->clicked.connect(SigC::slot(this, &Navbar::on_prev_clicked));
    navbar_next->clicked.connect(SigC::slot(this, &Navbar::on_next_clicked));

    show_all();
}

void Navbar::update(const std::string &objid)
{
    update( FWObjectDatabase::db->getById( objid , true) );
}

void Navbar::update(FWObject* obj)
{
    string loc("");
    FWObject *o=obj;
    while(o!=NULL && o->getParent()!=NULL){//stop one step shy of the tree root
        string nm=o->getName();
        if (nm.empty())  nm=o->getTypeName();
        if (loc.empty()) loc=nm;
        else             loc=nm+"/"+loc;
        o=o->getParent();
    };
    if (mw->getObjectBook()->getCurrentLibrary()!="")  
        loc="/"+mw->getObjectBook()->getCurrentLibrary()+"/"+loc;
    else
        loc="/User/"+loc;
	


	
    navbar_location->set_text(loc);

    navbar_up->set_sensitive(
        ( obj->getId()!=FWObjectDatabase::db->getRootId() )  );
}

void  Navbar::on_next_clicked() 
{
    if(!mw->safe_to_close_right_pane()) return ;

    FWObject *obj=mw->nowShowingObject();
    FWObject *p=obj->getParent();

    if (p) {
	list<FWObject*>::iterator m=std::find(p->begin(),p->end(),obj);
	do { 
	    ++m;
	} while (m!=p->end() && obj->getLibrary()!=(*m)->getLibrary());
	if (m!=p->end() && ! Resources::global_res->getObjResourceBool((*m),"hidden"))
		mw->schedule_open_object( (*m)->getId() , (*m)->getLibrary() );
    }
}

void  Navbar::on_prev_clicked() 
{
    if(!mw->safe_to_close_right_pane()) return ;

    FWObject *obj=mw->nowShowingObject();
    FWObject *p=obj->getParent();
    if (p) {
	list<FWObject*>::iterator m=std::find(p->begin(),p->end(),obj);
	do { 
	    --m;
	} while (m!=p->end() && obj->getLibrary()!=(*m)->getLibrary());
	if (m!=p->begin() && m!=p->end() && ! Resources::global_res->getObjResourceBool((*m),"hidden"))
		mw->schedule_open_object( (*m)->getId() , (*m)->getLibrary() );
    }
}

void  Navbar::on_up_clicked() 
{
    if(!mw->safe_to_close_right_pane()) return ;

    FWObject *obj=mw->nowShowingObject();
    FWObject *p=obj->getParent();
    if (p)  mw->schedule_open_object( p->getId() , obj->getLibrary() );
    return;

/* alternative method */
    FWObjectBook *w=mw->getObjectBook();
    if (w!=NULL)  {
	w->showObject( obj->getId() );
	mw->schedule_open_object( w->getParentId() , obj->getLibrary() );
    }
}

