/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: NewFirewallDruidP20Dialog.cc,v 1.9 2003/09/22 05:12:40 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"

#include "NewFirewallDruidP20Dialog.hh"
#include "FWObjectDatabaseGUI.hh"
#include "InterfaceListWidget.hh"
#include "InterfaceData.hh"

using namespace libfwbuilder;
using namespace std;

NewFirewallDruidP20Dialog::NewFirewallDruidP20Dialog() 
{
    iface_list->select_row.connect(SigC::slot(this, 
                 &NewFirewallDruidP20Dialog::on_iface_list_select_row));

    iface_list->set_show_label(true);
    iface_list->set_show_ext(false);

//    iface_addr->setAssociatedNetmaskWidget(iface_netmask);
}

void NewFirewallDruidP20Dialog::prepare()
{
    iface_name->grab_focus();
}

void NewFirewallDruidP20Dialog::fillData(InterfaceData &idata)
{
    idata.name=iface_name->get_text();
    idata.label=iface_label->get_text();
    idata.isUnnumbered=iface_unnum->get_active();
    idata.isDyn=iface_dyn->get_active();

    if (!idata.isUnnumbered && !idata.isDyn)
    {
        idata.address=iface_addr->getAsString();
        idata.netmask=iface_netmask->getAsString();
    }
    idata.physicalAddress=iface_physaddr->get_text();
}

void NewFirewallDruidP20Dialog::on_add_clicked()
{  
    if (iface_name->get_text()=="") return;

    InterfaceData idata;
    idata.id   =FWObjectDatabaseGUI::db->generateUniqueId();
    fillData(idata);
    iface_list->addInterface(idata);
}

void NewFirewallDruidP20Dialog::on_update_clicked()
{  
    string id=iface_list->getSelectedInterfaceId();
    int    row=iface_list->getRowById(id);
    InterfaceData idata;
    fillData(idata);
    iface_list->updateInterface(row,idata);
}

void NewFirewallDruidP20Dialog::on_delete_clicked()
{  
    iface_list->removeInterface( iface_list->getSelectedInterfaceId() );
    iface_list->select(0);
}

void NewFirewallDruidP20Dialog::on_iface_dyn_toggled()
{  
    if (iface_dyn->get_active())
    {
        iface_addr->clear();
        iface_netmask->clear();
        iface_addr->set_sensitive(false);
        iface_netmask->set_sensitive(false);
    } else
    {
        iface_addr->set_sensitive(true);
        iface_netmask->set_sensitive(true);
    } 
}

void NewFirewallDruidP20Dialog::on_iface_unnum_toggled()
{  
    if (iface_unnum->get_active())
    {
        iface_dyn->set_active(false);
        iface_addr->clear();
        iface_netmask->clear();
        iface_dyn->set_sensitive(false);
        iface_addr->set_sensitive(false);
        iface_netmask->set_sensitive(false);
    } else
    {
        iface_dyn->set_sensitive(true);
        iface_addr->set_sensitive(true);
        iface_netmask->set_sensitive(true);
    } 
}


void NewFirewallDruidP20Dialog::on_iface_list_select_row(gint row, 
                                           gint column, 
                                           GdkEvent *event)
{   
    InterfaceData idata=iface_list->getInterface(row);
    if (idata.name!="")
    {
        iface_name->set_text(idata.name);
        iface_label->set_text(idata.label);
        iface_unnum->set_active(idata.isUnnumbered);
        iface_dyn->set_active(idata.isDyn);
        if (!idata.isUnnumbered && !idata.isDyn)
        {
            iface_addr->setAddress(idata.address);
            iface_netmask->setAddress(idata.netmask);
        }
        iface_physaddr->set_text( idata.physicalAddress );
    }
}

void NewFirewallDruidP20Dialog::addInterface(const InterfaceData &idata)
{
    iface_list->addInterface(idata);
}

list<InterfaceData>  NewFirewallDruidP20Dialog::getInterfaces()
{
    return iface_list->getInterfaces();
}

void NewFirewallDruidP20Dialog::setInterfaces(std::list<InterfaceData> &ifaces)
{
    iface_list->setInterfaces(ifaces);
}

