/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PolicyListElement.hh,v 1.22 2002/11/12 08:32:36 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _POLICYLISTELEMENT_HH
#define _POLICYLISTELEMENT_HH

#include <gtk--.h>

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Policy.hh"
#include "fwbuilder/RuleElement.hh"

class RuleSetList;
class PolicyList;
class PolicyListItem;
class popupMenu;

class PolicyListElement : public  Gtk::Frame 
{
    friend class PolicyListItem;

    gint        x,y,width,height;
    gint        row,col;
    bool        selected;
    bool        neg;

    virtual gint key_press_event_impl(GdkEventKey* p0);
    virtual void drag_data_received_impl(GdkDragContext* p0,
					 gint p1,
					 gint p2,
					 GtkSelectionData* p3,
					 guint p4,
					 guint32 p5);

protected:

    Gtk::VBox                           *vbox;

    Gtk::Widget                         *selected_item;
    libfwbuilder::RuleElement           *rel;
    libfwbuilder::Rule                  *rule;
    bool                                 change_any_to_orig;

    popupMenu                           *popup_menu;
    PolicyListItem                      *popup_menu_pi;

    virtual void size_allocate_impl(GtkAllocation *p0);

    Gtk::Widget* get_first_child();
    Gtk::Widget* get_last_child();

    virtual void build();

    void addPolicyListItem(PolicyListItem *pi);
    void removePolicyListItem(PolicyListItem *pi=NULL);

public:

    PolicyListElement(gint row,  gint col, libfwbuilder::RuleElement *re);
    PolicyListElement(gint row,gint col);
    virtual ~PolicyListElement();

    void remove_item_from_policy(PolicyListItem* pi);
//  void add_item_to_policy(string name);
    bool add_item_to_policy(libfwbuilder::FWObject *obj);

    virtual void setNeg(bool val);

    int  get_row() { return row; }
    void set_row(int r) { row=r; }
    int  get_col() { return col; }

    void ref()   { Gtk::Object::reference();   }
    void unref() { Gtk::Object::unreference(); }

    int  getX()      { return x;  }
    int  getY()      { return y;  }
    gint getWidth()  {  return width;  }
    gint getHeight() {  return height; }

    bool getNeg()    { return neg; }

    void activate();
    void deactivate();

    void select(bool select_row=true);
    void set_current_selected(Gtk::Widget *itm);
    void select_first_child();
    void select_last_child();

    void deselect();
    void deselect_all();

    void request_focus();

    libfwbuilder::RuleElement* get_rule_element() { return rel; };

    virtual void create_popup_menu();
    virtual void show_popup_menu(PolicyListItem *itm);
    virtual void popup_menu_callback(int n);

    RuleSetList* getParentRuleSetList();

    virtual void init();

    void set_data_changed_flag(bool f);
};

class PolicyListRuleNum : public PolicyListElement {
    int  rule_n;
    bool neg;
    virtual gboolean drag_motion_impl(GdkDragContext* p0,
				      gint p1,gint p2,guint p3);
    virtual void drag_data_received_impl(GdkDragContext* p0,
					 gint p1,
					 gint p2,
					 GtkSelectionData* p3,
					 guint p4,
					 guint32 p5);
    protected:
    virtual void build();
    public:
    PolicyListRuleNum(gint row,gint col,gint rule_n,bool neg);
    virtual ~PolicyListRuleNum() {};
    void setNum(int num);
    virtual void create_popup_menu();
    virtual void show_popup_menu(PolicyListItem *itm);
    virtual void popup_menu_callback(int n);
};

/*******************************************************************/

class PolicyListRuleAction : public PolicyListElement {
    protected:
    virtual void build();
    public:
    PolicyListRuleAction(gint row, gint col, libfwbuilder::Rule *r);
    virtual ~PolicyListRuleAction() {};
    virtual void create_popup_menu();
    virtual void show_popup_menu(PolicyListItem *itm);
    virtual void popup_menu_callback(int n);
};

/*******************************************************************/

class PolicyListRuleLog : public PolicyListElement {
    protected:
    virtual void build();
    public:
    PolicyListRuleLog(gint row, gint col, libfwbuilder::Rule *r);
    virtual ~PolicyListRuleLog() {};
    virtual void create_popup_menu();
    virtual void show_popup_menu(PolicyListItem *itm);
    virtual void popup_menu_callback(int n);
};

/*******************************************************************/

class PolicyListRuleComment : public PolicyListElement {
    protected:
    virtual void build();
    public:
    PolicyListRuleComment(gint row, gint col, libfwbuilder::Rule *r);
    virtual ~PolicyListRuleComment() {};
    virtual void create_popup_menu();
    virtual void show_popup_menu(PolicyListItem *itm);
    virtual void popup_menu_callback(int n);
};

/*******************************************************************/

class PolicyListRuleDir : public PolicyListElement {
    protected:
    virtual void build();
    public:
    PolicyListRuleDir(gint row, gint col, libfwbuilder::Rule *r);
    virtual ~PolicyListRuleDir() {};
    virtual void create_popup_menu();
    virtual void show_popup_menu(PolicyListItem *itm);
    virtual void popup_menu_callback(int n);
};

/*******************************************************************/

class PolicyListRuleOpt : public PolicyListElement {
    protected:
    virtual void build();
    public:
    PolicyListRuleOpt(gint row, gint col, libfwbuilder::Rule *r);
    virtual ~PolicyListRuleOpt() {};
    virtual void create_popup_menu();
    virtual void show_popup_menu(PolicyListItem *itm);
    virtual void popup_menu_callback(int n);
};


#endif









