/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PrintDialog.cc,v 1.37 2003/07/06 06:17:02 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "config.h"
#include "PrintDialog.hh"
#include "FileSel.hh"
#include "Preferences.hh"
#include "ExecDialog.hh"
#include "MessageDialog.hh"

#include "fwbuilder/FWObjectDatabase.hh"
#include "fwbuilder/XMLTools.hh"

#include <stdlib.h>
#include <unistd.h>
#include <iostream>

using namespace libfwbuilder;

const string PrintDialog::FILTERS_DIR = TEMPLATE_DIR  "/filters";
const string text_filter="policy-text.xsl";
const string html_filter="policy-html.xsl";

PrintDialog::PrintDialog(const gchar *id) : PrintDialog_glade()
{
    choice = false;
    current_node = id;

    // Init GUI using prefs data
    loadPrefs();

#ifdef __MINGW32__
    __fwb_win32_loadIcon("FWBuilderWin32Ico",this);
#endif
}

PrintDialog::~PrintDialog() {}


void PrintDialog::savePrefs()
{
    // We do not save last file name into preferences!
    Preferences::global_prefs->setOpt("/FWBuilderPreferences/Print/Command"   , command );
    Preferences::global_prefs->setOpt("/FWBuilderPreferences/Print/Filter"    , filter  );
    Preferences::global_prefs->setOptBool("/FWBuilderPreferences/Print/ToFile", to_file );
    try
    {
        Preferences::global_prefs->savePrefs();
    } catch(FWException &ex)
    {
        cerr << _("Error saving preferences: ") << ex.toString() << endl ;
    }
}

void PrintDialog::loadPrefs()
{
    command = Preferences::global_prefs->getOptStr("/FWBuilderPreferences/Print/Command"    );
    filter  = Preferences::global_prefs->getOptStr("/FWBuilderPreferences/Print/Filter"     );
    to_file = Preferences::global_prefs->getOptBool("/FWBuilderPreferences/Print/ToFile" );
    filename = "";

    print_cmd->set_text(command);
    print_filename->set_text("");
    if (filter==text_filter) print_text->set_active(true);
    if (filter==html_filter) print_html->set_active(true);
    file->set_active(to_file);
}


void PrintDialog::on_ok_clicked()
{  
    choice = true;
    Gtk::Main::quit();
}

void PrintDialog::on_cancel_clicked()
{  
    choice = false;
    Gtk::Main::quit();
}

void PrintDialog::on_choose_file_clicked()
{  
    FileSel *fs=new FileSel(_("Select file"),
                            Preferences::global_prefs->getWdir(),
                            "");
    string df=fs->run();
    delete fs;
    if(df!="")
        print_filename->set_text(df);

}

void PrintDialog::on_printer_toggled()
{  
    if (printer->get_active())
    {
        print_cmd->set_sensitive(true);
        print_filename->set_sensitive(false);
        choose_file->set_sensitive(false);
    }
}

void PrintDialog::on_file_toggled()
{  
    if (file->get_active())
    {
        print_cmd->set_sensitive(false);
        print_filename->set_sensitive(true);
        choose_file->set_sensitive(true);
    }
}


void PrintDialog::run() throw(FWException)
{
    if (printer->get_active())
    {
        print_cmd->set_sensitive(true);
        print_filename->set_sensitive(false);
        choose_file->set_sensitive(false);
    }

    if (file->get_active())
    {
        print_cmd->set_sensitive(false);
        print_filename->set_sensitive(true);
        choose_file->set_sensitive(true);
    }

    while (1)
    {
        Gtk::Main::grab_add(*this);
        Gtk::Main::run();
        Gtk::Main::grab_remove(*this);
    
        if(!choice)    // cancel
        {
            hide();
            return;
        }

        command =print_cmd->get_text();
        filename=print_filename->get_text();

        to_file =file->get_active();
        if (print_text->get_active()) filter=text_filter;
        if (print_html->get_active()) filter=html_filter;

        if (!to_file && command.empty()) 
        {
            MessageDialog::Error(_("Print command should not be empty"),this);
            continue;
        }
        if (to_file && filename.empty()) 
        {
            MessageDialog::Error(_("Need a file name when printing to file"),this);
            continue;
        }

        break;
    }

    hide();
    savePrefs();

// copies entire tree
    FWObjectDatabase *dbcopy=new FWObjectDatabase( *FWObjectDatabase::db );
        
    string src_file, dst_file;

    try
    {
        char fnbuf[64];
        strcpy(fnbuf,"/tmp/fwb_print_XXXXXX");
        int fh=mkstemp(fnbuf);
        if (fh<0)  throw FWException(_("Could not create temporary file"));
        src_file=fnbuf;
        close(fh);

        dbcopy->saveFile(src_file);

    } catch(FWException &ex)
    {
        delete dbcopy;
        throw;
    }

    const char *params[3];
    string p1;
    if(print_current->get_active() && current_node)
    {
        // Printing only current node.
        // pass ID of the current node
        // to XSLT processor
        p1=string("'") + current_node + "'";
    } else
    {
        // printing the whole tree
        // pass ID of the root node
        // to XSLT processor
        p1=string("'") + dbcopy->getId() + "'";
    } 
    params[0]="PrintFrom";
    params[1]=p1.c_str();
    params[2]=NULL;

    if(to_file)
    {
        dst_file=filename;
    } else
    {
        char fnbuf[64];
        strcpy(fnbuf,"/tmp/fwb_print_XXXXXX");
        int fh=mkstemp(fnbuf);
        if (fh<0)  throw FWException(_("Could not create temporary file"));
        dst_file=fnbuf;
        close(fh);
    }

    try
    {
        XMLTools::transformFileToFile(src_file,
				      FILTERS_DIR+"/"+filter, 
				      params,
				      dst_file
        );
    } catch(FWException &ex)
    {
        unlink(src_file.c_str());
        delete dbcopy;
        throw;
    }
  
    if(!to_file)
    {
        ExecDialog *cmpl= new ExecDialog(command , dst_file);
        cmpl->execute();
        delete cmpl;
	unlink(dst_file.c_str());
    }
    unlink(src_file.c_str());
    delete dbcopy;
}
