/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: helpers.hh,v 1.33 2003/04/07 01:04:41 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _HELPERS_HH
#  define _HELPERS_HH

#include "config.h"

#include <list>
#include <string>

#include <gtk/gtkselection.h>
#include <gtk--/widget.h>
#include <gtk--/dialog.h>
#include <gtk--/pixmap.h>

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Resources.hh"

#include "FWObjectClipboard.hh"
#include "Preferences.hh"


Gtk::Widget* find_widget(const char *wname,Gtk::Widget *wp);
Gtk::Widget* find_gtk_widget(GtkWidget *gtkobj,Gtk::Widget *awp);
Gtk::Widget* print_widget_tree(gint offset,Gtk::Widget *wp);
Gtk::Window* find_my_toplevel_window(Gtk::Widget *wp);

void widgetModifyFont (Gtk::Widget   *widget,
		       gchar         *fontset_name);

void  dialog_set_changed_callback(Gtk::Dialog *callback_object);

void  setButtonLblAlignment(Gtk::Button *btn, gfloat x, gfloat y);

void  checkObjectName(const string& name)        throw(libfwbuilder::FWException);
void  checkIPaddress(const string& ipAddress)    throw(libfwbuilder::FWException);
void  checkNetmask(const string& ipAddress)      throw(libfwbuilder::FWException);
void  checkMACAddress(const string& MACAddress)  throw(libfwbuilder::FWException);

libfwbuilder::FWObject* _findObjectByName(const string &tree_id, const string &name,bool match_case=true,bool partial_match=false);
libfwbuilder::FWObject* _findObjectByName(libfwbuilder::FWObject *tree , const string &name,bool match_case=true,bool partial_match=false);


Gtk::Menu *createOptionsMenu( vector<string> &items , 
			      string &active_item,
			      SigC::Slot0<void> on_changed_callback );

Gtk::Menu *createOptionsMenu( map<string,string> &items , 
			      string &active_item,
			      SigC::Slot0<void> on_changed_callback );


extern void beginTimestamp();
extern void printTimestamp(const char* str);

enum  {
  TARGET_STRING,
  TARGET_OBJ,
  TARGET_ROOTWIN,
  TARGET_URL
};

extern GtkTargetEntry target_table[];
extern guint n_targets;

#ifdef __MINGW32__
void   __fwb_win32_loadIcon(string iname,Gtk::Widget* widget);
void   __fwb_win32_loadIcon(string iname,Gtk::Window* window);
string __fwb_win32_getWinDir();
string __fwb_win32_getCurrentProfileDir();
#endif

#endif

