/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: platforms.cc,v 1.10 2003/02/18 07:11:10 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "fwbuilder/Firewall.hh"
#include "fwbuilder/FWOptions.hh"
#include "fwbuilder/Management.hh"

#include <assert.h>

using namespace libfwbuilder;


bool isUsingNetZone(libfwbuilder::Firewall *fw)
{
    string platform=fw->getStr("platform");
    return (platform=="pix");
}

bool isDefaultOptions(libfwbuilder::FWOptions *opt)
{
    bool res=false;
    FWObject *p;

    p=opt;
    do {  p=p->getParent();
    } while ( p!=NULL && Firewall::cast(p)==NULL );

    assert(p!=NULL);

    string platform = p->getStr("platform");

    if (PolicyRuleOptions::isA(opt)) {

	if (platform=="ipfilter") 
        {
	    res= ( ! opt->getBool("log_or_block") && 
		   ! opt->getBool("log_body")     &&
		   ! opt->getBool("log_first")    &&
		   ! opt->getBool("icmp_as_dest") &&
		   opt->getStr("action_on_reject").empty() );
	}

	if (platform=="iptables") 
        {
	    res= ( opt->getStr("log_prefix").empty()       && 
                   opt->getStr("log_level").empty()        && 
		   opt->getStr("action_on_reject").empty() && 
		   opt->getInt("limit_value")<=0  &&
		   opt->getInt("limit_burst")<=0  &&
		   opt->getBool("stateless")==false );
	}

	if (platform=="pix") 
        {
	    res= true;         // no options yet
	}

	if (platform=="pf") 
        {
	    res= ( opt->getStr("action_on_reject").empty() && 
		   opt->getBool("scrub")==false &&
		   opt->getBool("stateless")==false );
	}

	if (platform=="ipf") 
        {
	    res= ( opt->getStr("action_on_reject").empty() && 
		   ! opt->getBool("stateless") &&
		   ! opt->getBool("ipf_keep_frags") &&
                   ! opt->getBool("ipf_return_icmp_as_dest") );
	}

	if (platform=="ipfw") 
        {
	    res= ( opt->getStr("action_on_reject").empty() && 
		   ! opt->getBool("stateless") );
	}

    }
    return res; 
}


