/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: NATCompiler_ipfw.cc,v 1.1 2003/02/17 20:34:40 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "NATCompiler_ipfw.hh"

#include "fwbuilder/FWObjectDatabase.hh"
#include "fwbuilder/RuleElement.hh"
#include "fwbuilder/NAT.hh"
#include "fwbuilder/AddressRange.hh"
#include "fwbuilder/IPService.hh"
#include "fwbuilder/ICMPService.hh"
#include "fwbuilder/TCPService.hh"
#include "fwbuilder/UDPService.hh"
#include "fwbuilder/Host.hh"
#include "fwbuilder/Network.hh"
#include "fwbuilder/Interface.hh"
#include "fwbuilder/Firewall.hh"

#include <iostream>

#include <assert.h>

using namespace libfwbuilder;
using namespace fwcompiler;
using namespace std;

string NATCompiler_ipfw::myPlatformName() { return "ipfw"; }


int NATCompiler_ipfw::prolog()
{

    int n=NATCompiler_pf::prolog();

    return n;
}

void NATCompiler_ipfw::compile()
{
    cout << _(" Compiling NAT rules for ") << fw->getName() << " ..." << endl << flush;

    try {

	Compiler::compile();

        add( new Begin("Begin processing") );
        add( new printTotalNumberOfRules() );

        add( new simplePrintProgress() );

        runRuleProcessors();

    } catch (FWException &ex) {
	error(ex.toString());
	exit(1);
    }
}


void NATCompiler_ipfw::epilog()
{
    cout << _(" NAT rules compiled successfully \n") << flush;
}
