/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TargetDialog_solaris.cc,v 1.7 2002/09/28 17:34:58 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "TargetDialog_solaris.hh"
#include "fwbuilder/Resources.hh"

#include "fwbuilder/Firewall.hh"

using namespace libfwbuilder;

DialogPlugin* create_dialog_solaris(FWObject *o)
{
    return new TargetDialog_solaris(o);
}


TargetDialog_solaris::TargetDialog_solaris(FWObject *obj) 
{ 
    object=obj;

    fwoptions=(Firewall::cast(object))->getOptionsObject();
    assert(fwoptions!=NULL);

    map<string,string>        on_off_menu;
    on_off_menu["1"]=_("On");
    on_off_menu["0"]=_("Off");
    on_off_menu[DialogPlugin::magic_empty_option]=_("No change");



    solaris_ip_forward->set_menu(on_off_menu);
    solaris_ip_forward->changed.connect(SigC::slot(this,&TargetDialog_solaris::on_changed));
    solaris_ip_forward->show_all();

    solaris_ip_forward_src_routed->set_menu(on_off_menu);
    solaris_ip_forward_src_routed->changed.connect(SigC::slot(this,&TargetDialog_solaris::on_changed));
    solaris_ip_forward_src_routed->show_all();

    solaris_ip_forward_directed_broadcasts->set_menu(on_off_menu);
    solaris_ip_forward_directed_broadcasts->changed.connect(SigC::slot(this,&TargetDialog_solaris::on_changed));
    solaris_ip_forward_directed_broadcasts->show_all();

    solaris_ip_ignore_redirect->set_menu(on_off_menu);
    solaris_ip_ignore_redirect->changed.connect(SigC::slot(this,&TargetDialog_solaris::on_changed));
    solaris_ip_ignore_redirect->show_all();

    solaris_ip_respond_to_echo_broadcast->set_menu(on_off_menu);
    solaris_ip_respond_to_echo_broadcast->changed.connect(SigC::slot(this,&TargetDialog_solaris::on_changed));
    solaris_ip_respond_to_echo_broadcast->show_all();


    options.push_back( DialogOption(  solaris_ip_forward                     , "solaris_ip_forward"                     ) );
    options.push_back( DialogOption(  solaris_ip_forward_src_routed          , "solaris_ip_forward_src_routed"          ) );
    options.push_back( DialogOption(  solaris_ip_forward_directed_broadcasts , "solaris_ip_forward_directed_broadcasts" ) );
    options.push_back( DialogOption(  solaris_ip_ignore_redirect             , "solaris_ip_ignore_redirect"             ) );
    options.push_back( DialogOption(  solaris_ip_respond_to_echo_broadcast   , "solaris_ip_respond_to_echo_broadcast"   ) );

    options.push_back( DialogOption(  solaris_path_ipf  , "solaris_path_ipf"));
    options.push_back( DialogOption(  solaris_path_ipnat, "solaris_path_ipnat"));
}

void TargetDialog_solaris::on_changed()
{   
    DialogPlugin::data_changed_flag(true);
}

void TargetDialog_solaris::readDefaults()
{
    solaris_ip_forward->set_active_item_by_label(
        Resources::os_res["solaris"]->getResourceStr(
            "/FWBuilderResources/Target/options/solaris_ip_forward"));
}

void TargetDialog_solaris::wrk2dlg()
{
    loadPageOptions(fwoptions,  options);
}

bool TargetDialog_solaris::dlg2wrk()
{
    savePageOptions(fwoptions,  options );
    return true;
}
