/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: ObjectEditor.cpp,v 1.24 2004/06/20 06:01:21 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "config.h"
#include "global.h"
#include "utils.h"

#include "ObjectEditor.h"

#include <qobject.h>
#include <qpixmap.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qobjectlist.h>
#include <qlayout.h>

#include "DialogFactory.h"
#include "FWBTree.h"
#include "FWWindow.h"
#include "FWBSettings.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/Firewall.h"
#include "fwbuilder/Host.h"
#include "fwbuilder/Network.h"
#include "fwbuilder/IPv4.h"
#include "fwbuilder/AddressRange.h"
#include "fwbuilder/ObjectGroup.h"

#include "fwbuilder/Resources.h"
#include "fwbuilder/FWReference.h"
#include "fwbuilder/Interface.h"
#include "fwbuilder/RuleSet.h"
#include "fwbuilder/InterfacePolicy.h"
#include "fwbuilder/Rule.h"

#include "fwbuilder/CustomService.h"
#include "fwbuilder/IPService.h"
#include "fwbuilder/ICMPService.h"
#include "fwbuilder/TCPService.h"
#include "fwbuilder/UDPService.h"
#include "fwbuilder/ServiceGroup.h"

#include "fwbuilder/Interval.h"
#include "fwbuilder/IntervalGroup.h"

#include <iostream>

using namespace std;
using namespace libfwbuilder;

#define OBJTREEVIEW_WIDGET_NAME  "ObjTreeView"



ObjectEditor::ObjectEditor( QWidget *parent )
{
    opened       = NULL;
    visible      = -1;

#if defined(Q_WS_X11)
/* do something that makes sense only on X11 */

#elif defined(Q_OS_WIN32) || defined(Q_OS_CYGWIN)
/* do something that only works on windows */

#elif defined(Q_OS_MAC)

#endif

    int n=1;

    QWidget *w;
    w= DialogFactory::createDialog(parent,Library::TYPENAME);
    stackIds[Library::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,IPv4::TYPENAME);
    stackIds[IPv4::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,physAddress::TYPENAME);
    stackIds[physAddress::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,AddressRange::TYPENAME);
    stackIds[AddressRange::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,Firewall::TYPENAME);
    stackIds[Firewall::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,Host::TYPENAME);
    stackIds[Host::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,Interface::TYPENAME);
    stackIds[Interface::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,Network::TYPENAME);
    stackIds[Network::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,CustomService::TYPENAME);
    stackIds[CustomService::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,IPService::TYPENAME);
    stackIds[IPService::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,ICMPService::TYPENAME);
    stackIds[ICMPService::TYPENAME]= n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,TCPService::TYPENAME);
    stackIds[TCPService::TYPENAME] = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,UDPService::TYPENAME);
    stackIds[UDPService::TYPENAME] = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,ObjectGroup::TYPENAME);
    stackIds[ObjectGroup::TYPENAME] = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,ServiceGroup::TYPENAME);
    stackIds[ServiceGroup::TYPENAME] = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,IntervalGroup::TYPENAME);
    stackIds[IntervalGroup::TYPENAME] = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,Interval::TYPENAME);
    stackIds[Interval::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,Rule::TYPENAME);
    stackIds[Rule::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,PolicyRule::TYPENAME);
    stackIds[PolicyRule::TYPENAME]  = n;
    dialogs[n++] = w;

    w= DialogFactory::createDialog(parent,NATRule::TYPENAME);
    stackIds[NATRule::TYPENAME]  = n;
    dialogs[n++] = w;

}

void ObjectEditor::show()
{
    dialogs[ visible ]->adjustSize();
    if (st->haveGeometry(dialogs[ visible ]))
        st->restoreGeometry(dialogs[ visible ]);
    if (st->haveScreenPosition("Object Editor"))
        dialogs[ visible ]->move(st->getScreenPosition("Object Editor"));
    dialogs[ visible ]->show();
}

void ObjectEditor::hide()
{
    if (visible==-1)
    {
        QMap<QString, int>::iterator i;
        for (i=stackIds.begin(); i!=stackIds.end(); ++i)
            dialogs[ i.data() ]->hide();
    } else
    {
        st->saveGeometry(dialogs[ visible ]);
//        QPoint p = dialogs[ visible ]->pos();
        QRect   g = dialogs[ visible ]->geometry();
        g.moveTopLeft(dialogs[ visible ]->frameGeometry().topLeft());

        if (g.x()!=0 && g.y()!=0)
            st->saveScreenPosition("Object Editor",g.topLeft());

        dialogs[ visible ]->hide();
    }
    visible=-1;
}

bool ObjectEditor::isVisible()
{
    return (visible!=-1);
}

void ObjectEditor::open(FWObject *obj)
{
    if (stackIds.count(obj->getTypeName().c_str())!=0)
    {
        int wid= stackIds[obj->getTypeName().c_str()];

        disconnect( SIGNAL(loadObject_sign(libfwbuilder::FWObject*)) );
        disconnect( SIGNAL(validate_sign(bool*)) );
        disconnect( SIGNAL(isChanged_sign(bool*)) );
        disconnect( SIGNAL(applyChanges_sign()) );

//        parent->setUpdatesEnabled(false);
//        setUpdatesEnabled(false);

        hide();

        visible=wid;

//        parent->adjustSize();
//        adjustSize();

        show();

//        setUpdatesEnabled(true);
//        parent->setUpdatesEnabled(true);

        connect(this, SIGNAL(loadObject_sign(libfwbuilder::FWObject*)),
                dialogs[ wid ],
                SLOT(loadFWObject(libfwbuilder::FWObject*)));

        connect(this, SIGNAL(validate_sign(bool*)),
                dialogs[ wid ],
                SLOT(validate(bool*)));
                
        connect(this, SIGNAL(isChanged_sign(bool*)),
                dialogs[ wid ],
                SLOT(isChanged(bool*)));
                
        connect(this, SIGNAL(applyChanges_sign()),
                dialogs[ wid ],
                SLOT(applyChanges()));

        connect(this, SIGNAL(discardChanges_sign()),
                dialogs[ wid ],
                SLOT(discardChanges()));

        connect(dialogs[ wid ], SIGNAL(close_sign(QCloseEvent*)),
                this,
                SLOT(validateAndClose(QCloseEvent*)));

        emit loadObject_sign(obj);
    }

    opened = obj;
}

/* editor window needs to close. Check if something changed in it and
 * accept or not closing event
 */
void ObjectEditor::validateAndClose(QCloseEvent *e)
{
    if (validateDialog()) e->accept();
    else                  e->ignore();
}

bool ObjectEditor::validateDialog()
{
    if (opened==NULL) return true;
    bool isgood=true;

    try
    {
        emit validate_sign( &isgood );
    
        if (isgood)
        {
            bool ischanged=false;
            emit isChanged_sign(&ischanged);
            if (!ischanged) return true;
            if (!isTreeReadWrite(dialogs[ visible ],FWObjectDatabase::db) )
                return true;

/* there are changes and the tree is writable */
            if (st->getAutoSave())
            {
                emit applyChanges_sign();
                return true;
            } else
            {
                switch ( QMessageBox::warning(dialogs[ visible ],
                                              "Firewall Builder",
                                              tr("This object has been modified but not saved.\nDo you want to save it before switching to another object?"),
                                              tr("&Save"), tr("&Discard"), tr("&Continue editing"),
                                              0, 2 ) )
                {
                case 0:
                    emit applyChanges_sign();
                    return true;
                    break;
                case 1:
                    emit discardChanges_sign();
                    return true;
                    break;
                case 2:
                    return false;
                    break;
                }
            }
        }
    }
    catch (FWException &ex)
    {
/* catch all unhandled exceptions that could happen during validation
 * or saving */
        cerr << "Unknown exception in ObjectManipulator::validateDialog(): " << ex.toString() << endl;
    }
    return false;
}

