/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: SSHSession.h,v 1.3 2004/09/22 04:41:53 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef  __SSHSESSION_H_
#define  __SSHSESSION_H_

#include "../../config.h"
#include "global.h"

#include <qstring.h>
#include <qstringlist.h>
#include <qprocess.h>
#include <qobject.h>

#include <fstream>


class instConf;

class SSHSession : public QObject {

    Q_OBJECT

 protected:

    QProcess   *proc;
    QString     stdoutBuffer;
    QString     stderrBuffer;
    QString     ssh;
    QString     scp;
    QString     cmd;
    QStringList args;
    QStringList input;

    bool       closeStdin;
    bool       logged_in;
    bool       enable;
    bool       configure;
    
    enum State { NONE,
                 LOGGEDIN,
                 WAITING_FOR_ENABLE,
                 ENABLE,
                 CONFIG,
                 COMMAND_SENT,
                 WAITING_FOR_SHOW_RUN,
                 WAITING_FOR_CONFIG_PROMPT,
                 CLEAR_CONFIG,
                 PUSHING_CONFIG,
                 EXIT_FROM_CONFIG,
                 SAVE_CONFIG,
                 RUN_SCRIPT,
                 EXIT,
                 FINISH,
                 EXECUTING_COMMAND,
                 COMMAND_DONE
    };

    enum State state;
    int        phase;
    bool       verbose;
    bool       quiet;

    bool        backup;
    bool        incremental;
    bool        dry_run;
    bool        stripComments;
    bool        testRun;
    QString     wdir;
    QString     conffile;
    QString     backupFile;
    QString     diff_pgm;
    bool        save_diff;
    QString     diff_file;
    
    QString     normal_prompt;
    QString     fwb_prompt;
    QString     enable_prompt;
    QString     pwd_prompt;
    QString     putty_pwd_prompt;
    QString     scp_pwd_prompt;
    QString     ssh_pwd_prompt;
    QString     ssoft_prompt1;
    QString     ssoft_prompt2;
    QString     ssoft_config_prompt;
    QString     sudo_pwd_prompt;
    QString     passphrase_prompt;
    QString     epwd_prompt;
    
    QStringList errorsInit;
    QStringList errorsLoggedin;
    QStringList errorsEnabledState;
    
    QString pwd;
    QString epwd;
    QString host;

    static char* newKeyOpenSSH;
    static char* newKeyPlink;
    static char* newKeyVsh;
    static char* fingerprintPrompt;
    
    QString newKeyMsg;

    
    bool cmpPrompt(const QString &str,const QString &prompt);
    
public:
    
    SSHSession(const QString &host,
	       const QStringList &args,
	       const QString &pwd,
	       const QString &epwd,
	       const QStringList &in);
    virtual ~SSHSession();

    virtual void stateMachine();

    void startSession();
    void terminate();

    void setOptions(instConf *cnf);

    void setCloseStdin(bool f) { closeStdin=f; }
    
    void setFWBPrompt(const QString &p) { fwb_prompt=p; }
    void setQuiet(bool f) { quiet=f; }
    void setVerbose(bool f) { verbose=f; }
    void setBackup(bool f) { backup=f; }
    void setIncr(bool f) { incremental=f; }
    void setDryRun(bool f) { dry_run=f; }
    void setTestRun(bool f) { testRun=f; }
    void setStripComments(bool f) { stripComments=f; }
    void setWDir(const QString &wd) { wdir=wd; }
    void setConfFile(const QString &cf) { conffile=cf; }
    void setBackupFile(const QString &cf) { backupFile=cf; }
    void setSaveDiff(bool f) { save_diff=f; }
    void setDiffPgm(const QString &v) { diff_pgm=v; }
    void setDiffFile(const QString &v) { diff_file=v; }
    
public slots:
     void readFromStdout();
     void readFromStderr();
     void processExited();
     void allDataSent();
     
 signals:

 void printStdout_sign(const QString &line);
 void sessionFinished_sign();
 void updateProgressBar_sign(int n,bool setsize);


};

#endif
