/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: GroupObjectDialog.h,v 1.16 2006/08/18 04:10:33 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __GROUPOBJECTDIALOG_H_
#define __GROUPOBJECTDIALOG_H_

#include "config.h"
#include <groupobjectdialog_q.h>

#include <qtooltip.h>
#include <vector>

#include "fwbuilder/FWObject.h"
#include "ObjectListView.h"
#include "ObjectIconView.h"

class ObjectIconViewItem;
class ObjectListViewItem;

class IconViewObjToolTip : public QToolTip {

    QIconView *view;
 public:
    IconViewObjToolTip(QIconView *w);
    virtual ~IconViewObjToolTip() {}
    virtual void maybeTip(const QPoint &p);
};

class ListViewObjToolTip : public QToolTip {

    QListView *view;
 public:
    ListViewObjToolTip(QListView *w);
    virtual ~ListViewObjToolTip() {}
    virtual void maybeTip(const QPoint &p);
};

class GroupObjectDialog : public GroupObjectDialog_q
{
    Q_OBJECT

    libfwbuilder::FWObject *obj;

    ObjectIconView         *iconView;
    ObjectListView         *listView;

    std::vector<libfwbuilder::FWObject*> selectedObjects;

    libfwbuilder::FWObject *selectedObject;
    std::map<std::string, ObjectIconViewItem*> allIconViewItems;
    std::map<std::string, ObjectListViewItem*> allListViewItems;

    bool init;

    void addIcon(libfwbuilder::FWObject *o);
    void addIcon(libfwbuilder::FWObject *o, bool ref);

    void insertObject(libfwbuilder::FWObject *o);

    void setupPopupMenu(const QPoint&);

 public:
    GroupObjectDialog(QWidget *parent);

    enum viewType { Icon, List };

 public slots:
    virtual void changed();
    virtual void libChanged();
    virtual void applyChanges();
    virtual void discardChanges();
    virtual void loadFWObject(libfwbuilder::FWObject *obj);
    virtual void validate(bool*);
    virtual void isChanged(bool*);
    virtual void switchToIconView();
    virtual void switchToListView();
    virtual void openObject();
    virtual void openObject(QIconViewItem *itm);
    virtual void openObject(QListViewItem *itm);
    virtual void dropped(QDropEvent *ev);
    virtual void iconContextMenu(QIconViewItem*,const QPoint&);
    virtual void listContextMenu(QListViewItem*,const QPoint&,int);
    virtual void closeEvent(QCloseEvent *e);
    
    void copyObj();
    void cutObj();
    void pasteObj();
    void deleteObj();

    void iconViewCurrentChanged(QIconViewItem *itm);
    void listViewCurrentChanged(QListViewItem *itm);
    
    void iconViewSelectionChanged();
    void listViewSelectionChanged();
    
    void selectObject(libfwbuilder::FWObject *o);

 signals:
/**
 * This signal is emitted from closeEvent, ObjectEditor connects
 * to this signal to make checks before the object editor can be closed
 * and to store its position on the screen
 */
    void close_sign(QCloseEvent *e);
    void changed_sign();
    
 private:

    static enum viewType vt;

 public:

    
};

#endif // GROUPOBJECTDIALOG_H
