/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: ICMPServiceDialog.cpp,v 1.26 2007/04/14 00:18:43 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"

#include "FWBTree.h"
#include "ICMPServiceDialog.h"
#include "ObjectManipulator.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/ICMPService.h"

#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>

#include <iostream>

using namespace std;
using namespace libfwbuilder;

void ICMPServiceDialog::loadFWObject(FWObject *o)
{
    obj=o;
    ICMPService *s = dynamic_cast<ICMPService*>(obj);
    assert(s!=NULL);

    init=true;

    fillLibraries(libs,obj);

    obj_name->setText( QString::fromUtf8(s->getName().c_str()) );
    icmpType->setValue( s->getInt("type") );
    icmpCode->setValue( s->getInt("code") );
    comment->setText( QString::fromUtf8(s->getComment().c_str()) );

    //apply->setEnabled( false );

    obj_name->setEnabled(!o->isReadOnly());
    setDisabledPalette(obj_name);

    libs->setEnabled(!o->isReadOnly());
    setDisabledPalette(libs);

    icmpType->setEnabled(!o->isReadOnly());
    setDisabledPalette(icmpType);

    icmpCode->setEnabled(!o->isReadOnly());
    setDisabledPalette(icmpCode);

    comment->setReadOnly(o->isReadOnly());
    setDisabledPalette(comment);

    init=false;
}
    
void ICMPServiceDialog::changed()
{
    //apply->setEnabled( true );
    emit changed_sign();
}

void ICMPServiceDialog::validate(bool *res)
{
    *res=true;
    if (!isTreeReadWrite(this,obj)) { *res=false; return; }
    if (!validateName(this,obj,obj_name->text())) { *res=false; return; }
}

void ICMPServiceDialog::isChanged(bool *res)
{
    //*res=(!init && apply->isEnabled());
}

void ICMPServiceDialog::libChanged()
{
    changed();
}

void ICMPServiceDialog::applyChanges()
{
    string oldname=obj->getName();
    obj->setName( string(obj_name->text().utf8()) );
    obj->setComment( string(comment->text().utf8()) );

    obj->setInt("type", icmpType->value() );
    obj->setInt("code", icmpCode->value() );

    om->updateObjName(obj,QString::fromUtf8(oldname.c_str()));

    init=true;

/* move to another lib if we have to */
    if (! FWBTree::isSystem(obj) && libs->currentText() != QString(obj->getLibrary()->getName().c_str()))
        om->moveObject(libs->currentText(), obj);

    init=false;

    //apply->setEnabled( false );
    om->updateLastModifiedTimestampForAllFirewalls(obj);
}

void ICMPServiceDialog::discardChanges()
{
    loadFWObject(obj);
}


/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void ICMPServiceDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}


