/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: inplaceComboBox.cpp,v 1.2 2006/10/22 04:39:36 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "inplaceComboBox.h"

#include <qvariant.h>
#include <qpixmapcache.h>
#include "qcombobox.h"
#include "qlayout.h"

inplaceComboBox::inplaceComboBox( QWidget* parent, const char* name, WFlags fl )
    : QFrame( parent, name, fl )
{
    if ( !name )  setName( "inplaceComboBox" );
//    setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    setFocusPolicy( QWidget::StrongFocus );
    qLayout = new QGridLayout( this, 1, 1, 0, 0, "qLayout"); 

    layout1 = new QVBoxLayout( 0, 0, 0, "layout1"); 

    comboBox = new QComboBox( FALSE, this, "comboBox" );
    comboBox->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, 0, 0, comboBox->sizePolicy().hasHeightForWidth() ) );
    comboBox->setFocusPolicy( QComboBox::WheelFocus );
    layout1->addWidget( comboBox );
    QSpacerItem* spacer = new QSpacerItem( 20, 40, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout1->addItem( spacer );

    qLayout->addLayout( layout1, 0, 0 );
    clearWState( WState_Polished );
}

void inplaceComboBox::insertItem( const QPixmap &pm, const QString &txt, int index)
{
    comboBox->insertItem(pm,txt,index);
    comboBox->setFixedHeight(pm.height()+4);
}

int  inplaceComboBox::currentItem() { return comboBox->currentItem(); }

void inplaceComboBox::setCurrentItem( int index ) { comboBox->setCurrentItem(index); }
