/**************************************
 * DO NOT EDIT THIS FILE              *
 * File autogenerated from a template *
 * DO NOT EDIT THIS FILE              *
 **************************************/
/*	fut.h */
/*
 * PM2: Parallel Multithreaded Machine
 * Copyright (C) 2001 "the PM2 team" (see AUTHORS file)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */


#ifndef __FUT_H__
#define __FUT_H__

#ifdef __cplusplus
extern "C"
{
#endif

/*	fut = Fast User Tracing */

#ifdef MARCEL
#  include "sys/marcel_flags.h"
#endif
#include <stdarg.h>
#include <stdint.h>
#include <string.h>

#include "fxt.h"

/*	Macros for use from within the kernel */
#ifndef __ASSEMBLY__
extern volatile unsigned int fut_active;
#endif

#if defined(CONFIG_FUT)

/***********************************************/
/* Les macros 
 *
 * FUT_CODE(code, nb_param) : calcul du code avec dcalage
 *   ncessaire pour :
 *     FUT_RAW_PROBEx(...)
 *     FUT_*_PROBE(...)    [avec * dans 'RAW' 'DO' 'FULL' et ''] 
 *   mais pas pour :
 *     FUT_*_PROBEx(...)   [avec * dans 'DO' 'FULL' et ''] 
 *
 * FUT_SIZE(nb_param) : calcul de la taille de la structure
 *
 * FUT_RAW_PROBEx(fut_code, ...) : fut_code est dj dcal
 * FUT_DO_PROBEx(code, ...) : code n'est pas encode dcal
 * FUT_FULL_PROBEx(keymask, code, ...) : enregistre si le keymask est actif
 * FUT_PROBEx(keymask, code, ...) : idem, sauf avec CONFIG_FUT_TIME_ONLY 
 *                              (dans ce cas, on enregistre aucun paramtre)
 *
 * FUT_*_PROBE([keymask,] fut_code, ...) : nombre variable d'arguments
 *                                         fut_code est dj dcal
 */


/**************************************
 * DO NOT EDIT THIS FILE              *
 * File autogenerated from a template *
 * DO NOT EDIT THIS FILE              *
 **************************************/


#define FUT_CODE(CODE, n) ((((unsigned long)(CODE))<<8) | ((n) + 1))
#define FUT_SIZE(n) (sizeof(fxt_trace_user_raw_t)+(n)*sizeof(long))
#define FUT_STRLEN(s) ((strlen(s)+sizeof(long)-1)/sizeof(long))

#define FUT_NEEDS_COMMIT

#define FUT_RAW_ALWAYS_PROBE0(CODE) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(0)); \
						\
		fut_commitstampedbuffer(FUT_SIZE(0)); \
	} while (0)

#define FUT_RAW_PROBE0(CODE) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE0(CODE); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE0STR(CODE,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 0) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 0 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
						\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE0STR(CODE,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE0STR(CODE,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE1(CODE,P1) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(1)); \
		*(__args++)=(unsigned long)(P1);				\
		fut_commitstampedbuffer(FUT_SIZE(1)); \
	} while (0)

#define FUT_RAW_PROBE1(CODE,P1) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE1(CODE,P1); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE1STR(CODE,P1,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 1) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 1 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE1STR(CODE,P1,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE1STR(CODE,P1,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE2(CODE,P1,P2) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(2)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);				\
		fut_commitstampedbuffer(FUT_SIZE(2)); \
	} while (0)

#define FUT_RAW_PROBE2(CODE,P1,P2) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE2(CODE,P1,P2); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE2STR(CODE,P1,P2,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 2) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 2 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE2STR(CODE,P1,P2,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE2STR(CODE,P1,P2,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE3(CODE,P1,P2,P3) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(3)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);				\
		fut_commitstampedbuffer(FUT_SIZE(3)); \
	} while (0)

#define FUT_RAW_PROBE3(CODE,P1,P2,P3) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE3(CODE,P1,P2,P3); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE3STR(CODE,P1,P2,P3,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 3) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 3 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE3STR(CODE,P1,P2,P3,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE3STR(CODE,P1,P2,P3,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE4(CODE,P1,P2,P3,P4) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(4)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);				\
		fut_commitstampedbuffer(FUT_SIZE(4)); \
	} while (0)

#define FUT_RAW_PROBE4(CODE,P1,P2,P3,P4) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE4(CODE,P1,P2,P3,P4); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE4STR(CODE,P1,P2,P3,P4,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 4) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 4 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE4STR(CODE,P1,P2,P3,P4,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE4STR(CODE,P1,P2,P3,P4,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE5(CODE,P1,P2,P3,P4,P5) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(5)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);				\
		fut_commitstampedbuffer(FUT_SIZE(5)); \
	} while (0)

#define FUT_RAW_PROBE5(CODE,P1,P2,P3,P4,P5) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE5(CODE,P1,P2,P3,P4,P5); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE5STR(CODE,P1,P2,P3,P4,P5,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 5) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 5 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE5STR(CODE,P1,P2,P3,P4,P5,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE5STR(CODE,P1,P2,P3,P4,P5,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE6(CODE,P1,P2,P3,P4,P5,P6) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(6)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);				\
		fut_commitstampedbuffer(FUT_SIZE(6)); \
	} while (0)

#define FUT_RAW_PROBE6(CODE,P1,P2,P3,P4,P5,P6) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE6(CODE,P1,P2,P3,P4,P5,P6); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE6STR(CODE,P1,P2,P3,P4,P5,P6,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 6) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 6 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE6STR(CODE,P1,P2,P3,P4,P5,P6,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE6STR(CODE,P1,P2,P3,P4,P5,P6,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE7(CODE,P1,P2,P3,P4,P5,P6,P7) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(7)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);				\
		fut_commitstampedbuffer(FUT_SIZE(7)); \
	} while (0)

#define FUT_RAW_PROBE7(CODE,P1,P2,P3,P4,P5,P6,P7) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE7(CODE,P1,P2,P3,P4,P5,P6,P7); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE7STR(CODE,P1,P2,P3,P4,P5,P6,P7,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 7) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 7 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE7STR(CODE,P1,P2,P3,P4,P5,P6,P7,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE7STR(CODE,P1,P2,P3,P4,P5,P6,P7,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE8(CODE,P1,P2,P3,P4,P5,P6,P7,P8) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(8)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);				\
		fut_commitstampedbuffer(FUT_SIZE(8)); \
	} while (0)

#define FUT_RAW_PROBE8(CODE,P1,P2,P3,P4,P5,P6,P7,P8) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE8(CODE,P1,P2,P3,P4,P5,P6,P7,P8); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE8STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 8) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 8 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE8STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE8STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE9(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(9)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);				\
		fut_commitstampedbuffer(FUT_SIZE(9)); \
	} while (0)

#define FUT_RAW_PROBE9(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE9(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE9STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 9) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 9 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE9STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE9STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE10(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(10)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);				\
		fut_commitstampedbuffer(FUT_SIZE(10)); \
	} while (0)

#define FUT_RAW_PROBE10(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE10(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE10STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 10) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 10 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE10STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE10STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE11(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(11)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);				\
		fut_commitstampedbuffer(FUT_SIZE(11)); \
	} while (0)

#define FUT_RAW_PROBE11(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE11(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE11STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 11) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 11 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE11STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE11STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE12(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(12)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);				\
		fut_commitstampedbuffer(FUT_SIZE(12)); \
	} while (0)

#define FUT_RAW_PROBE12(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE12(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE12STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 12) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 12 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE12STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE12STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE13(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(13)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);				\
		fut_commitstampedbuffer(FUT_SIZE(13)); \
	} while (0)

#define FUT_RAW_PROBE13(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE13(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE13STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 13) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 13 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE13STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE13STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE14(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(14)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);				\
		fut_commitstampedbuffer(FUT_SIZE(14)); \
	} while (0)

#define FUT_RAW_PROBE14(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE14(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE14STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 14) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 14 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE14STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE14STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE15(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(15)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);				\
		fut_commitstampedbuffer(FUT_SIZE(15)); \
	} while (0)

#define FUT_RAW_PROBE15(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE15(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE15STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 15) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 15 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE15STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE15STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE16(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(16)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);				\
		fut_commitstampedbuffer(FUT_SIZE(16)); \
	} while (0)

#define FUT_RAW_PROBE16(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE16(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE16STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 16) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 16 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE16STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE16STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE17(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(17)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);				\
		fut_commitstampedbuffer(FUT_SIZE(17)); \
	} while (0)

#define FUT_RAW_PROBE17(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE17(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE17STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 17) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 17 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE17STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE17STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE18(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(18)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);				\
		fut_commitstampedbuffer(FUT_SIZE(18)); \
	} while (0)

#define FUT_RAW_PROBE18(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE18(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE18STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 18) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 18 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE18STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE18STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE19(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(19)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);				\
		fut_commitstampedbuffer(FUT_SIZE(19)); \
	} while (0)

#define FUT_RAW_PROBE19(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE19(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE19STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 19) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 19 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE19STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE19STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE20(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(20)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);				\
		fut_commitstampedbuffer(FUT_SIZE(20)); \
	} while (0)

#define FUT_RAW_PROBE20(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE20(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE20STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 20) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 20 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE20STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE20STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE21(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(21)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);				\
		fut_commitstampedbuffer(FUT_SIZE(21)); \
	} while (0)

#define FUT_RAW_PROBE21(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE21(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE21STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 21) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 21 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE21STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE21STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE22(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(22)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);				\
		fut_commitstampedbuffer(FUT_SIZE(22)); \
	} while (0)

#define FUT_RAW_PROBE22(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE22(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE22STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 22) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 22 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE22STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE22STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE23(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(23)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);				\
		fut_commitstampedbuffer(FUT_SIZE(23)); \
	} while (0)

#define FUT_RAW_PROBE23(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE23(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE23STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 23) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 23 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE23STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE23STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE24(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(24)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);				\
		fut_commitstampedbuffer(FUT_SIZE(24)); \
	} while (0)

#define FUT_RAW_PROBE24(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE24(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE24STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 24) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 24 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE24STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE24STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE25(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(25)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);				\
		fut_commitstampedbuffer(FUT_SIZE(25)); \
	} while (0)

#define FUT_RAW_PROBE25(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE25(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE25STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 25) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 25 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE25STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE25STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE26(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(26)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);*(__args++)=(unsigned long)(P26);				\
		fut_commitstampedbuffer(FUT_SIZE(26)); \
	} while (0)

#define FUT_RAW_PROBE26(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE26(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE26STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 26) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 26 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);*(__args++)=(unsigned long)(P26);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE26STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE26STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE27(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(27)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);*(__args++)=(unsigned long)(P26);*(__args++)=(unsigned long)(P27);				\
		fut_commitstampedbuffer(FUT_SIZE(27)); \
	} while (0)

#define FUT_RAW_PROBE27(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE27(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE27STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 27) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 27 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);*(__args++)=(unsigned long)(P26);*(__args++)=(unsigned long)(P27);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE27STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE27STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE28(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(28)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);*(__args++)=(unsigned long)(P26);*(__args++)=(unsigned long)(P27);*(__args++)=(unsigned long)(P28);				\
		fut_commitstampedbuffer(FUT_SIZE(28)); \
	} while (0)

#define FUT_RAW_PROBE28(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE28(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE28STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 28) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 28 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);*(__args++)=(unsigned long)(P26);*(__args++)=(unsigned long)(P27);*(__args++)=(unsigned long)(P28);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE28STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE28STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE29(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(29)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);*(__args++)=(unsigned long)(P26);*(__args++)=(unsigned long)(P27);*(__args++)=(unsigned long)(P28);*(__args++)=(unsigned long)(P29);				\
		fut_commitstampedbuffer(FUT_SIZE(29)); \
	} while (0)

#define FUT_RAW_PROBE29(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE29(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE29STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 29) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 29 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);*(__args++)=(unsigned long)(P26);*(__args++)=(unsigned long)(P27);*(__args++)=(unsigned long)(P28);*(__args++)=(unsigned long)(P29);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE29STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE29STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE30(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(30)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);*(__args++)=(unsigned long)(P26);*(__args++)=(unsigned long)(P27);*(__args++)=(unsigned long)(P28);*(__args++)=(unsigned long)(P29);*(__args++)=(unsigned long)(P30);				\
		fut_commitstampedbuffer(FUT_SIZE(30)); \
	} while (0)

#define FUT_RAW_PROBE30(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE30(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE30STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 30) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 30 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);*(__args++)=(unsigned long)(P26);*(__args++)=(unsigned long)(P27);*(__args++)=(unsigned long)(P28);*(__args++)=(unsigned long)(P29);*(__args++)=(unsigned long)(P30);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE30STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE30STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE31(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31) do {	\
		unsigned long *__args __attribute__((unused))=	\
			fut_getstampedbuffer(CODE,		\
					     FUT_SIZE(31)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);*(__args++)=(unsigned long)(P26);*(__args++)=(unsigned long)(P27);*(__args++)=(unsigned long)(P28);*(__args++)=(unsigned long)(P29);*(__args++)=(unsigned long)(P30);*(__args++)=(unsigned long)(P31);				\
		fut_commitstampedbuffer(FUT_SIZE(31)); \
	} while (0)

#define FUT_RAW_PROBE31(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE31(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBE31STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31,S) do {		\
		const char *__s = (S);				\
		size_t __slen = strlen(__s);			\
		size_t __max = (FXT_MAX_PARAMS - 31) * sizeof(unsigned long); \
		size_t __len = __slen > __max ? __max : __slen;	\
		unsigned __nbargs_str = (__len + sizeof(unsigned long) - 1) / sizeof (unsigned long); \
		unsigned __nbargs = 31 + __nbargs_str;	\
		unsigned long *__args =				\
			fut_getstampedbuffer(FUT_CODE(CODE, __nbargs), FUT_SIZE(__nbargs)); \
		*(__args++)=(unsigned long)(P1);*(__args++)=(unsigned long)(P2);*(__args++)=(unsigned long)(P3);*(__args++)=(unsigned long)(P4);*(__args++)=(unsigned long)(P5);*(__args++)=(unsigned long)(P6);*(__args++)=(unsigned long)(P7);*(__args++)=(unsigned long)(P8);*(__args++)=(unsigned long)(P9);*(__args++)=(unsigned long)(P10);*(__args++)=(unsigned long)(P11);*(__args++)=(unsigned long)(P12);*(__args++)=(unsigned long)(P13);*(__args++)=(unsigned long)(P14);*(__args++)=(unsigned long)(P15);*(__args++)=(unsigned long)(P16);*(__args++)=(unsigned long)(P17);*(__args++)=(unsigned long)(P18);*(__args++)=(unsigned long)(P19);*(__args++)=(unsigned long)(P20);*(__args++)=(unsigned long)(P21);*(__args++)=(unsigned long)(P22);*(__args++)=(unsigned long)(P23);*(__args++)=(unsigned long)(P24);*(__args++)=(unsigned long)(P25);*(__args++)=(unsigned long)(P26);*(__args++)=(unsigned long)(P27);*(__args++)=(unsigned long)(P28);*(__args++)=(unsigned long)(P29);*(__args++)=(unsigned long)(P30);*(__args++)=(unsigned long)(P31);				\
		memcpy(__args, __s, __len);				\
		memset((char*)__args+__len, 0, __nbargs_str*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__nbargs)); \
	} while (0)

#define FUT_RAW_PROBE31STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31,S) do {		\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBE31STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31,S); \
		}							\
	} while (0)

#define FUT_RAW_ALWAYS_PROBESTR(CODE,S) do {				\
		const char *__s = (S);				\
		size_t __len = strlen(__s);			\
		size_t __n = FUT_STRLEN(__s);			\
		unsigned long *__args __attribute__((unused)) =	\
			fut_getstampedbuffer(CODE, FUT_SIZE(__n)); \
		memcpy(__args, __s, __len);			\
		memset((char*)__args+__len, 0, __n*sizeof(long)-__len);	\
		fut_commitstampedbuffer(FUT_SIZE(__n)); \
	} while (0)

#define FUT_RAW_PROBESTR(CODE,S) do {					\
		if(fut_active) {					\
			FUT_RAW_ALWAYS_PROBESTR(CODE, S);		\
		}							\
	} while (0)

#define FUT_DO_ALWAYS_PROBE0(CODE) do { \
        FUT_RAW_ALWAYS_PROBE0(FUT_CODE(CODE, 0)); \
} while (0)
#define FUT_DO_PROBE0(CODE) do { \
        FUT_RAW_PROBE0(FUT_CODE(CODE, 0)); \
} while (0)

#define FUT_DO_ALWAYS_PROBE0STR(CODE,S) do { \
        FUT_RAW_ALWAYS_PROBE0STR(CODE,S); \
} while (0)
#define FUT_DO_PROBE0STR(CODE,S) do { \
        FUT_RAW_PROBE0STR(CODE,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE1(CODE,P1) do { \
        FUT_RAW_ALWAYS_PROBE1(FUT_CODE(CODE, 1),P1); \
} while (0)
#define FUT_DO_PROBE1(CODE,P1) do { \
        FUT_RAW_PROBE1(FUT_CODE(CODE, 1),P1); \
} while (0)

#define FUT_DO_ALWAYS_PROBE1STR(CODE,P1,S) do { \
        FUT_RAW_ALWAYS_PROBE1STR(CODE,P1,S); \
} while (0)
#define FUT_DO_PROBE1STR(CODE,P1,S) do { \
        FUT_RAW_PROBE1STR(CODE,P1,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE2(CODE,P1,P2) do { \
        FUT_RAW_ALWAYS_PROBE2(FUT_CODE(CODE, 2),P1,P2); \
} while (0)
#define FUT_DO_PROBE2(CODE,P1,P2) do { \
        FUT_RAW_PROBE2(FUT_CODE(CODE, 2),P1,P2); \
} while (0)

#define FUT_DO_ALWAYS_PROBE2STR(CODE,P1,P2,S) do { \
        FUT_RAW_ALWAYS_PROBE2STR(CODE,P1,P2,S); \
} while (0)
#define FUT_DO_PROBE2STR(CODE,P1,P2,S) do { \
        FUT_RAW_PROBE2STR(CODE,P1,P2,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE3(CODE,P1,P2,P3) do { \
        FUT_RAW_ALWAYS_PROBE3(FUT_CODE(CODE, 3),P1,P2,P3); \
} while (0)
#define FUT_DO_PROBE3(CODE,P1,P2,P3) do { \
        FUT_RAW_PROBE3(FUT_CODE(CODE, 3),P1,P2,P3); \
} while (0)

#define FUT_DO_ALWAYS_PROBE3STR(CODE,P1,P2,P3,S) do { \
        FUT_RAW_ALWAYS_PROBE3STR(CODE,P1,P2,P3,S); \
} while (0)
#define FUT_DO_PROBE3STR(CODE,P1,P2,P3,S) do { \
        FUT_RAW_PROBE3STR(CODE,P1,P2,P3,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE4(CODE,P1,P2,P3,P4) do { \
        FUT_RAW_ALWAYS_PROBE4(FUT_CODE(CODE, 4),P1,P2,P3,P4); \
} while (0)
#define FUT_DO_PROBE4(CODE,P1,P2,P3,P4) do { \
        FUT_RAW_PROBE4(FUT_CODE(CODE, 4),P1,P2,P3,P4); \
} while (0)

#define FUT_DO_ALWAYS_PROBE4STR(CODE,P1,P2,P3,P4,S) do { \
        FUT_RAW_ALWAYS_PROBE4STR(CODE,P1,P2,P3,P4,S); \
} while (0)
#define FUT_DO_PROBE4STR(CODE,P1,P2,P3,P4,S) do { \
        FUT_RAW_PROBE4STR(CODE,P1,P2,P3,P4,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE5(CODE,P1,P2,P3,P4,P5) do { \
        FUT_RAW_ALWAYS_PROBE5(FUT_CODE(CODE, 5),P1,P2,P3,P4,P5); \
} while (0)
#define FUT_DO_PROBE5(CODE,P1,P2,P3,P4,P5) do { \
        FUT_RAW_PROBE5(FUT_CODE(CODE, 5),P1,P2,P3,P4,P5); \
} while (0)

#define FUT_DO_ALWAYS_PROBE5STR(CODE,P1,P2,P3,P4,P5,S) do { \
        FUT_RAW_ALWAYS_PROBE5STR(CODE,P1,P2,P3,P4,P5,S); \
} while (0)
#define FUT_DO_PROBE5STR(CODE,P1,P2,P3,P4,P5,S) do { \
        FUT_RAW_PROBE5STR(CODE,P1,P2,P3,P4,P5,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE6(CODE,P1,P2,P3,P4,P5,P6) do { \
        FUT_RAW_ALWAYS_PROBE6(FUT_CODE(CODE, 6),P1,P2,P3,P4,P5,P6); \
} while (0)
#define FUT_DO_PROBE6(CODE,P1,P2,P3,P4,P5,P6) do { \
        FUT_RAW_PROBE6(FUT_CODE(CODE, 6),P1,P2,P3,P4,P5,P6); \
} while (0)

#define FUT_DO_ALWAYS_PROBE6STR(CODE,P1,P2,P3,P4,P5,P6,S) do { \
        FUT_RAW_ALWAYS_PROBE6STR(CODE,P1,P2,P3,P4,P5,P6,S); \
} while (0)
#define FUT_DO_PROBE6STR(CODE,P1,P2,P3,P4,P5,P6,S) do { \
        FUT_RAW_PROBE6STR(CODE,P1,P2,P3,P4,P5,P6,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE7(CODE,P1,P2,P3,P4,P5,P6,P7) do { \
        FUT_RAW_ALWAYS_PROBE7(FUT_CODE(CODE, 7),P1,P2,P3,P4,P5,P6,P7); \
} while (0)
#define FUT_DO_PROBE7(CODE,P1,P2,P3,P4,P5,P6,P7) do { \
        FUT_RAW_PROBE7(FUT_CODE(CODE, 7),P1,P2,P3,P4,P5,P6,P7); \
} while (0)

#define FUT_DO_ALWAYS_PROBE7STR(CODE,P1,P2,P3,P4,P5,P6,P7,S) do { \
        FUT_RAW_ALWAYS_PROBE7STR(CODE,P1,P2,P3,P4,P5,P6,P7,S); \
} while (0)
#define FUT_DO_PROBE7STR(CODE,P1,P2,P3,P4,P5,P6,P7,S) do { \
        FUT_RAW_PROBE7STR(CODE,P1,P2,P3,P4,P5,P6,P7,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE8(CODE,P1,P2,P3,P4,P5,P6,P7,P8) do { \
        FUT_RAW_ALWAYS_PROBE8(FUT_CODE(CODE, 8),P1,P2,P3,P4,P5,P6,P7,P8); \
} while (0)
#define FUT_DO_PROBE8(CODE,P1,P2,P3,P4,P5,P6,P7,P8) do { \
        FUT_RAW_PROBE8(FUT_CODE(CODE, 8),P1,P2,P3,P4,P5,P6,P7,P8); \
} while (0)

#define FUT_DO_ALWAYS_PROBE8STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,S) do { \
        FUT_RAW_ALWAYS_PROBE8STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,S); \
} while (0)
#define FUT_DO_PROBE8STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,S) do { \
        FUT_RAW_PROBE8STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE9(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9) do { \
        FUT_RAW_ALWAYS_PROBE9(FUT_CODE(CODE, 9),P1,P2,P3,P4,P5,P6,P7,P8,P9); \
} while (0)
#define FUT_DO_PROBE9(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9) do { \
        FUT_RAW_PROBE9(FUT_CODE(CODE, 9),P1,P2,P3,P4,P5,P6,P7,P8,P9); \
} while (0)

#define FUT_DO_ALWAYS_PROBE9STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,S) do { \
        FUT_RAW_ALWAYS_PROBE9STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,S); \
} while (0)
#define FUT_DO_PROBE9STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,S) do { \
        FUT_RAW_PROBE9STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE10(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10) do { \
        FUT_RAW_ALWAYS_PROBE10(FUT_CODE(CODE, 10),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10); \
} while (0)
#define FUT_DO_PROBE10(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10) do { \
        FUT_RAW_PROBE10(FUT_CODE(CODE, 10),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10); \
} while (0)

#define FUT_DO_ALWAYS_PROBE10STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,S) do { \
        FUT_RAW_ALWAYS_PROBE10STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,S); \
} while (0)
#define FUT_DO_PROBE10STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,S) do { \
        FUT_RAW_PROBE10STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE11(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11) do { \
        FUT_RAW_ALWAYS_PROBE11(FUT_CODE(CODE, 11),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11); \
} while (0)
#define FUT_DO_PROBE11(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11) do { \
        FUT_RAW_PROBE11(FUT_CODE(CODE, 11),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11); \
} while (0)

#define FUT_DO_ALWAYS_PROBE11STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,S) do { \
        FUT_RAW_ALWAYS_PROBE11STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,S); \
} while (0)
#define FUT_DO_PROBE11STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,S) do { \
        FUT_RAW_PROBE11STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE12(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12) do { \
        FUT_RAW_ALWAYS_PROBE12(FUT_CODE(CODE, 12),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12); \
} while (0)
#define FUT_DO_PROBE12(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12) do { \
        FUT_RAW_PROBE12(FUT_CODE(CODE, 12),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12); \
} while (0)

#define FUT_DO_ALWAYS_PROBE12STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,S) do { \
        FUT_RAW_ALWAYS_PROBE12STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,S); \
} while (0)
#define FUT_DO_PROBE12STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,S) do { \
        FUT_RAW_PROBE12STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE13(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13) do { \
        FUT_RAW_ALWAYS_PROBE13(FUT_CODE(CODE, 13),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13); \
} while (0)
#define FUT_DO_PROBE13(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13) do { \
        FUT_RAW_PROBE13(FUT_CODE(CODE, 13),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13); \
} while (0)

#define FUT_DO_ALWAYS_PROBE13STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,S) do { \
        FUT_RAW_ALWAYS_PROBE13STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,S); \
} while (0)
#define FUT_DO_PROBE13STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,S) do { \
        FUT_RAW_PROBE13STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE14(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14) do { \
        FUT_RAW_ALWAYS_PROBE14(FUT_CODE(CODE, 14),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14); \
} while (0)
#define FUT_DO_PROBE14(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14) do { \
        FUT_RAW_PROBE14(FUT_CODE(CODE, 14),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14); \
} while (0)

#define FUT_DO_ALWAYS_PROBE14STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,S) do { \
        FUT_RAW_ALWAYS_PROBE14STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,S); \
} while (0)
#define FUT_DO_PROBE14STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,S) do { \
        FUT_RAW_PROBE14STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE15(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15) do { \
        FUT_RAW_ALWAYS_PROBE15(FUT_CODE(CODE, 15),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15); \
} while (0)
#define FUT_DO_PROBE15(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15) do { \
        FUT_RAW_PROBE15(FUT_CODE(CODE, 15),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15); \
} while (0)

#define FUT_DO_ALWAYS_PROBE15STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,S) do { \
        FUT_RAW_ALWAYS_PROBE15STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,S); \
} while (0)
#define FUT_DO_PROBE15STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,S) do { \
        FUT_RAW_PROBE15STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE16(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16) do { \
        FUT_RAW_ALWAYS_PROBE16(FUT_CODE(CODE, 16),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16); \
} while (0)
#define FUT_DO_PROBE16(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16) do { \
        FUT_RAW_PROBE16(FUT_CODE(CODE, 16),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16); \
} while (0)

#define FUT_DO_ALWAYS_PROBE16STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,S) do { \
        FUT_RAW_ALWAYS_PROBE16STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,S); \
} while (0)
#define FUT_DO_PROBE16STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,S) do { \
        FUT_RAW_PROBE16STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE17(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17) do { \
        FUT_RAW_ALWAYS_PROBE17(FUT_CODE(CODE, 17),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17); \
} while (0)
#define FUT_DO_PROBE17(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17) do { \
        FUT_RAW_PROBE17(FUT_CODE(CODE, 17),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17); \
} while (0)

#define FUT_DO_ALWAYS_PROBE17STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,S) do { \
        FUT_RAW_ALWAYS_PROBE17STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,S); \
} while (0)
#define FUT_DO_PROBE17STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,S) do { \
        FUT_RAW_PROBE17STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE18(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18) do { \
        FUT_RAW_ALWAYS_PROBE18(FUT_CODE(CODE, 18),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18); \
} while (0)
#define FUT_DO_PROBE18(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18) do { \
        FUT_RAW_PROBE18(FUT_CODE(CODE, 18),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18); \
} while (0)

#define FUT_DO_ALWAYS_PROBE18STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,S) do { \
        FUT_RAW_ALWAYS_PROBE18STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,S); \
} while (0)
#define FUT_DO_PROBE18STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,S) do { \
        FUT_RAW_PROBE18STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE19(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19) do { \
        FUT_RAW_ALWAYS_PROBE19(FUT_CODE(CODE, 19),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19); \
} while (0)
#define FUT_DO_PROBE19(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19) do { \
        FUT_RAW_PROBE19(FUT_CODE(CODE, 19),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19); \
} while (0)

#define FUT_DO_ALWAYS_PROBE19STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,S) do { \
        FUT_RAW_ALWAYS_PROBE19STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,S); \
} while (0)
#define FUT_DO_PROBE19STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,S) do { \
        FUT_RAW_PROBE19STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE20(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20) do { \
        FUT_RAW_ALWAYS_PROBE20(FUT_CODE(CODE, 20),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20); \
} while (0)
#define FUT_DO_PROBE20(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20) do { \
        FUT_RAW_PROBE20(FUT_CODE(CODE, 20),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20); \
} while (0)

#define FUT_DO_ALWAYS_PROBE20STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,S) do { \
        FUT_RAW_ALWAYS_PROBE20STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,S); \
} while (0)
#define FUT_DO_PROBE20STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,S) do { \
        FUT_RAW_PROBE20STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE21(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21) do { \
        FUT_RAW_ALWAYS_PROBE21(FUT_CODE(CODE, 21),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21); \
} while (0)
#define FUT_DO_PROBE21(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21) do { \
        FUT_RAW_PROBE21(FUT_CODE(CODE, 21),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21); \
} while (0)

#define FUT_DO_ALWAYS_PROBE21STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,S) do { \
        FUT_RAW_ALWAYS_PROBE21STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,S); \
} while (0)
#define FUT_DO_PROBE21STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,S) do { \
        FUT_RAW_PROBE21STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE22(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22) do { \
        FUT_RAW_ALWAYS_PROBE22(FUT_CODE(CODE, 22),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22); \
} while (0)
#define FUT_DO_PROBE22(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22) do { \
        FUT_RAW_PROBE22(FUT_CODE(CODE, 22),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22); \
} while (0)

#define FUT_DO_ALWAYS_PROBE22STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,S) do { \
        FUT_RAW_ALWAYS_PROBE22STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,S); \
} while (0)
#define FUT_DO_PROBE22STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,S) do { \
        FUT_RAW_PROBE22STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE23(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23) do { \
        FUT_RAW_ALWAYS_PROBE23(FUT_CODE(CODE, 23),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23); \
} while (0)
#define FUT_DO_PROBE23(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23) do { \
        FUT_RAW_PROBE23(FUT_CODE(CODE, 23),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23); \
} while (0)

#define FUT_DO_ALWAYS_PROBE23STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,S) do { \
        FUT_RAW_ALWAYS_PROBE23STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,S); \
} while (0)
#define FUT_DO_PROBE23STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,S) do { \
        FUT_RAW_PROBE23STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE24(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24) do { \
        FUT_RAW_ALWAYS_PROBE24(FUT_CODE(CODE, 24),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24); \
} while (0)
#define FUT_DO_PROBE24(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24) do { \
        FUT_RAW_PROBE24(FUT_CODE(CODE, 24),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24); \
} while (0)

#define FUT_DO_ALWAYS_PROBE24STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,S) do { \
        FUT_RAW_ALWAYS_PROBE24STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,S); \
} while (0)
#define FUT_DO_PROBE24STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,S) do { \
        FUT_RAW_PROBE24STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE25(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25) do { \
        FUT_RAW_ALWAYS_PROBE25(FUT_CODE(CODE, 25),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25); \
} while (0)
#define FUT_DO_PROBE25(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25) do { \
        FUT_RAW_PROBE25(FUT_CODE(CODE, 25),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25); \
} while (0)

#define FUT_DO_ALWAYS_PROBE25STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,S) do { \
        FUT_RAW_ALWAYS_PROBE25STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,S); \
} while (0)
#define FUT_DO_PROBE25STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,S) do { \
        FUT_RAW_PROBE25STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE26(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26) do { \
        FUT_RAW_ALWAYS_PROBE26(FUT_CODE(CODE, 26),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26); \
} while (0)
#define FUT_DO_PROBE26(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26) do { \
        FUT_RAW_PROBE26(FUT_CODE(CODE, 26),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26); \
} while (0)

#define FUT_DO_ALWAYS_PROBE26STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,S) do { \
        FUT_RAW_ALWAYS_PROBE26STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,S); \
} while (0)
#define FUT_DO_PROBE26STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,S) do { \
        FUT_RAW_PROBE26STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE27(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27) do { \
        FUT_RAW_ALWAYS_PROBE27(FUT_CODE(CODE, 27),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27); \
} while (0)
#define FUT_DO_PROBE27(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27) do { \
        FUT_RAW_PROBE27(FUT_CODE(CODE, 27),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27); \
} while (0)

#define FUT_DO_ALWAYS_PROBE27STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,S) do { \
        FUT_RAW_ALWAYS_PROBE27STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,S); \
} while (0)
#define FUT_DO_PROBE27STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,S) do { \
        FUT_RAW_PROBE27STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE28(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28) do { \
        FUT_RAW_ALWAYS_PROBE28(FUT_CODE(CODE, 28),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28); \
} while (0)
#define FUT_DO_PROBE28(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28) do { \
        FUT_RAW_PROBE28(FUT_CODE(CODE, 28),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28); \
} while (0)

#define FUT_DO_ALWAYS_PROBE28STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,S) do { \
        FUT_RAW_ALWAYS_PROBE28STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,S); \
} while (0)
#define FUT_DO_PROBE28STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,S) do { \
        FUT_RAW_PROBE28STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE29(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29) do { \
        FUT_RAW_ALWAYS_PROBE29(FUT_CODE(CODE, 29),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29); \
} while (0)
#define FUT_DO_PROBE29(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29) do { \
        FUT_RAW_PROBE29(FUT_CODE(CODE, 29),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29); \
} while (0)

#define FUT_DO_ALWAYS_PROBE29STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,S) do { \
        FUT_RAW_ALWAYS_PROBE29STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,S); \
} while (0)
#define FUT_DO_PROBE29STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,S) do { \
        FUT_RAW_PROBE29STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE30(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30) do { \
        FUT_RAW_ALWAYS_PROBE30(FUT_CODE(CODE, 30),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30); \
} while (0)
#define FUT_DO_PROBE30(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30) do { \
        FUT_RAW_PROBE30(FUT_CODE(CODE, 30),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30); \
} while (0)

#define FUT_DO_ALWAYS_PROBE30STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,S) do { \
        FUT_RAW_ALWAYS_PROBE30STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,S); \
} while (0)
#define FUT_DO_PROBE30STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,S) do { \
        FUT_RAW_PROBE30STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,S); \
} while (0)

#define FUT_DO_ALWAYS_PROBE31(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31) do { \
        FUT_RAW_ALWAYS_PROBE31(FUT_CODE(CODE, 31),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31); \
} while (0)
#define FUT_DO_PROBE31(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31) do { \
        FUT_RAW_PROBE31(FUT_CODE(CODE, 31),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31); \
} while (0)

#define FUT_DO_ALWAYS_PROBE31STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31,S) do { \
        FUT_RAW_ALWAYS_PROBE31STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31,S); \
} while (0)
#define FUT_DO_PROBE31STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31,S) do { \
        FUT_RAW_PROBE31STR(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31,S); \
} while (0)

#define FUT_DO_PROBESTR(CODE,S) do { \
	FUT_RAW_PROBESTR(FUT_CODE(CODE, FUT_STRLEN(__s)), S); \
} while (0)
#define FUT_DO_ALWAYS_PROBESTR(CODE,S) do { \
	FUT_RAW_ALWAYS_PROBESTR(FUT_CODE(CODE, FUT_STRLEN(__s)), S); \
} while (0)

/******************************************************/
/* NEVER call fut_getstampedbuffer or                 */
/* fut_commitstampedbuffer directly                   */
/* Interface can change without forewarning           */
/******************************************************/
extern unsigned long* fut_getstampedbuffer(unsigned long code, int size);
extern void fut_commitstampedbuffer(int size);

/* This can be overriden by the user */
extern uint64_t fut_getstamp(void);

inline static void
#ifndef __cplusplus
__attribute__((no_instrument_function))
#endif
FUT_RAW_PROBE(unsigned long code, ...) {
	if(fut_active) {		
	int nb=(code&0xff)-1, orig_nb = nb;
        unsigned long *args=fut_getstampedbuffer(code, FUT_SIZE(nb));
	va_list list;

	va_start(list, code);
	while (nb--) {
		*(args++)=va_arg(list, unsigned long);
	}
	va_end(list);
	fut_commitstampedbuffer(FUT_SIZE(orig_nb));
	} 
}
#define FUT_DO_PROBE(CODE, ...) do { \
        FUT_RAW_PROBE(CODE , ##__VA_ARGS__); \
} while (0)



#define FUT_FULL_PROBE0(KEYMASK,CODE) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE0(FUT_CODE(CODE, 0)); \
        } \
} while(0)

#define FUT_FULL_PROBE1(KEYMASK,CODE,P1) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE1(FUT_CODE(CODE, 1),P1); \
        } \
} while(0)

#define FUT_FULL_PROBE2(KEYMASK,CODE,P1,P2) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE2(FUT_CODE(CODE, 2),P1,P2); \
        } \
} while(0)

#define FUT_FULL_PROBE3(KEYMASK,CODE,P1,P2,P3) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE3(FUT_CODE(CODE, 3),P1,P2,P3); \
        } \
} while(0)

#define FUT_FULL_PROBE4(KEYMASK,CODE,P1,P2,P3,P4) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE4(FUT_CODE(CODE, 4),P1,P2,P3,P4); \
        } \
} while(0)

#define FUT_FULL_PROBE5(KEYMASK,CODE,P1,P2,P3,P4,P5) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE5(FUT_CODE(CODE, 5),P1,P2,P3,P4,P5); \
        } \
} while(0)

#define FUT_FULL_PROBE6(KEYMASK,CODE,P1,P2,P3,P4,P5,P6) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE6(FUT_CODE(CODE, 6),P1,P2,P3,P4,P5,P6); \
        } \
} while(0)

#define FUT_FULL_PROBE7(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE7(FUT_CODE(CODE, 7),P1,P2,P3,P4,P5,P6,P7); \
        } \
} while(0)

#define FUT_FULL_PROBE8(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE8(FUT_CODE(CODE, 8),P1,P2,P3,P4,P5,P6,P7,P8); \
        } \
} while(0)

#define FUT_FULL_PROBE9(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE9(FUT_CODE(CODE, 9),P1,P2,P3,P4,P5,P6,P7,P8,P9); \
        } \
} while(0)

#define FUT_FULL_PROBE10(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE10(FUT_CODE(CODE, 10),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10); \
        } \
} while(0)

#define FUT_FULL_PROBE11(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE11(FUT_CODE(CODE, 11),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11); \
        } \
} while(0)

#define FUT_FULL_PROBE12(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE12(FUT_CODE(CODE, 12),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12); \
        } \
} while(0)

#define FUT_FULL_PROBE13(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE13(FUT_CODE(CODE, 13),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13); \
        } \
} while(0)

#define FUT_FULL_PROBE14(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE14(FUT_CODE(CODE, 14),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14); \
        } \
} while(0)

#define FUT_FULL_PROBE15(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE15(FUT_CODE(CODE, 15),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15); \
        } \
} while(0)

#define FUT_FULL_PROBE16(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE16(FUT_CODE(CODE, 16),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16); \
        } \
} while(0)

#define FUT_FULL_PROBE17(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE17(FUT_CODE(CODE, 17),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17); \
        } \
} while(0)

#define FUT_FULL_PROBE18(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE18(FUT_CODE(CODE, 18),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18); \
        } \
} while(0)

#define FUT_FULL_PROBE19(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE19(FUT_CODE(CODE, 19),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19); \
        } \
} while(0)

#define FUT_FULL_PROBE20(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE20(FUT_CODE(CODE, 20),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20); \
        } \
} while(0)

#define FUT_FULL_PROBE21(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE21(FUT_CODE(CODE, 21),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21); \
        } \
} while(0)

#define FUT_FULL_PROBE22(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE22(FUT_CODE(CODE, 22),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22); \
        } \
} while(0)

#define FUT_FULL_PROBE23(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE23(FUT_CODE(CODE, 23),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23); \
        } \
} while(0)

#define FUT_FULL_PROBE24(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE24(FUT_CODE(CODE, 24),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24); \
        } \
} while(0)

#define FUT_FULL_PROBE25(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE25(FUT_CODE(CODE, 25),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25); \
        } \
} while(0)

#define FUT_FULL_PROBE26(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE26(FUT_CODE(CODE, 26),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26); \
        } \
} while(0)

#define FUT_FULL_PROBE27(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE27(FUT_CODE(CODE, 27),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27); \
        } \
} while(0)

#define FUT_FULL_PROBE28(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE28(FUT_CODE(CODE, 28),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28); \
        } \
} while(0)

#define FUT_FULL_PROBE29(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE29(FUT_CODE(CODE, 29),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29); \
        } \
} while(0)

#define FUT_FULL_PROBE30(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE30(FUT_CODE(CODE, 30),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30); \
        } \
} while(0)

#define FUT_FULL_PROBE31(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE31(FUT_CODE(CODE, 31),P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31); \
        } \
} while(0)

#define FUT_FULL_PROBE(KEYMASK,CODE,...) do { \
	if( KEYMASK & fut_active ) { \
                FUT_RAW_ALWAYS_PROBE(FUT_CODE(CODE, ) , ##__VA_ARGS__); \
        } \
} while(0)

#define FUT_FULL_PROBESTR(KEYMASK,CODE,S) do { \
	if (KEYMASK & fut_active) { \
		FUT_RAW_ALWAYS_PROBESTR(FUT_CODE(CODE, FUT_STRLEN(__s)),S); \
	} \
} while(0)

#else /* CONFIG_FUT */

#define FUT_DO_PROBE0(CODE)   do {} while (0)
#define FUT_FULL_PROBE0(MASK,CODE) do {} while (0)
#define FUT_DO_PROBE1(CODE,P1)   do {} while (0)
#define FUT_FULL_PROBE1(MASK,CODE,P1) do {} while (0)
#define FUT_DO_PROBE2(CODE,P1,P2)   do {} while (0)
#define FUT_FULL_PROBE2(MASK,CODE,P1,P2) do {} while (0)
#define FUT_DO_PROBE3(CODE,P1,P2,P3)   do {} while (0)
#define FUT_FULL_PROBE3(MASK,CODE,P1,P2,P3) do {} while (0)
#define FUT_DO_PROBE4(CODE,P1,P2,P3,P4)   do {} while (0)
#define FUT_FULL_PROBE4(MASK,CODE,P1,P2,P3,P4) do {} while (0)
#define FUT_DO_PROBE5(CODE,P1,P2,P3,P4,P5)   do {} while (0)
#define FUT_FULL_PROBE5(MASK,CODE,P1,P2,P3,P4,P5) do {} while (0)
#define FUT_DO_PROBE6(CODE,P1,P2,P3,P4,P5,P6)   do {} while (0)
#define FUT_FULL_PROBE6(MASK,CODE,P1,P2,P3,P4,P5,P6) do {} while (0)
#define FUT_DO_PROBE7(CODE,P1,P2,P3,P4,P5,P6,P7)   do {} while (0)
#define FUT_FULL_PROBE7(MASK,CODE,P1,P2,P3,P4,P5,P6,P7) do {} while (0)
#define FUT_DO_PROBE8(CODE,P1,P2,P3,P4,P5,P6,P7,P8)   do {} while (0)
#define FUT_FULL_PROBE8(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8) do {} while (0)
#define FUT_DO_PROBE9(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9)   do {} while (0)
#define FUT_FULL_PROBE9(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9) do {} while (0)
#define FUT_DO_PROBE10(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)   do {} while (0)
#define FUT_FULL_PROBE10(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10) do {} while (0)
#define FUT_DO_PROBE11(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11)   do {} while (0)
#define FUT_FULL_PROBE11(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11) do {} while (0)
#define FUT_DO_PROBE12(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12)   do {} while (0)
#define FUT_FULL_PROBE12(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12) do {} while (0)
#define FUT_DO_PROBE13(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13)   do {} while (0)
#define FUT_FULL_PROBE13(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13) do {} while (0)
#define FUT_DO_PROBE14(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14)   do {} while (0)
#define FUT_FULL_PROBE14(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14) do {} while (0)
#define FUT_DO_PROBE15(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15)   do {} while (0)
#define FUT_FULL_PROBE15(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15) do {} while (0)
#define FUT_DO_PROBE16(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16)   do {} while (0)
#define FUT_FULL_PROBE16(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16) do {} while (0)
#define FUT_DO_PROBE17(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17)   do {} while (0)
#define FUT_FULL_PROBE17(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17) do {} while (0)
#define FUT_DO_PROBE18(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18)   do {} while (0)
#define FUT_FULL_PROBE18(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18) do {} while (0)
#define FUT_DO_PROBE19(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19)   do {} while (0)
#define FUT_FULL_PROBE19(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19) do {} while (0)
#define FUT_DO_PROBE20(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20)   do {} while (0)
#define FUT_FULL_PROBE20(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20) do {} while (0)
#define FUT_DO_PROBE21(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21)   do {} while (0)
#define FUT_FULL_PROBE21(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21) do {} while (0)
#define FUT_DO_PROBE22(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22)   do {} while (0)
#define FUT_FULL_PROBE22(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22) do {} while (0)
#define FUT_DO_PROBE23(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23)   do {} while (0)
#define FUT_FULL_PROBE23(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23) do {} while (0)
#define FUT_DO_PROBE24(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24)   do {} while (0)
#define FUT_FULL_PROBE24(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24) do {} while (0)
#define FUT_DO_PROBE25(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25)   do {} while (0)
#define FUT_FULL_PROBE25(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25) do {} while (0)
#define FUT_DO_PROBE26(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26)   do {} while (0)
#define FUT_FULL_PROBE26(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26) do {} while (0)
#define FUT_DO_PROBE27(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27)   do {} while (0)
#define FUT_FULL_PROBE27(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27) do {} while (0)
#define FUT_DO_PROBE28(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28)   do {} while (0)
#define FUT_FULL_PROBE28(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28) do {} while (0)
#define FUT_DO_PROBE29(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29)   do {} while (0)
#define FUT_FULL_PROBE29(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29) do {} while (0)
#define FUT_DO_PROBE30(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30)   do {} while (0)
#define FUT_FULL_PROBE30(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30) do {} while (0)
#define FUT_DO_PROBE31(CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31)   do {} while (0)
#define FUT_FULL_PROBE31(MASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31) do {} while (0)
#define FUT_DO_PROBE(CODE,...)   do {} while (0)
#define FUT_FULL_PROBE(MASK,CODE,...) do {} while (0)
#define FUT_DO_PROBESTR(CODE,S) do {} while (0)
#define FUT_FULL_PROBESTR(MASK,CODE,S) do {} while (0)

#endif

#if defined(CONFIG_FUT_TIME_ONLY)

#define FUT_PROBE0(KEYMASK,CODE) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE1(KEYMASK,CODE,P1) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE2(KEYMASK,CODE,P1,P2) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE3(KEYMASK,CODE,P1,P2,P3) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE4(KEYMASK,CODE,P1,P2,P3,P4) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE5(KEYMASK,CODE,P1,P2,P3,P4,P5) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE6(KEYMASK,CODE,P1,P2,P3,P4,P5,P6) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE7(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE8(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE9(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE10(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE11(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE12(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE13(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE14(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE15(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE16(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE17(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE18(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE19(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE20(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE21(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE22(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE23(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE24(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE25(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE26(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE27(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE28(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE29(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE30(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE31(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE(KEYMASK,CODE,...) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBESTR(KEYMASK,CODE,S) FUt_FULL_PROBESTR(KEYMASK,CODE)

#else	/* CONFIG_FUT_TIME_ONLY */

#define FUT_PROBE0(KEYMASK,CODE) FUT_FULL_PROBE0(KEYMASK,CODE)
#define FUT_PROBE1(KEYMASK,CODE,P1) FUT_FULL_PROBE1(KEYMASK,CODE,P1)
#define FUT_PROBE2(KEYMASK,CODE,P1,P2) FUT_FULL_PROBE2(KEYMASK,CODE,P1,P2)
#define FUT_PROBE3(KEYMASK,CODE,P1,P2,P3) FUT_FULL_PROBE3(KEYMASK,CODE,P1,P2,P3)
#define FUT_PROBE4(KEYMASK,CODE,P1,P2,P3,P4) FUT_FULL_PROBE4(KEYMASK,CODE,P1,P2,P3,P4)
#define FUT_PROBE5(KEYMASK,CODE,P1,P2,P3,P4,P5) FUT_FULL_PROBE5(KEYMASK,CODE,P1,P2,P3,P4,P5)
#define FUT_PROBE6(KEYMASK,CODE,P1,P2,P3,P4,P5,P6) FUT_FULL_PROBE6(KEYMASK,CODE,P1,P2,P3,P4,P5,P6)
#define FUT_PROBE7(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7) FUT_FULL_PROBE7(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7)
#define FUT_PROBE8(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8) FUT_FULL_PROBE8(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8)
#define FUT_PROBE9(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9) FUT_FULL_PROBE9(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9)
#define FUT_PROBE10(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10) FUT_FULL_PROBE10(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)
#define FUT_PROBE11(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11) FUT_FULL_PROBE11(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11)
#define FUT_PROBE12(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12) FUT_FULL_PROBE12(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12)
#define FUT_PROBE13(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13) FUT_FULL_PROBE13(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13)
#define FUT_PROBE14(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14) FUT_FULL_PROBE14(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14)
#define FUT_PROBE15(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15) FUT_FULL_PROBE15(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15)
#define FUT_PROBE16(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16) FUT_FULL_PROBE16(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16)
#define FUT_PROBE17(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17) FUT_FULL_PROBE17(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17)
#define FUT_PROBE18(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18) FUT_FULL_PROBE18(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18)
#define FUT_PROBE19(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19) FUT_FULL_PROBE19(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19)
#define FUT_PROBE20(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20) FUT_FULL_PROBE20(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20)
#define FUT_PROBE21(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21) FUT_FULL_PROBE21(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21)
#define FUT_PROBE22(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22) FUT_FULL_PROBE22(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22)
#define FUT_PROBE23(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23) FUT_FULL_PROBE23(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23)
#define FUT_PROBE24(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24) FUT_FULL_PROBE24(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24)
#define FUT_PROBE25(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25) FUT_FULL_PROBE25(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25)
#define FUT_PROBE26(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26) FUT_FULL_PROBE26(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26)
#define FUT_PROBE27(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27) FUT_FULL_PROBE27(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27)
#define FUT_PROBE28(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28) FUT_FULL_PROBE28(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28)
#define FUT_PROBE29(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29) FUT_FULL_PROBE29(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29)
#define FUT_PROBE30(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30) FUT_FULL_PROBE30(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30)
#define FUT_PROBE31(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31) FUT_FULL_PROBE31(KEYMASK,CODE,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23,P24,P25,P26,P27,P28,P29,P30,P31)
#define FUT_PROBE(KEYMASK,CODE,...) FUT_FULL_PROBE(KEYMASK,CODE , ##__VA_ARGS__)
#define FUT_PROBESTR(KEYMASK,CODE,S) FUT_FULL_PROBESTR(KEYMASK,CODE,S)

#endif	/* CONFIG_FUT_TIME_ONLY */


/*	"how" parameter values, analagous to "how" parameters to FKT */
#define FUT_ENABLE		0xCE03		/* for enabling probes with 1's in keymask */
#define FUT_DISABLE		0xCE04		/* for disabling probes with 1's in keymask */
#define FUT_SETMASK		0xCE05		/* for enabling 1's, disabling 0's in keymask */

/*	Simple keymasks */
#define FUT_KEYMASK0				0x00000001
#define FUT_KEYMASK1				0x00000002
#define FUT_KEYMASK2				0x00000004
#define FUT_KEYMASK3				0x00000008
#define FUT_KEYMASK4				0x00000010
#define FUT_KEYMASK5				0x00000020
#define FUT_KEYMASK6				0x00000040
#define FUT_KEYMASK7				0x00000080
#define FUT_KEYMASK8				0x00000100
#define FUT_KEYMASK9				0x00000200
#define FUT_KEYMASK10				0x00000400
#define FUT_KEYMASK11				0x00000800
#define FUT_KEYMASK12				0x00001000
#define FUT_KEYMASK13				0x00002000
#define FUT_KEYMASK14				0x00004000
#define FUT_KEYMASK15				0x00008000
#define FUT_KEYMASK16				0x00010000
#define FUT_KEYMASK17				0x00020000
#define FUT_KEYMASK18				0x00040000
#define FUT_KEYMASK19				0x00080000
#define FUT_KEYMASK20				0x00100000
#define FUT_KEYMASK21				0x00200000
#define FUT_KEYMASK22				0x00400000
#define FUT_KEYMASK23				0x00800000
#define FUT_KEYMASK24				0x01000000
#define FUT_KEYMASK25				0x02000000
#define FUT_KEYMASK26				0x04000000
#define FUT_KEYMASK27				0x08000000
#define FUT_KEYMASK28				0x10000000
#define FUT_KEYMASK29				0x20000000
#define FUT_KEYMASK30				0x40000000
#define FUT_KEYMASK31				0x80000000
#define FUT_KEYMASKALL				0xffffffff

#define FUT_GCC_INSTRUMENT_KEYMASK	FUT_KEYMASK29


/*	Fixed parameters of the fut coding scheme */
#define FUT_GENERIC_EXIT_OFFSET		0x100	/* exit this much above entry */

#define FUT_UNPAIRED_LIMIT_CODE		0xf000	/* all unpaired codes above this limit */

/*	Codes for fut use */
#define FUT_SETUP_CODE				0xffff
#define FUT_KEYCHANGE_CODE			0xfffe
#define FUT_RESET_CODE				0xfffd
#define FUT_CALIBRATE0_CODE			0xfffc
#define FUT_CALIBRATE1_CODE			0xfffb
#define FUT_CALIBRATE2_CODE			0xfffa

#define FUT_THREAD_BIRTH_CODE                   0xfff9
#define FUT_THREAD_DEATH_CODE                   0xfff8
#define FUT_SET_THREAD_NAME_CODE                0xfff7

#define FUT_NEW_LWP_CODE                        0xfff6

#define FUT_START_FLUSH_CODE                    0xfff5
#define FUT_STOP_FLUSH_CODE                     0xfff4

#define FUT_RQS_NEWLEVEL			0xffef
#define FUT_RQS_NEWLWPRQ			0xffee
#define FUT_RQS_NEWRQ				0xffed

#define FUT_SWITCH_TO_CODE			0x31a

#define FUT_MAIN_ENTRY_CODE			0x301
#define FUT_MAIN_EXIT_CODE			0x401

/* -finstrument-functions code */
#define FUT_GCC_INSTRUMENT_ENTRY_CODE	0x320
#define FUT_GCC_INSTRUMENT_EXIT_CODE	0x420

#ifndef __ASSEMBLY__
extern unsigned long * volatile fut_next_slot;
extern unsigned long * volatile fut_first_slot;
extern unsigned long * volatile fut_last_slot;
extern size_t volatile fut_filled_slot;

extern int64_t fut_setup( uint64_t nints, unsigned int keymask,
			unsigned int threadid );
extern int64_t fut_setup_flush_callback( uint64_t nints, unsigned int keymask,
			unsigned int threadid, void (*flush_callback)(void) );
extern uint64_t fut_endup( const char *filename );
extern int fut_done(void );
extern int fut_keychange( int how, unsigned int keymask,
			unsigned int threadid );
extern int64_t fut_reset( unsigned int keymask, unsigned int threadid );
extern uint64_t fut_getbuffer( uint64_t *nints, unsigned long **buffer, unsigned long *first_slot, unsigned long *next_slot);

extern int fut_header( unsigned long head, ... );

extern void enable_fut_flush( void );
extern void disable_fut_flush( void );

extern void fut_set_filename( const char *filename );

/* activate the recording of thread id */
extern void fut_enable_tid_logging( void );

/* disactivate the recording of thread id */
extern void fut_disable_tid_logging( void );
#endif


#ifdef __cplusplus
}
#endif

#endif
