/**********************************************************************************************************
Copyright (c) 2002-2009 Abdul-Rahman Allouche. All rights reserved

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
documentation files (the Gabedit), to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all copies or substantial portions
  of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
************************************************************************************************************/

#ifndef __GABEDIT_GEOMGLOBAL_H__
#define __GABEDIT_GEOMGLOBAL_H__

#ifndef GEOM_IS_XYZ 
#define GEOM_IS_XYZ    2  /* 0 for IS_MOLPRO 1 for IS_GAUSS */
#endif

#ifndef GEOM_IS_ZMAT
#define GEOM_IS_ZMAT  3
#endif
#ifndef GEOM_IS_OTHER
#define GEOM_IS_OTHER  -1
#endif

typedef struct _VariablesDef
{
 gchar *Name;
 gchar *Value;
 gboolean Used;
}VariablesDef;

typedef struct _GeomAtomDef
{
 gint Nentry;
 gchar *Symb;
 gchar *mmType;
 gchar *pdbType;
 gchar *Residue;
 gint ResidueNumber;
 gchar *R;
 gchar *NR;
 gchar *Angle;
 gchar *NAngle;
 gchar *Dihedral;
 gchar *NDihedral;
 gchar* Charge;
 gchar *Layer;
}GeomAtomDef;

typedef struct _VariablesXYZDef
{
 gchar *Name;
 gchar *Value;
 gboolean Used;
}VariablesXYZDef;


typedef struct _GeomXYZAtomDef
{
 gint Nentry;
 gchar *Symb;
 gchar *mmType;
 gchar *pdbType;
 gchar *Residue;
 gint ResidueNumber;
 gchar* Charge;
 gchar *X;
 gchar *Y;
 gchar *Z;
 gchar *Layer;
 gint* typeConnections;
}GeomXYZAtomDef;

typedef struct _DipoleDef
{
 gboolean def;
 gfloat Value[3];
 gfloat radius;
 gfloat color[3];
}DipoleDef;

typedef struct _GeomInter
{
 GtkWidget *window; 
 GtkWidget *vbox; 
 gchar *frametitle; 
}GeomInter;

typedef struct _FilePosTypeGeom
{
 gint numline;
 gint geomtyp;
 gint units;
}FilePosTypeGeom;

#define NUMBER_ENTRY_0		5
#define NUMBER_ENTRY_R		7
#define NUMBER_ENTRY_ANGLE	9
#define NUMBER_ENTRY_DIHEDRAL	11
#define NUMBER_LIST_ZMATRIX	13
#define NUMBER_LIST_XYZ		10
 

VariablesXYZDef *VariablesXYZ;
VariablesDef *Variables;
GeomAtomDef* Geom;
GeomXYZAtomDef* GeomXYZ;
guint  NVariablesXYZ;
guint  NVariables;
guint NcentersXYZ;
guint NcentersZmat;
guint MethodeGeom;
guint Nelectrons;
DipoleDef Dipole;
GtkWidget *ZoneDessin;
GeomInter *geominter;
GtkWidget *HboxGeom;
GtkWidget *WindowGeom;
gboolean GeomIsOpen;
guint TypeGeomOpen;
guint Units;
guint NMethodes;
gint NSA;
gint TotalCharges[3];
gint SpinMultiplicities[3];

void set_spin_of_electrons();

#endif /* __GABEDIT_GEOMGLOBAL_H__ */

