/*
 * accounts.h
 * Thomas Nemeth, le 22.02.2000 (from acclists.h 18.09.1999)
 *
 * HEADER
 * Gestion de la liste des donnes de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _ACCOUNTS_H_
#define _ACCOUNTS_H_

#include <stdio.h>
#include "structs.h"

/* ------++++++======*** COMPTES ****** ACCOUNTS ***======++++++------ */

/* Charge le contenu d'un fichier cr par la version 0.01            */
/* Load an account file created by version 0.01                       */
void read_from_last_version (FILE *file);

/* Charge le contenu d'un fichier de portefeuille de comptes          */
/* Load an accounts wallet file                                       */
void read_accounts_from_file ();

/* crit les donnes sur les comptes dans un fichier                  */
/* Write the accounts wallet from memory to file                      */
void write_accounts_to_file ();

/* Ajoute un compte au portefeuille                                   */
/* Add an account to the wallet                                       */
void add_account (ACCOUNT *account);

/* Efface un compte du portefeuille                                   */
/* Delete an account from the wallet                                  */
void del_account (ACC_ELT *element);

/* Rcupre un compte par son numro (premier == 0)                   */
/* Get an account by its number (first == 0)                          */
ACC_ELT *get_account (int acc_num);

/* Rcupre un compte par son nom                                     */
/* Get an account by its name                                         */
ACC_ELT *get_account_with_name (const char *acc_name);

/* Libre la mmoire utilise par un portefeuille de comptes          */
/* Free the memory used by an accounts wallet                         */
void free_accounts ();

/* Oprations sur les comptes                                         */
/* Operations on accounts                                             */
ACCOUNT *account_new ();
ACCOUNT *get_account_from_line (const char *line);
char *create_line_from_account (ACCOUNT *acc);
ACC_ELT *acc_list_elt_new ();
void acc_set_name (ACCOUNT *acc, const char *name);
void acc_set_num (ACCOUNT *acc, const char *num);
void acc_set_bank (ACCOUNT *acc, const char *bank);
void acc_set_date (ACCOUNT *acc, const char *date);
void acc_set_amount (ACCOUNT *acc, float amount);
int nb_ope (ACC_ELT *acc);

#endif
