/*
 * gAcc_catlist.c
 * Thomas Nemeth, le 08.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "gAcc_catlist.h"
#include "acclists.h"
#include "categories.h"
#include "gAcc.h"
#include "gAcc_menus.h"
#include "gAcc_menuscb.h"


/*** Create the "Categories' list" dialog box ****************************/

void cat_list_sel_cb (GtkCList *clist,
                      gint row,
                      gint column,
                      GdkEventButton *event,
                      void *data) {
    /* A list element has been selected */
    MY_LIST   *list             = (MY_LIST *)  data;
    GtkWidget *menu             = (GtkWidget *) my_list_get_element (list, 1);
    GtkWidget *edit_menu_item   = (GtkWidget *) my_list_get_element (list, 2);
    GtkWidget *delete_menu_item = (GtkWidget *) my_list_get_element (list, 3);

    gtk_widget_set_sensitive (GTK_WIDGET (edit_menu_item), TRUE);
    gtk_widget_set_sensitive (GTK_WIDGET (delete_menu_item), TRUE);

    selected_row = row;
    if ( (event->button == 1) && (event->type == GDK_2BUTTON_PRESS) )
        edit_cat_cb (NULL, clist);
    if ( (event->button == 3) && (event->type == GDK_2BUTTON_PRESS) )
        gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
                        event->button, event->time);
}

void cat_list_unsel_cb (GtkCList *clist,
                        gint row,
                        gint column,
                        GdkEventButton *event,
                        void *data) {
    /* A list element has been selected */
    MY_LIST   *list             = (MY_LIST *)  data;
    GtkWidget *edit_menu_item   = (GtkWidget *) my_list_get_element (list, 2);
    GtkWidget *delete_menu_item = (GtkWidget *) my_list_get_element (list, 3);

    gtk_widget_set_sensitive (GTK_WIDGET (edit_menu_item), FALSE);
    gtk_widget_set_sensitive (GTK_WIDGET (delete_menu_item), FALSE);

/*
    GtkWidget *menu             = (GtkWidget *) my_list_get_element (list, 1);
    selected_row = row;
    if (event->button == 3)
        gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
                        event->button, event->time);
*/
}

void set_cat_list (GtkWidget *list) {
    CAT_ELT  *cat;
    GdkColor  rose = { 0, 65535, 49152, 49152};
    gchar    *catlist[3];
    char     *num;
    int       row = 0;

    gtk_clist_clear (GTK_CLIST (list) );
    gtk_clist_freeze (GTK_CLIST (list) );
    cat = config.cat_list_head;
    while (cat != NULL) {
        catlist[0] = cat->category->name;
        MY_ALLOC (num, 6, char);
        switch (cat->category->type) {
            case DEBIT  : catlist[1] = _("debit");
                    break;
            case CREDIT : catlist[1] = _("credit");
                    break;
            default : catlist[1] = _("unknown");
                    break;
        }
        sprintf (num, "%d", cat->category->num);
        catlist[2] = num;
        gtk_clist_append ( (GtkCList *) list, catlist);
        if ( (row / 2) == ( (float) row / 2) )
            gtk_clist_set_background (GTK_CLIST (list), row,
                                      &rose );
        free (num);
        cat = cat->next;
        row++;
    }
    gtk_clist_thaw (GTK_CLIST (list) );
    gtk_clist_unselect_all (GTK_CLIST (list) );
}

void catlist_close_cb (GtkWidget *widget, void *data) {
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         (MY_LIST *) data, 0) );
    my_list_free ( (MY_LIST *) data);
}

GtkWidget *create_catlist_dialog () {
    GtkWidget     *CatList_Dialog;
    GtkWidget     *bouton;
    GtkWidget     *scrolled_window;
    GtkWidget     *menubar;
    GtkWidget     *menubar_item;
    GtkWidget     *cat_clist;
    GtkWidget     *cat_list_menu;
    GtkWidget     *edit_cat_menu_item = NULL;
    GtkWidget     *delete_cat_menu_item = NULL;
    GtkAccelGroup *accel_group;
    GtkStyle      *style;
    MY_LIST       *list = NULL;
    int            size, total = 0;
    gchar         *cat_titles[3] = { _(" Category "),
                                     _(" Type "),
                                     _(" Number ") };

    CatList_Dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (CatList_Dialog), _("Categories list") );
    list = my_list_add (list, CatList_Dialog);
    gtk_signal_connect (GTK_OBJECT (CatList_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                         NULL);
    gtk_signal_connect (GTK_OBJECT (CatList_Dialog), "destroy", 
		                GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                NULL);

    bouton = gtk_button_new_with_label (_("Close"));
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (catlist_close_cb),
                        list);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (CatList_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);

    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_grab_default (GTK_WIDGET (bouton) );
    gtk_widget_draw_default (GTK_WIDGET (bouton) );

    gtk_widget_show (bouton);

    cat_clist = gtk_clist_new_with_titles (3, cat_titles);

    /* CATEGORIES MENU */
    menubar       = gtk_menu_bar_new ();
    menubar_item  = gtk_menu_item_new_with_label (_("Categories") );
    accel_group = gtk_accel_group_new();
    gtk_window_add_accel_group (GTK_WINDOW (CatList_Dialog), accel_group);
    cat_list_menu = create_catlist_menus (&accel_group,
                                          cat_clist,
                                          &edit_cat_menu_item,
                                          &delete_cat_menu_item);
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menubar_item), cat_list_menu);
    gtk_menu_bar_append (GTK_MENU_BAR (menubar), menubar_item);
    gtk_widget_show (menubar_item);
    gtk_widget_show (menubar);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (CatList_Dialog)->vbox), menubar,
                        FALSE, TRUE, 0);
    list = my_list_add (list, cat_list_menu);
    list = my_list_add (list, edit_cat_menu_item);
    list = my_list_add (list, delete_cat_menu_item);
    /* operations menu */

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC,
                                    GTK_POLICY_ALWAYS);

    style = gtk_style_copy (gtk_widget_get_default_style () ); 
    /* Category */
    size = gdk_string_width (style->font, "123456789012345678901234567890123456"); /* 120 */
    total += size;
    gtk_clist_set_column_width (GTK_CLIST (cat_clist), 0, size);
    #ifdef DEBUG_GACC
        printf ("Category - size = %d\n", size);
    #endif
    /* Type */
    size = gdk_string_width (style->font, " credit ");  /* 60 */
    total += size;
    gtk_clist_set_column_width (GTK_CLIST (cat_clist), 1, size);
    #ifdef DEBUG_GACC
        printf ("Type - size = %d\n", size);
    #endif
    /* Number */
    size = gdk_string_width (style->font, "Number");  /* 50 */
    total += size;
    gtk_clist_set_column_width (GTK_CLIST (cat_clist), 2, size);
    #ifdef DEBUG_GACC
        printf ("Number - size = %d\n", size);
    #endif

    gtk_clist_set_column_justification (GTK_CLIST (cat_clist), 1,
                                        GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification (GTK_CLIST (cat_clist), 2,
                                        GTK_JUSTIFY_RIGHT);

    gtk_clist_set_selection_mode (GTK_CLIST (cat_clist), GTK_SELECTION_SINGLE);
    gtk_clist_column_titles_passive (GTK_CLIST (cat_clist) );
    gtk_clist_set_button_actions (GTK_CLIST (cat_clist), 1, GTK_BUTTON_SELECTS);
    gtk_clist_set_button_actions (GTK_CLIST (cat_clist), 2, GTK_BUTTON_SELECTS);
    gtk_clist_set_button_actions (GTK_CLIST (cat_clist), 3, GTK_BUTTON_SELECTS);
    gtk_signal_connect (GTK_OBJECT (cat_clist), "select-row",
                        GTK_SIGNAL_FUNC (cat_list_sel_cb), list);
    gtk_signal_connect (GTK_OBJECT (cat_clist), "unselect-row",
                        GTK_SIGNAL_FUNC (cat_list_unsel_cb), list);
    gtk_container_add (GTK_CONTAINER (scrolled_window), cat_clist);
    gtk_widget_show (cat_clist);
    set_cat_list (cat_clist);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (CatList_Dialog)->vbox),
                        scrolled_window, TRUE, TRUE, 0);
    gtk_widget_show (scrolled_window);

    gtk_widget_set_usize (GTK_WIDGET (CatList_Dialog), total + 50, 350); /* 280 */

    return CatList_Dialog;
}
