/*
 * operations.c
 * Thomas Nemeth, le 22.02.2000 (from acclists.c 18.09.1999)
 *
 * Gestion de la liste des donnes de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "structs.h"
#include "operations.h"
#include "categories.h"
#include "fileaccess.h"
#include "usefull.h"
#include "oldversions.h"

int OPERATION_COPY = FAUX;


/* ------++++++======*** OPRATIONS * OPERATIONS ***======++++++----- */

void add_operation (ACCOUNT *acc, OPERATION *operation) {
    OPE_ELT *ope, *prev_ope, *support;

    ope      = acc->ope_list_head;
    prev_ope = NULL;
    while ( (ope != NULL) && (! stop_loop (operation, ope->operation) ) ) {
        prev_ope = ope;
        ope      = ope->next;
    }
    #ifdef DEBUG_GACC
        printf ("ADDING \"%s\" between \"%s\" and \"%s\"...\n",
                operation->object,
                prev_ope != NULL ? prev_ope->operation->object : "START",
                ope != NULL ? ope->operation->object : "END");
    #endif
    support                = ope_list_elt_new ();
    support->operation     = operation;
    support->prev          = prev_ope;
    support->next          = ope;
    if (prev_ope != NULL)
        prev_ope->next     = support;
    else
        acc->ope_list_head = support;
    if (ope != NULL) ope->prev = support;
    config.AccDataModified = VRAI;
}

void remove_operation (ACC_ELT *acc, OPERATION *operation) {
    OPE_ELT *ope = acc->account->ope_list_head;

    while ( (ope != NULL) && (ope->operation != operation) ) ope = ope->next;
    if (ope->operation == operation) {
        #ifdef DEBUG_GACC
            printf ("REMOVING \"%s\" from between \"%s\" and \"%s\"...\n",
                    ope->operation->object,
                    ope->prev != NULL ? ope->prev->operation->object : "START",
                    ope->next != NULL ? ope->next->operation->object : "END");
        #endif
        if (ope->prev != NULL) ope->prev->next = ope->next;
        if (ope->next != NULL) ope->next->prev = ope->prev;

        if (ope == acc->account->ope_list_head)
            acc->account->ope_list_head = ope->next;

        free (ope);
        config.AccDataModified = VRAI;
    } else
        printf ("remove_operation : operation not found in that account !\n");
}

void del_operation (ACC_ELT *acc, OPE_ELT *element) {
    OPERATION *operation = element->operation;

    remove_operation (acc, operation);

    free (operation->num);
    free (operation->object);
    free (operation->date);
/*    free (operation->comment); */
    free (operation);
}

OPE_ELT *get_operation_by_num (OPE_ELT *opl, int ope_num) {
    OPE_ELT *ope = NULL;
    int      i = 0;

    if (opl != NULL) {
        ope = opl;
        while ( (i != ope_num) && (ope != NULL) ) {
            ope = ope->next;
            i++;
        }
    }

    return ope;
}

OPE_ELT *get_operation_by_id (OPE_ELT *opl, int ope_id) {
    OPE_ELT *ope = NULL;

    if (opl != NULL) {
        ope = opl;
        while ( (ope != NULL) && (ope->operation->id != ope_id) )
            ope = ope->next;
    }

    return ope;
}

int ope_get_num_by_id (OPE_ELT *opl, int ope_id) {
    OPE_ELT *ope = NULL;
    int      i   = 0;

    if (opl != NULL) {
        ope = opl;
        while ( (ope != NULL) && (ope->operation->id != ope_id) ) {
            ope = ope->next;
            i++;
        }
    }

    return i;
}

char *get_last_ope_num (ACC_ELT *acc) {
    OPE_ELT *ope = acc->account->ope_list_head;
    char    *num = NULL;
    #ifdef DEBUG_GACC
        printf ("Demande de recherche sur compte : %s\n", acc->account->name);
    #endif

    if (ope != NULL) {
        #ifdef DEBUG_GACC
            printf ("Recherche du numro prcdent...\n");
        #endif
        while (ope != NULL) {
            #ifdef DEBUG_GACC
                printf ("Numro = %s : opration = %s\n",
                        ope->operation->num != NULL ? ope->operation->num : "",
                        ope->operation->object);
            #endif
            if (ope->operation->num != NULL) {
                #ifdef DEBUG_GACC
                    printf ("==> Ce numro est valide !\n");
                #endif
                num = ope->operation->num;
            }
            ope = ope->next;
        }
    }
    #ifdef DEBUG_GACC
        printf ("Dernier numro = \"%s\"\n", num);
    #endif
    return num;
}

unsigned int ope_next_id (ACC_ELT *acc) {
    OPE_ELT *ope = acc->account->ope_list_head;
    int      id  = 0;
    #ifdef DEBUG_GACC
        printf ("Demande de recherche sur compte : %s\n", acc->account->name);
    #endif

    if (ope != NULL) {
        #ifdef DEBUG_GACC
            printf ("Recherche de l'id le plus grand...\n");
        #endif
        while (ope != NULL) {
            #ifdef DEBUG_GACC
                printf ("Numro = %s => opration = %s avec l'id : %d \n",
                        ope->operation->num != NULL ? ope->operation->num : "",
                        ope->operation->object,
                        ope->operation->id);
            #endif
            if (ope->operation->id > id) {
                #ifdef DEBUG_GACC
                    printf ("==> Cet id est valide !\n");
                #endif
                id = ope->operation->id;
            }
            ope = ope->next;
        }
    }
    #ifdef DEBUG_GACC
        printf ("Dernier id = %d\n", id);
    #endif
    return id + 1;
}

void operation_copy (OPERATION *source, OPERATION *dest) {
    OPERATION_COPY = VRAI;
    /* id */
    ope_set_id (dest, source->id);
    /* num */
    ope_set_parent (dest, source->parent);
    /* num */
    ope_set_num (dest, source->num);
    /* object */
    ope_set_object (dest, source->object);
    /* date */
    ope_set_date (dest, source->date);
    /* comment */
/*    ope_set_comment (dest, source->comment); */
    /* amount */
    ope_set_amount (dest, source->amount);
    /* medium */
    ope_set_medium (dest, source->medium);
    /* type */
    ope_set_type (dest, source->type);
    /* status */
    ope_set_pointed (dest, source->pointed);
    /* canceled */
    ope_set_cancelled (dest, source->cancelled);
    /* category */
    ope_set_category (dest, source->category);
    /* tiers */
    ope_set_tiers (dest, source->tiers);
    /* tiers operation id */
    ope_set_trsopid (dest, source->trs_opeid);
    /* DON'T KNOW WHAT TO DO WITH SPLITS !!! */
    OPERATION_COPY = FAUX;
}

OPE_ELT *create_list_by_medium (OPE_ELT *ope, int medium) {
    OPE_ELT *l, *e = NULL, *list = NULL;
    int      i     = 0;
    int      exist = FAUX;

    l = ope;
    while (l != NULL) {
        if (l->operation->medium == medium) exist = VRAI;
        l = l->next;
    }
    if (exist == VRAI) {
        list = ope_list_elt_new ();
        e = list;
        l = ope;
        while (l != NULL) {
            #ifdef DEBUG_GACC
                printf ("Opration %s : %d (recherch = %d)\n",
                        l->operation->object,
                        l->operation->medium,
                        medium);
            #endif
            if (l->operation->medium == medium) {
                if (i != 0) {
                    e->next = ope_list_elt_new ();
                    e       = e->next;
                }
                e->operation = l->operation;
                i++;
            }
            l = l->next;
        }
    }
    return list;
}

OPE_ELT *create_list_by_type (OPE_ELT *ope, int type) {
    OPE_ELT *l, *e = NULL, *list = NULL;
    int      i     = 0;
    int      exist = FAUX;

    l = ope;
    while (l != NULL) {
        if (l->operation->type == type) exist = VRAI;
        l = l->next;
    }
    if (exist == VRAI) {
        list = ope_list_elt_new ();
        e = list;
        l = ope;
        while (l != NULL) {
            #ifdef DEBUG_GACC
                printf ("Opration %s : %d (recherch = %d / CREDIT = %d)\n",
                        l->operation->object,
                        l->operation->type,
                        type, CREDIT);
            #endif
            if (l->operation->type == type) {
                if (i != 0) {
                    e->next = ope_list_elt_new ();
                    e       = e->next;
                }
                e->operation = l->operation;
                i++;
            }
            l = l->next;
        }
    }
    return list;
}

OPE_ELT *create_list_by_cat (OPE_ELT *ope, int category) {
    OPE_ELT *l, *e = NULL, *list = NULL;
    int      i     = 0;
    int      exist = FAUX;

    l = ope;
    while (l != NULL) {
        if (l->operation->category == category) exist = VRAI;
        l = l->next;
    }
    if (exist == VRAI) {
        list = ope_list_elt_new ();
        e = list;
        l = ope;
        while (l != NULL) {
            #ifdef DEBUG_GACC
                printf ("Opration %s : %d (recherch = %d)\n",
                        l->operation->object,
                        l->operation->category,
                        category);
            #endif
            if (l->operation->category == category) {
                if (i != 0) {
                    e->next = ope_list_elt_new ();
                    e       = e->next;
                }
                e->operation = l->operation;
                i++;
            }
            l = l->next;
        }
    }
    return list;
}

OPE_ELT *create_list_by_status (OPE_ELT *ope, int pointed) {
    OPE_ELT *l, *e = NULL, *list = NULL;
    int      i     = 0;
    int      exist = FAUX;

    l = ope;
    while (l != NULL) {
        if (l->operation->pointed == pointed) exist = VRAI;
        l = l->next;
    }
    if (exist == VRAI) {
        list = ope_list_elt_new ();
        e = list;
        l = ope;
        while (l != NULL) {
            #ifdef DEBUG_GACC
                printf ("Opration %s : %d (recherch = %d / VRAI = %d)\n",
                        l->operation->object,
                        l->operation->pointed,
                        pointed, VRAI);
            #endif
            if (l->operation->pointed == pointed) {
                if (i != 0) {
                    e->next = ope_list_elt_new ();
                    e       = e->next;
                }
                e->operation = l->operation;
                i++;
            }
            l = l->next;
        }
    }
    return list;
}

OPE_ELT *create_list_by_interval (OPE_ELT *ope,
                                  const char *date1,
                                  const char *date2) {
    OPE_ELT *l, *e = NULL, *list = NULL;
    int      i     = 0;
    int      exist = FAUX;

    l = ope;
    while (l != NULL) {
        if ( (strcmp (l->operation->date, date1) >= 0) &&
             (strcmp (l->operation->date, date2) <= 0) )
            exist = VRAI;
        l = l->next;
    }
    if (exist == VRAI) {
        list = ope_list_elt_new ();
        e = list;
        l = ope;
        while (l != NULL) {
            #ifdef DEBUG_GACC
                printf ("Opration %s : %s (recherch entre = %s et %s)\n",
                        l->operation->object,
                        l->operation->date,
                        date1, date2);
            #endif
            if ( (strcmp (l->operation->date, date1) >= 0) &&
                 (strcmp (l->operation->date, date2) <= 0) ) {
                if (i != 0) {
                    e->next = ope_list_elt_new ();
                    e       = e->next;
                }
                e->operation = l->operation;
                i++;
            }
            l = l->next;
        }
    }
    return list;
}

OPE_ELT *create_list_by_day (OPE_ELT *ope, const char *date) {
    OPE_ELT *l, *e = NULL, *list = NULL;
    int      i     = 0;
    int      exist = FAUX;

    l = ope;
    while (l != NULL) {
        if (strcmp (l->operation->date, date) == 0)
            exist = VRAI;
        l = l->next;
    }
    if (exist == VRAI) {
        list = ope_list_elt_new ();
        e = list;
        l = ope;
        while (l != NULL) {
            #ifdef DEBUG_GACC
                printf ("Opration %s : %s (recherch = %s)\n",
                        l->operation->object,
                        l->operation->date,
                        date);
            #endif
            if (strcmp (l->operation->date, date) == 0) {
                if (i != 0) {
                    e->next = ope_list_elt_new ();
                    e       = e->next;
                }
                e->operation = l->operation;
                i++;
            }
            l = l->next;
        }
    }
    return list;
}

OPE_ELT *create_list_by_date (OPE_ELT *ope,
                              const char *date1,
                              const char *date2) {
    OPE_ELT *list = NULL;

    if ( (date2 == NULL) || (strcmp (date1, date2) == 0) )
        list = create_list_by_day (ope, date1);
    else
        list = create_list_by_interval (ope, date1, date2);

    return list;
}

void free_ope_list (OPE_ELT **list) {
    OPE_ELT *p = *list, *q = *list;
    while (p != NULL) {
        q = p->next;
        free (p->operation->num);
        free (p->operation->object);
        free (p->operation->date);
/*        free (p->operation->comment); */
        free (p->operation);
        free (p);
        p = q;
    }
    *list = NULL;
}

void free_res_list (OPE_ELT **list) {
    OPE_ELT *p = *list, *q = *list;
    while (p != NULL) {
        q = p->next;
        free (p);
        p = q;
    }
    *list = NULL;
}

OPERATION *operation_new () {
    OPERATION *ope;

    MY_ALLOC (ope, 1, OPERATION);

    ope->id        = 0;
    ope->parent    = 0;
    ope->num       = NULL;
    ope->object    = NULL;
    ope->date      = NULL;
/*    ope->comment   = NULL; */
    ope->amount    = 0.0;
    ope->medium    = CREDCARD;
    ope->type      = DEBIT;
    ope->pointed   = FAUX;
    ope->cancelled = FAUX;
    ope->category  = UNKNOWN_CATEGORY;
    ope->tiers     = 0;
    ope->splits    = NULL;

    return ope;
}

OPERATION *get_operation_from_line (const char *line) {
    OPERATION *ope = operation_new ();
    char      *elt = NULL;
    int        i = 0, j = 0, k = 0;

    /* setlocale (LC_NUMERIC, "C"); */
    MY_ALLOC (elt, MAXSTRLEN + 1, char);
    #ifdef DEBUG_GACC
        printf ("Rcupration d'une opration --->\n");
    #endif
    for (i = 0 ; i < strlen (line) ; i++) {
        if ( (line[i] != '\t') && (line[i] != '\n') ){
            elt[j] = line[i];
            j++;
        } else {
            elt[j] = 0;
            j      = 0;
            #ifdef DEBUG_GACC
                printf ("Niveau %s -- ",
                        k ==   0 ? "ID " :
                        k ==   1 ? "PAR" :
                        k ==   2 ? "NUM" :
                        k ==   3 ? "OBJ" :
                        k ==   4 ? "DAT" :
                        k ==   5 ? "AMO" :
                        k ==   6 ? "MED" :
                        k ==   7 ? "TYP" :
                        k ==   8 ? "PTD" :
                        k ==   9 ? "CAN" :
                        k ==  10 ? "CAT" : "TIE");
                printf ("lement reconnu : %s\n", elt);
            #endif
            switch (k) {
                case  0 : ope->id        = atoi (elt);
                          break;
                case  1 : ope->parent    = atoi (elt);
                          break;
                case  2 : if (elt[0] != 0) {
                              MY_ALLOC (ope->num, strlen (elt) + 1, char);
                              strcpy (ope->num, elt);
                          } else ope->num = NULL;
                          break;
                case  3 : if (elt[0] != 0) {
                              MY_ALLOC (ope->object, strlen (elt) + 1, char);
                              strcpy (ope->object, elt);
                          } else ope->object = NULL;
                          break;
                case  4 : if (elt[0] != 0) {
                              MY_ALLOC (ope->date, strlen (elt) + 1, char);
                              strcpy (ope->date, elt);
                          } else ope->date = NULL;
                          break;
                case  5 : ope->amount    = atof (elt);
                          break;
                case  6 : ope->medium    = atoi (elt);
                          break;
                case  7 : ope->type      = atoi (elt);
                          break;
                case  8 : ope->pointed   = atoi (elt);
                         break;
                case  9 : ope->cancelled = atoi (elt);
                          break;
                case 10 : ope->category  = atoi (elt);
                          break;
                case 11 : ope->tiers     = atoi (elt);
                          break;
                default : MY_STOP;
            }
            k++;
        }
    }
    free (elt);
    /* setlocale (LC_NUMERIC, ""); */
    #ifdef DEBUG_GACC
        printf ("Rcupration d'une opration ---|\n");
    #endif

    return ope;
}

char *create_line_from_operation (OPERATION *ope) {
    char *line;

    /* setlocale (LC_NUMERIC, "C"); */
    MY_ALLOC (line, MAXSTRLEN + 1, char);
    sprintf (line, "%d\t%d\t%s\t%s\t%s\t%.5f\t%d\t%d\t%d\t%d\t%d\t%d\n",
             ( (ope != NULL) )                          ? ope->id        : 0,
             ( (ope != NULL) )                          ? ope->parent    : 0,
             ( (ope != NULL) && (ope->num != NULL) )    ? ope->num       : "",
             ( (ope != NULL) && (ope->object != NULL) ) ? ope->object    : "",
             ( (ope != NULL) && (ope->date != NULL) )   ? ope->date      : "",
             ( (ope != NULL) )                          ? ope->amount    : 0,
             ( (ope != NULL) )                          ? ope->medium    : 0,
             ( (ope != NULL) )                          ? ope->type      : 0,
             ( (ope != NULL) )                          ? ope->pointed   : 0,
             ( (ope != NULL) )                          ? ope->cancelled : 0,
             ( (ope != NULL) )                          ? ope->category  : 0,
             ( (ope != NULL) )                          ? ope->tiers     : 0);
    /* setlocale (LC_NUMERIC, ""); */

    return line;
}

OPE_ELT *ope_list_elt_new () {
    OPE_ELT *elt;

    MY_ALLOC (elt, 1, OPE_ELT);

    elt->operation = NULL;
    elt->prev      = NULL;
    elt->next      = NULL;

    return elt;
}

void ope_set_id (OPERATION *ope, unsigned int id) {
    if (id != 0) {
        ope->id = id;
        if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
    }
}

void ope_set_parent (OPERATION *ope, unsigned int parent) {
    if (parent != 0) {
        ope->parent = parent;
        if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
    }
}

void ope_set_num (OPERATION *ope, const char *num) {
    if ( (num != NULL) && (strcmp (num, "") != 0) ) {
        if (ope->num != NULL) free (ope->num);
        MY_ALLOC (ope->num, (strlen (num) + 1), char);
        strcpy (ope->num, num);
        if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
    }
}

void ope_set_object (OPERATION *ope, const char *object) {
    if (object != NULL) {
        if (ope->object != NULL) free (ope->object);
        MY_ALLOC (ope->object, (strlen (object) + 1), char);
        strcpy (ope->object, object);
        if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
    }
}

void ope_set_date (OPERATION *ope, const char *date) {
    if (date != NULL) {
        if (ope->date != NULL) free (ope->date);
        MY_ALLOC (ope->date, (strlen (date) + 1), char);
        strcpy (ope->date, date);
        if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
    }
}
/*
void ope_set_comment (OPERATION *ope, const char *comment) {
    if (comment != NULL) {
        if (ope->comment != NULL) free (ope->comment);
        MY_ALLOC (ope->comment, (strlen (comment) + 1), char);
        strcpy (ope->comment, comment);
        if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
    }
}
*/
void ope_set_amount (OPERATION *ope, float amount) {
    if (amount > 0.0) ope->amount = amount;
    if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
}

void ope_set_medium (OPERATION *ope, int medium) {
    if ( (medium == CREDCARD) ||
         (medium == CHEQUE)   ||
         (medium == PRELEVMT) ||
         (medium == VIREMENT) )
        ope->medium = medium;
    if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
}

void ope_set_type (OPERATION *ope, int type) {
    if ( (type == DEBIT) || (type == CREDIT) ) {
        ope->type = type;
        if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
    }
}

void ope_set_pointed (OPERATION *ope, int pointed) {
    if ( (pointed == VRAI) || (pointed == FAUX) ) {
        ope->pointed = pointed;
        if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
    }
}

void ope_set_cancelled (OPERATION *ope, int cancelled) {
    if ( (cancelled == VRAI) || (cancelled == FAUX) ) {
        ope->cancelled = cancelled;
        if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
    }
}

void ope_set_category (OPERATION *ope, int category) {
    if (category_name (category) != NULL) ope->category = category;
    else ope->category = UNKNOWN_CATEGORY;
    if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
}

void ope_set_tiers (OPERATION *ope, int tiers) {
    ope->tiers = tiers;
    if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
}

void ope_set_trsopid (OPERATION *ope, int trs_opeid) {
    ope->trs_opeid = trs_opeid;
    if (OPERATION_COPY == FAUX) config.AccDataModified = VRAI;
}

void display_all_list (OPE_ELT *ope_list) {
    OPE_ELT *ope = ope_list;
    
    while (ope != NULL) {
        printf ("%s\n", ope->operation->object);
        ope = ope->next;
    }
}

