/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "functions.h"
#include "commented.h"
#include "create_scope_set_entries.h"


extern char global_netmask[1024];
extern char global_subnet[1024];
extern char global_nic[1024];
extern char DHCPD_CONF_BUF[1024];
extern int MAX_CONF_LINE;


void populate_scope_settings(struct w *widgets)
{
    FILE *fp;
    gchar *utf8=NULL;
    char *line, *buffy, *comments;
    long conf_size=0;
    int found_scope=0, y=0, i=0;
    GtkTextBuffer *textbuffer;

    gchar *scope_line1 = g_strdup_printf("subnet %s netmask %s\n", global_subnet, global_netmask);
    gchar *scope_line2 = g_strdup_printf("subnet %s netmask %s{\n", global_subnet, global_netmask);
    gchar *scope_line3 = g_strdup_printf("subnet %s netmask %s {\n", global_subnet, global_netmask);
    gchar *nic_line = g_strdup_printf("interface %s;\n", global_nic);

    gtk_widget_destroy(widgets->scope_set_scrolled_vbox);
    widgets->scope_set_scrolled_vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(widgets->scope_set_viewport), widgets->scope_set_scrolled_vbox);


    /* Create the settings entries */
    create_scope_set_entries(widgets);
    gtk_widget_show_all(widgets->main_window);
    
    /* Populate nic,subnet,netmask entries from the global values */
    utf8 = g_locale_to_utf8((char *)global_nic, strlen(global_nic), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[0]), utf8);

    utf8 = g_locale_to_utf8((char *)global_subnet, strlen(global_subnet), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[1]), utf8);

    utf8 = g_locale_to_utf8((char *)global_netmask, strlen(global_netmask), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[2]), utf8);


    /* Insert the values from the scope */
    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
	g_free(scope_line1);
	g_free(scope_line2);
	g_free(scope_line3);
	g_free(nic_line);

	if( utf8!=NULL )
          g_free(utf8);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);
    buffy = allocate(1024);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( (strstr(line, scope_line1) || strstr(line, scope_line2) 
	|| strstr(line, scope_line3) ) && ! strstr(line, "#") )
	{
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		if( strstr(line, nic_line) && ! strstr(line, "#") )
		{
		    found_scope = 1;
		    break;
		}
	    }
	}
	if( found_scope )
	  break;
    }


    /* The scope is found, list the values */
    if( found_scope && conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( commented(line) || strlen(line) > MAX_CONF_LINE )
	  continue;

	/* Scroll past any failover pools */
	if( strstr(line, "pool") && strstr(line, "{") )
	{
	    while(fgets(line, conf_size, fp)!=NULL)
	    if( strstr(line, "}") )
	      break;
	}
	else /* Break at scope end */
	if( strstr(line, "}") )
	  break;

	remove_semicolon(line);

	if( strstr(line, "default-lease-time") )
	{
    	    sscanf(line, "%*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[3]), utf8);
	}

	if( strstr(line, "max-lease-time") )
	{
	    sscanf(line, "%*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[4]), utf8);
	}

	if( strstr(line, "option domain-name")
	&& ! strstr(line, "option domain-name-servers") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }
	      
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[5]), utf8);
	}

	if( strstr(line, "option subnet-mask") )
	{
	    sscanf(line, "%*s %*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[6]), utf8);
	}

	if( strstr(line, "option broadcast-address") )
	{
	    sscanf(line, "%*s %*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[7]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option routers") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(buffy, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[8]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option domain-name-servers") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(buffy, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[9]), utf8);
	}

	if( strstr(line, "option nis-domain") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[10]), utf8);
	}

	if( strstr(line, "option time-offset") )
	{
	    sscanf(line, "%*s %*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[11]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option ntp-servers") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(buffy, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[12]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option netbios-name-servers") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(buffy, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[13]), utf8);
	}

	if( strstr(line, "option T150") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[14]), utf8);
	}

	if( strstr(line, "filename") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[15]), utf8);
	}

	if( strstr(line, "root-path") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[16]), utf8);
	}

	if( strstr(line, "next-server") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[17]), utf8);
	}

	if( strstr(line, "x-display-manager") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[18]), utf8);
	}

    }

    if( ! found_scope )
    {
	/* Clear the scope settings entries */
	for(i=0; i < NUM_SCOPE_SETTINGS; i++)
	   gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[i]), "");

	/* Clear the comment textview */
	textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widgets->scope_comment_textview));
	gtk_text_buffer_set_text(textbuffer, "", 0);
    }
    fclose(fp);
    free(line);
    free(buffy);
    g_free(scope_line1);
    g_free(scope_line2);
    g_free(scope_line3);
    g_free(nic_line);


    /* Populate the host comment textview */
    if( found_scope )
    {
	comments = get_comments_for_scope(global_subnet, global_netmask, global_nic);

	utf8 = g_locale_to_utf8(comments, strlen(comments), NULL, NULL, NULL);
	textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widgets->scope_comment_textview));
	gtk_text_buffer_set_text(textbuffer, utf8, strlen(utf8));
	if( comments!=NULL )
	  free(comments);
    }

    if( utf8!=NULL )
      g_free(utf8);

    gtk_widget_show_all(widgets->main_window);
}
