/* GAdmin-Rsync - An easy to use GTK+ frontend for the rsync backup client and server.
 * Copyright (C) 2007 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>

#ifndef key_handling_H
#define key_handling_H

extern struct w *widgets;

gchar * mk_key_name(gchar *user, gchar *host, char type[128]);
int key_exists(gchar *key_name);

int is_empty(gchar *input);

void setup_keys(gchar *user, gchar *password, gchar *host, gchar *port, gchar *type, gchar *len, struct w *widgets);
int generate_keys(gchar *user, gchar *host, gchar *key_type, gchar *key_len, struct w *widgets);
int install_remote_key(gchar *user, gchar *host, gchar *port, gchar *password, struct w *widgets);

#endif
