/* GAdmin-Rsync - An easy to use GTK+ frontend for the rsync backup client and server.
 * Copyright (C) 2007 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>

/* Make sure we have enough of these or itll borrow from the next widget-type and fail */
#define NUM_SERVERTAB_ENTRIES 25
#define NUM_SERVERTAB_SPINBUTTONS 13
#define NUM_SERVERTAB_COMBOS 16


#define NUM_USERTAB_ENTRIES 7
#define NUM_USERTAB_SPINBUTTONS 1
#define NUM_USERTAB_CHECKBUTTONS 3
#define NUM_USERTAB_COMBOS 1


typedef struct w
{
  GtkWidget *main_window;
  GtkWidget *main_vbox;

  GtkWidget *notebook_vbox1;
  GtkWidget *notebook_vbox2;
  GtkWidget *notebook_vbox3;
  GtkWidget *notebook_vbox4;
  
  GtkWidget *status_label;
  GtkWidget *version_label;

  /* The backup treeview */
  GtkWidget *backup_treeview;
  GtkListStore *backup_store;

  GtkWidget *user_settings_scrolled_window;
  GtkWidget *user_settings_vbox;
  GtkWidget *usr_set_table;

  GtkWidget *schedule_check_button[9];
  GtkWidget *schedule_spin_button[2];

  GtkWidget *rsync_set_entry[4];
  GtkWidget *rsync_set_combo[2];

  /* New backup window and entry */
  GtkWidget *new_backup_window;
  GtkWidget *new_backup_entry;

  /* Add backup data menu selection */
  GtkWidget *backup_menu_window;
  GtkWidget *src_filesel;
  GtkWidget *dst_filesel;
  GtkWidget *backup_chkbtn_local;
  GtkWidget *backup_chkbtn_local_remote;
  GtkWidget *backup_chkbtn_remote_local;

  /* The server menu window */
  GtkWidget *server_menu_window;
  GtkWidget *remote_server_entry;
  GtkWidget *remote_path_entry;
  GtkWidget *remote_user_entry;
  GtkWidget *remote_password_entry;
  GtkWidget *remote_port_entry;
  GtkWidget *key_type_combo;
  GtkWidget *key_length_spinbutton;
  

  /* The log window */
  GtkWidget *log_window;
  GtkWidget *log_treeview;
  GtkListStore *log_store;

  /* The progress tab */
  GtkWidget *progress_textview;

  GtkWidget *disc_treeview;
  GtkListStore *disc_store;

}wid;
