// ---------------------------------------------------------------------
// $Id: Split.cc,v 1.3 2007/03/28 09:47:10 daaugusto Exp $
//
//   Split.cc (created on Fri Aug  4 12:59:27 BRT 2006)
// 
//   Genetic Algorithm File Fitter (gaffitter)
//
//   Copyright (C) 2005-2007 Douglas A. Augusto
// 
// This file is part of gaffitter.
// 
// gaffitter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.
// 
// gaffitter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with gaffitter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// ---------------------------------------------------------------------

#include "Split.hh"

#include <vector>

// ---------------------------------------------------------------------
void
Split::Evolve()
{
   if (m_params.m_verbose) cout << *this;

   Reset();

   m_best = new vector<bool>(m_files.size());

   Params::Size_t sum=0.0; unsigned i=0;

   for (; i<m_best->size(); ++i)
   {
      if (sum + m_files[i].Size() <= m_params.m_target)
      {
         (*m_best)[i] = true;
         sum += m_files[i].Size();
      }
      else break;
   }
   for (; i<m_best->size(); ++i) (*m_best)[i] = false;
}

// --------------------------------------------------------------------
ostream& 
Split::Write(ostream& s) const 
{ 
   s << endl;
   s << "> -----------------------------------" << endl;
   s << "> Split \"search\"                 "     << endl;
   s << "> -----------------------------------" << endl;

   Optimizer::Write(s);

   s << endl << flush;

   return s;
}

// --------------------------------------------------------------------
