 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Project: gafix                                                         *
 * File: convert.c                                                        *
 * Copyright: (c) 2007 Sebastian Reichel                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This program is free software; you can redistribute it and/or modidy   *
 * it under the terms of GNU Public License as published by               *
 * the Free Software Foundation; either version 2 of the License, or      *
 * (at your option) any later version.                                    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <gtk/gtk.h>
#include <string.h>

#include "statusbar.h"
#include "convert.h"

GString * 
raw_to_cat ( gchar * name, gchar * text )
{
	GString * output = g_string_new("");
	gint32 length = strlen (text);
	gint32 i;

	/* write the cafix header */
	g_string_append_printf(output, "\%\%Header Record\nFormat:TXT\nCommunication SW:0\nData Type:PG\nCapacity:%i\nFile Name:%s\nGroup Name:\nPassword:\nOption1:NL\nOption2:\nOption3:\nOption4:\n%%Data Record\n", length, name);

	statusbar_write ("Convert raw data to cat format!");

	/* scan the raw data and convert the hex bytes into ascii */
	for (i = 0; i < length; i++) {
		if ((text[i-1] != -9) && (text[i-1] != 127) && (text[i-1] != -1)) {
			switch (text[i]) {
				case -128:	g_string_append (output, "\\@80");
							break;
				case -127:	g_string_append (output, "\\sin ");
							break;
				case -126:	g_string_append (output, "\\cos ");
							break;
				case -125:	g_string_append (output, "\\tan ");
							break;
				case -124:	g_string_append (output, "\\Hex>");
							break;
				case -123:	g_string_append (output, "\\In ");
							break;
				case -122:	g_string_append (output, "\\sqrt ");
							break;
				case -121:	g_string_append (output, "\\(-)");
							break;
				case -120:	g_string_append (output, "\\nPr");
							break;
				case -119:	g_string_append (output, "+");
							break;
				case -118:	g_string_append (output, "\\xnor");
							break;
				case -117:	g_string_append (output, "\\x^2");
							break;
				case -116:	g_string_append (output, "\\Dms");
							break;
				case -115:	g_string_append (output, "\\Integral(");
							break;
				case -114:	g_string_append (output, "\\Mo");
							break;
				case -113:	g_string_append (output, "\\Sumx2");
							break;
				case -112:	g_string_append (output, "\\@90");
							break;
				case -111:	g_string_append (output, "\\asin ");
							break;
				case -110:	g_string_append (output, "\\acos ");
							break;
				case -109:	g_string_append (output, "\\atan ");
							break;
				case -108:	g_string_append (output, "\\Dec> ");
							break;
				case -107:	g_string_append (output, "\\log ");
							break;
				case -106:	g_string_append (output, "\\curt ");
							break;
				case -105:	g_string_append (output, "\\Abs ");
							break;
				case -104:	g_string_append (output, "\\nCr");
							break;
				case -103:	g_string_append (output, "-");
							break;
				case -102:	g_string_append (output, "\\xor");
							break;
				case -101:	g_string_append (output, "\\x^-1");
							break;
				case -100:	g_string_append (output, "\\Dec> ");
							break;
				case -99:	g_string_append (output, "\\@9D");
							break;
				case -98:	g_string_append (output, "\\Med");
							break;
				case -97:	g_string_append (output, "\\Sumx");
							break;
				case -96:	g_string_append (output, "\\Rec(");
							break;
				case -95:	g_string_append (output, "\\sinh ");
							break;
				case -94:	g_string_append (output, "\\cosh ");
							break;
				case -93:	g_string_append (output, "\\tanh ");
							break;
				case -92:	g_string_append (output, "\\Oct>");
							break;
				case -91:	g_string_append (output, "\\e^x");
							break;
				case -90:	g_string_append (output, "\\Int ");
							break;
				case -89:	g_string_append (output, "\\ Not ");
							break;
				case -88:	g_string_append (output, "^");
							break;
				case -87:	g_string_append (output, "*");
							break;
				case -86:	g_string_append (output, "\\or");
							break;
				case -85:	g_string_append (output, "!");
							break;
				case -84:	g_string_append (output, "\\Rad>");
							break;
				case -83:	g_string_append (output, "\\minY");
							break;
				case -82:	g_string_append (output, "\\minX");
							break;
				case -81:	g_string_append (output, "\\Cnt");
							break;
				case -80:	g_string_append (output, "\\@B0");
							break;
				case -79:	g_string_append (output, "\\asinh ");
							break;
				case -78:	g_string_append (output, "\\acosh ");
							break;
				case -77:	g_string_append (output, "\\atanh ");
							break;
				case -76:	g_string_append (output, "\\Bin>");
							break;
				case -75:	g_string_append (output, "\\10^x");
							break;
				case -74:	g_string_append (output, "\\Frac ");
							break;
				case -73:	g_string_append (output, "\\Neg ");
							break;
				case -72:	g_string_append (output, "\\xrt");
							break;
				case -71:	g_string_append (output, "/");
							break;
				case -70:	g_string_append (output, "\\and");
							break;
				case -69:	g_string_append (output, "\\ab/c");
							break;
				case -68:	g_string_append (output, "\\Gra>");
							break;
				case -67:	g_string_append (output, "\\maxY");
							break;
				case -66:	g_string_append (output, "\\maxX");
							break;
				case -65:	g_string_append (output, "\\Sumy2");
							break;
				case -64:	g_string_append (output, "\\Ans");
							break;
				case -63:	g_string_append (output, "\\Ran#");
							break;
				case -62:	g_string_append (output, "\\Meanx");
							break;
				case -61:	g_string_append (output, "\\Meany");
							break;
				case -60:	g_string_append (output, "\\Sdx");
							break;
				case -59:	g_string_append (output, "\\Sdxn");
							break;
				case -58:	g_string_append (output, "\\Sdy");
							break;
				case -57:	g_string_append (output, "\\Sdyn");
							break;
				case -56:	g_string_append (output, "\\Ra");
							break;
				case -55:	g_string_append (output, "\\Rb");
							break;
				case -54:	g_string_append (output, "\\Cor");
							break;
				case -53:	g_string_append (output, "\\Eox");
							break;
				case -52:	g_string_append (output, "\\Eoy");
							break;
				case -51:	g_string_append (output, "\\r");
							break;
				case -50:	g_string_append (output, "\\theta");
							break;
				case -49:	g_string_append (output, "\\Sumy");
							break;
				case -48:	g_string_append (output, "\\Pi");
							break;
				case -47:	g_string_append (output, "\\Cls");
							break;
				case -46:	g_string_append (output, "\\@D2");
							break;
				case -45:	g_string_append (output, "\\Rnd");
							break;
				case -44:	g_string_append (output, "\\Dec");
							break;
				case -43:	g_string_append (output, "\\Hex");
							break;
				case -42:	g_string_append (output, "\\Bin");
							break;
				case -41:	g_string_append (output, "\\Oct");
							break;
				case -40:	g_string_append (output, "\\@D8");
							break;
				case -39:	g_string_append (output, "\\Norm");
							break;
				case -38:	g_string_append (output, "\\Deg");
							break;
				case -37:	g_string_append (output, "\\Rad");
							break;
				case -36:	g_string_append (output, "\\Gra");
							break;
				case -35:	g_string_append (output, "\\Eng");
							break;
				case -34:	g_string_append (output, "\\Intg ");
							break;
				case -33:	g_string_append (output, "\\Sumxy");
							break;
				case -32:	g_string_append (output, "\\Plot ");
							break;
				case -31:	g_string_append (output, "\\Line");
							break;
				case -30:	g_string_append (output, "\\Lbl ");
							break;
				case -29:	g_string_append (output, "\\Fix ");
							break;
				case -28:	g_string_append (output, "\\Sci ");
							break;
				case -27:	g_string_append (output, "\\@E5");
							break;
				case -26:	g_string_append (output, "\\@E6");
							break;
				case -25:	g_string_append (output, "\\@E7");
							break;
				case -24:	g_string_append (output, "\\Dsz ");
							break;
				case -23:	g_string_append (output, "\\Isz ");
							break;
				case -22:	g_string_append (output, "\\Factor ");
							break;
				case -21:	g_string_append (output, "\\ViewWindow ");
							break;
				case -20:	g_string_append (output, "\\Goto");
							break;
				case -19:	g_string_append (output, "\\Prog ");
							break;
				case -18:	g_string_append (output, "\\Graph Y=");
							break;
				case -17:	g_string_append (output, "\\Graph Integral ");
							break;
				case -16:	g_string_append (output, "\\Graph Y>");
							break;
				case -15:	g_string_append (output, "\\Graph Y<");
							break;
				case -14:	g_string_append (output, "\\Graph Y>=");
							break;
				case -13:	g_string_append (output, "\\Graph Y<=");
							break;
				case -12:	g_string_append (output, "\\Graph r=");
							break;
				case -11:	g_string_append (output, "\\Graph (X,Y)=(");
							break;
				case -10:	g_string_append (output, "\\,");
							break;
				case -9:	g_string_append (output, "\\@F7");
							break;
				case -8:	g_string_append (output, "\\@F8");
							break;
				case -7:	g_string_append (output, "\\@F9");
							break;
				case -6:	g_string_append (output, "\\@FA");
							break;
				case -5:	g_string_append (output, "\\ProbP(");
							break;
				case -4:	g_string_append (output, "\\ProbQ(");
							break;
				case -3:	g_string_append (output, "\\ProbR(");
							break;
				case -2:	g_string_append (output, "\\ProbT(");
							break;
				case -1:	// do nothing
							break;
				case 0:		g_string_append (output, "\\@00");
							break;
				case 1:		g_string_append (output, "\\femto");
							break;
				case 2:		g_string_append (output, "\\pico");
							break;
				case 3:		g_string_append (output, "\\nano");
							break;
				case 4:		g_string_append (output, "\\micro");
							break;
				case 5:		g_string_append (output, "\\milli");
							break;
				case 6:		g_string_append (output, "\\kilo");
							break;
				case 7:		g_string_append (output, "\\Mega");
							break;
				case 8:		g_string_append (output, "\\Giga");
							break;
				case 9:		g_string_append (output, "\\Tera");
							break;
				case 10:	g_string_append (output, "\\Peta");
							break;
				case 11:	g_string_append (output, "\\Exa");
							break;
				case 12:	g_string_append (output, "\\Disp");
							break;
				case 13:	g_string_append (output, "\n");
							break;
				case 14:	g_string_append (output, "\\->");
							break;
				case 15:	g_string_append (output, "\\EE");
							break;
				case 16:	g_string_append (output, "\\<=");
							break;
				case 17:	g_string_append (output, "\\<>");
							break;
				case 18:	g_string_append (output, "\\>=");
							break;
				case 19:	g_string_append (output, "\\=>");
							break;
				case 20:	g_string_append (output, "\\f1");
							break;
				case 21:	g_string_append (output, "\\f2");
							break;
				case 22:	g_string_append (output, "\\f3");
							break;
				case 23:	g_string_append (output, "\\f4");
							break;
				case 24:	g_string_append (output, "\\f5");
							break;
				case 25:	g_string_append (output, "\\f6");
							break;
				case 26:	g_string_append (output, "\\hA");
							break;
				case 27:	g_string_append (output, "\\hB");
							break;
				case 28:	g_string_append (output, "\\hC");
							break;
				case 29:	g_string_append (output, "\\hD");
							break;
				case 30:	g_string_append (output, "\\hE");
							break;
				case 31:	g_string_append (output, "\\hF");
							break;
				case 32:	g_string_append (output, " ");
							break;
				case 33:	g_string_append (output, "\\!mark");
							break;
				case 34:	g_string_append (output, "\"");
							break;
				case 35:	g_string_append (output, "#");
							break;
				case 36:	g_string_append (output, "\\@24");
							break;
				case 37:	g_string_append (output, "\\@25");
							break;
				case 38:	g_string_append (output, "\\@26");
							break;
				case 39:	g_string_append (output, "'");
							break;
				case 40:	g_string_append (output, "(");
							break;
				case 41:	g_string_append (output, ")");
							break;
				case 42:	g_string_append (output, "\\aster");
							break;
				case 43:	g_string_append (output, "\\@2B");
							break;
				case 44:	g_string_append (output, ",");
							break;
				case 45:	g_string_append (output, "\\@2D");
							break;
				case 46:	g_string_append (output, ".");
							break;
				case 47:	g_string_append (output, "\\slash");
							break;
				case 48:	g_string_append (output, "0");
							break;
				case 49:	g_string_append (output, "1");
							break;
				case 50:	g_string_append (output, "2");
							break;
				case 51:	g_string_append (output, "3");
							break;
				case 52:	g_string_append (output, "4");
							break;
				case 53:	g_string_append (output, "5");
							break;
				case 54:	g_string_append (output, "6");
							break;
				case 55:	g_string_append (output, "7");
							break;
				case 56:	g_string_append (output, "8");
							break;
				case 57:	g_string_append (output, "9");
							break;
				case 58:	g_string_append (output, ":");
							break;
				case 59:	g_string_append (output, ";");
							break;
				case 60:	g_string_append (output, "<");
							break;
				case 61:	g_string_append (output, "=");
							break;
				case 62:	g_string_append (output, ">");
							break;
				case 63:	g_string_append (output, "?");
							break;
				case 64:	g_string_append (output, "@");
							break;
				case 65:	g_string_append (output, "A");
							break;
				case 66:	g_string_append (output, "B");
							break;
				case 67:	g_string_append (output, "C");
							break;
				case 68:	g_string_append (output, "D");
							break;
				case 69:	g_string_append (output, "E");
							break;
				case 70:	g_string_append (output, "F");
							break;
				case 71:	g_string_append (output, "G");
							break;
				case 72:	g_string_append (output, "H");
							break;
				case 73:	g_string_append (output, "I");
							break;
				case 74:	g_string_append (output, "J");
							break;
				case 75:	g_string_append (output, "K");
							break;
				case 76:	g_string_append (output, "L");
							break;
				case 77:	g_string_append (output, "M");
							break;
				case 78:	g_string_append (output, "N");
							break;
				case 79:	g_string_append (output, "O");
							break;
				case 80:	g_string_append (output, "P");
							break;
				case 81:	g_string_append (output, "Q");
							break;
				case 82:	g_string_append (output, "R");
							break;
				case 83:	g_string_append (output, "S");
							break;
				case 84:	g_string_append (output, "T");
							break;
				case 85:	g_string_append (output, "U");
							break;
				case 86:	g_string_append (output, "V");
							break;
				case 87:	g_string_append (output, "W");
							break;
				case 88:	g_string_append (output, "X");
							break;
				case 89:	g_string_append (output, "Y");
							break;
				case 90:	g_string_append (output, "Z");
							break;
				case 91:	g_string_append (output, "[");
							break;
				case 92:	g_string_append (output, "\\@5C");
							break;
				case 93:	g_string_append (output, "]");
							break;
				case 94:	g_string_append (output, "\\@5E");
							break;
				case 95:	g_string_append (output, "\\@5F");
							break;
				case 96:	g_string_append (output, "\\@60");
							break;
				case 97:	g_string_append (output, "a");
							break;
				case 98:	g_string_append (output, "b");
							break;
				case 99:	g_string_append (output, "c");
							break;
				case 100:	g_string_append (output, "d");
							break;
				case 101:	g_string_append (output, "e");
							break;
				case 102:	g_string_append (output, "f");
							break;
				case 103:	g_string_append (output, "g");
							break;
				case 104:	g_string_append (output, "h");
							break;
				case 105:	g_string_append (output, "i");
							break;
				case 106:	g_string_append (output, "j");
							break;
				case 107:	g_string_append (output, "k");
							break;
				case 108:	g_string_append (output, "l");
							break;
				case 109:	g_string_append (output, "m");
							break;
				case 110:	g_string_append (output, "n");
							break;
				case 111:	g_string_append (output, "o");
							break;
				case 112:	g_string_append (output, "p");
							break;
				case 113:	g_string_append (output, "q");
							break;
				case 114:	g_string_append (output, "r");
							break;
				case 115:	g_string_append (output, "s");
							break;
				case 116:	g_string_append (output, "t");
							break;
				case 117:	g_string_append (output, "u");
							break;
				case 118:	g_string_append (output, "v");
							break;
				case 119:	g_string_append (output, "w");
							break;
				case 120:	g_string_append (output, "x");
							break;
				case 121:	g_string_append (output, "y");
							break;
				case 122:	g_string_append (output, "z");
							break;
				case 123:	g_string_append (output, "{");
							break;
				case 124:	g_string_append (output, "\\@70");
							break;
				case 125:	g_string_append (output, "}");
							break;
				case 126:	g_string_append (output, "~");
							break;
				case 127:	//do nothing
							break;
				default:	g_string_append_printf (output, "[Error: %i]", text[i]);
			}
		}
		else {
			if(text[i-1] == -9)
			{
				switch(text[i]) {
					default:	g_string_append_printf (output, "[Not supported: %d]\n", text[i]);
								break;
				}
			}
			else if(text[i-1] == 127) {
				switch(text[i]) {
					default:	g_string_append_printf (output, "{Not supported: %d}\n", text[i]);
								break;
				}
			}
		}
	}

	g_string_append_printf(output, "\n\%\%End");

	return output;
}

gchar * 
cat_to_raw ( gchar * text )
{
	GString * cat_data = g_string_new(text);
	gint start,end;
	
	/* find beginn and end of data segment */
	start = g_string_find(cat_data, "%Data Record") + 13;
	end = g_string_find(cat_data, "%End") - 1;

	/* return empty string if there is no begin of data (-1+13 = 12) */
	if(start == 12) {
		g_debug("Could not find Data Record Header");
		return "";
	}

	if(end == -2) {
		g_debug("Could not find End Header");
		end = cat_data->len;
	}

	/* Cut string after end of data segment */
	g_string_truncate (cat_data, end);
	
	/* Erase chars up to start of data segment */
	g_string_erase(cat_data, 0, start);
	
	/* cat_data is data segment only, now. Next step is changing all 
	commands with HEX alternatives by g_string_replace */
	
	/* replace -128 to -2 dec codes */
	replace(cat_data, "\\@80", -128);
	replace(cat_data, "\\sin ", -127);
	replace(cat_data, "\\cos ", -126);
	replace(cat_data, "\\tan ", -125);
	replace(cat_data, "\\Hex>", -124);
	replace(cat_data, "\\In ", -123);
	replace(cat_data, "\\sqrt ", -122);
	replace(cat_data, "\\(-)", -121);
	replace(cat_data, "\\nPr", -120);
	replace(cat_data, "+", -119);
	replace(cat_data, "\\xnor", -118);
	replace(cat_data, "\\x^2", -117);
	replace(cat_data, "\\Dms", -116);
	replace(cat_data, "\\Integral(", -115);
	replace(cat_data, "\\Mo", -113);
	replace(cat_data, "\\Sumx2", -113);
	replace(cat_data, "\\@90", -112);
	replace(cat_data, "\\asin ", -111);
	replace(cat_data, "\\acos ", -110);
	replace(cat_data, "\\atan ", -109);
	replace(cat_data, "\\Dec> ", -108);
	replace(cat_data, "\\log ", -107);
	replace(cat_data, "\\curt ", -106);
	replace(cat_data, "\\Abs ", -105);
	replace(cat_data, "\\nCr", -104);
	replace(cat_data, "-", -103);
	replace(cat_data, "\\xor", -102);
	replace(cat_data, "\\x^-1", -101);
	replace(cat_data, "\\Dec> ", -100);
	replace(cat_data, "\\@9D", -99);
	replace(cat_data, "\\Med", -98);
	replace(cat_data, "\\Sumx", -97);
	replace(cat_data, "\\Rec(", -96);
	replace(cat_data, "\\sinh ", -95);
	replace(cat_data, "\\cosh ", -94);
	replace(cat_data, "\\tanh ", -93);
	replace(cat_data, "\\Oct>", -92);
	replace(cat_data, "\\e^x", -91);
	replace(cat_data, "\\Int ", -90);
	replace(cat_data, "\\ Not ", -89);
	replace(cat_data, "^", -88);
	replace(cat_data, "*", -87);
	replace(cat_data, "\\or", -86);
	replace(cat_data, "!", -85);
	replace(cat_data, "\\Rad>", -84);
	replace(cat_data, "\\minY", -83);
	replace(cat_data, "\\minX", -82);
	replace(cat_data, "\\Cnt", -81);
	replace(cat_data, "\\@B0", -80);
	replace(cat_data, "\\asinh ", -79);
	replace(cat_data, "\\acosh ", -78);
	replace(cat_data, "\\atanh ", -77);
	replace(cat_data, "\\Bin>", -76);
	replace(cat_data, "\\10^x", -75);
	replace(cat_data, "\\Frac ", -74);
	replace(cat_data, "\\Neg ", -73);
	replace(cat_data, "\\xrt", -72);
	replace(cat_data, "/", -71);
	replace(cat_data, "\\and", -70);
	replace(cat_data, "\\ab/c", -69);
	replace(cat_data, "\\Gra>", -68);
	replace(cat_data, "\\maxY", -67);
	replace(cat_data, "\\maxX", -66);
	replace(cat_data, "\\Sumy2", -65);
	replace(cat_data, "\\Ans", -64);
	replace(cat_data, "\\Ran#", -63);
	replace(cat_data, "\\Meanx", -62);
	replace(cat_data, "\\Meany", -61);
	replace(cat_data, "\\Sdx", -60);
	replace(cat_data, "\\Sdxn", -59);
	replace(cat_data, "\\Sdy", -58);
	replace(cat_data, "\\Sdyn", -57);
	replace(cat_data, "\\Ra", -56);
	replace(cat_data, "\\Rb", -55);
	replace(cat_data, "\\Cor", -54);
	replace(cat_data, "\\Eox", -53);
	replace(cat_data, "\\Eoy", -52);
	replace(cat_data, "\\r", -51);
	replace(cat_data, "\\theta", -50);
	replace(cat_data, "\\Sumy", -49);
	replace(cat_data, "\\Pi", -48);
	replace(cat_data, "\\Cls", -47);
	replace(cat_data, "\\@D2", -46);
	replace(cat_data, "\\Rnd", -45);
	replace(cat_data, "\\Dec", -44);
	replace(cat_data, "\\Hex", -43);
	replace(cat_data, "\\Bin", -42);
	replace(cat_data, "\\Oct", -41);
	replace(cat_data, "\\@D8", -40);
	replace(cat_data, "\\Norm", -39);
	replace(cat_data, "\\Deg", -38);
	replace(cat_data, "\\Rad", -37);
	replace(cat_data, "\\Gra", -36);
	replace(cat_data, "\\Eng", -35);
	replace(cat_data, "\\Intg ", -34);
	replace(cat_data, "\\Sumxy", -33);
	replace(cat_data, "\\Plot ", -32);
	replace(cat_data, "\\Line", -31);
	replace(cat_data, "\\Lbl ", -30);
	replace(cat_data, "\\Fix ", -29);
	replace(cat_data, "\\Sci ", -28);
	replace(cat_data, "\\@E5", -27);
	replace(cat_data, "\\@E6", -26);
	replace(cat_data, "\\@E7", -25);
	replace(cat_data, "\\Dsz ", -24);
	replace(cat_data, "\\Isz ", -23);
	replace(cat_data, "\\Factor ", -22);
	replace(cat_data, "\\ViewWindow ", -21);
	replace(cat_data, "\\Goto", -20);
	replace(cat_data, "\\Prog ", -19);
	replace(cat_data, "\\Graph Y=", -18);
	replace(cat_data, "\\Graph Integral ", -17);
	replace(cat_data, "\\Graph Y>", -16);
	replace(cat_data, "\\Graph Y<", -15);
	replace(cat_data, "\\Graph Y>=", -14);
	replace(cat_data, "\\Graph Y<=", -13);
	replace(cat_data, "\\Graph r=", -12);
	replace(cat_data, "\\Graph (X,Y)=(", -11);
	replace(cat_data, "\\,", -10);
	replace(cat_data, "\\@F7", -9);
	replace(cat_data, "\\@F8", -8);
	replace(cat_data, "\\@F9", -7);
	replace(cat_data, "\\@FA", -6);
	replace(cat_data, "\\ProbP(", -5);
	replace(cat_data, "\\ProbQ(", -4);
	replace(cat_data, "\\ProbR(", -3);
	replace(cat_data, "\\ProbT(", -2);
	
	/* replace 1 to 126 dec codes */
	replace(cat_data, "\\femto", 1);
	replace(cat_data, "\\pico", 2);
	replace(cat_data, "\\nano", 3);
	replace(cat_data, "\\micro", 4);
	replace(cat_data, "\\milli", 5);
	replace(cat_data, "\\kilo", 6);
	replace(cat_data, "\\Mega", 7);
	replace(cat_data, "\\Giga", 8);
	replace(cat_data, "\\Tera", 9);
	replace(cat_data, "\\Peta", 10);
	replace(cat_data, "\\Exa", 11);
	replace(cat_data, "\\Disp", 12);
	replace(cat_data, "\n", 13);
	replace(cat_data, "\\->", 14);
	replace(cat_data, "\\EE", 15);
	replace(cat_data, "\\<=", 16);
	replace(cat_data, "\\<>", 17);
	replace(cat_data, "\\>=", 18);
	replace(cat_data, "\\=>", 19);
	replace(cat_data, "\\f1", 20);
	replace(cat_data, "\\f2", 21);
	replace(cat_data, "\\f3", 22);
	replace(cat_data, "\\f4", 23);
	replace(cat_data, "\\f5", 24);
	replace(cat_data, "\\f6", 25);
	replace(cat_data, "\\hA", 26);
	replace(cat_data, "\\hB", 27);
	replace(cat_data, "\\hC", 28);
	replace(cat_data, "\\hD", 29);
	replace(cat_data, "\\hE", 30);
	replace(cat_data, "\\hF", 31);
	replace(cat_data, " ", 32);
	replace(cat_data, "\\!mark", 33);
	replace(cat_data, "\"", 34);
	replace(cat_data, "#", 35);
	replace(cat_data, "\\@24", 36);
	replace(cat_data, "\\@25", 37);
	replace(cat_data, "\\@26", 38);
	replace(cat_data, "\\aster", 42);
	replace(cat_data, "\\@2B", 43);
	replace(cat_data, "\\@2D", 45);
	replace(cat_data, "\\slash", 47);
	replace(cat_data, "\\@5C", 92);
	replace(cat_data, "\\@5E", 94);
	replace(cat_data, "\\@5F", 95);
	replace(cat_data, "\\@60", 96);
	replace(cat_data, "\\@70", 124);
	
	/* finally add the program end byte FF */
	g_string_append_c(cat_data, (char) -1);
	
	return cat_data->str;
}

//replaces all occurances of needle with replacement. returns the GString
GString * 
g_string_replace_c (GString * haystack, gchar * needle, gchar replacement)
{
	GString * NewString;
	guint pos;
	guint needlelen = strlen (needle);

	NewString = g_string_new ("");

	/* loop for each char in haystack */
	for (pos = 0; pos <= haystack->len; pos++) {
		
		/* test if needle begins at this position */
		
		if (strncmp (&haystack->str[pos], needle, needlelen) == 0) {
		
			/* add replacement to new string */
			NewString = g_string_append_c(NewString, replacement);
			
			/* new position in haystack is old position + length of needle */
			pos += needlelen - 1;
		}
		else {
			/* add scaned char to new string */
			NewString = g_string_append_c(NewString, haystack->str[pos]);
		}

	}
        
	return NewString;
}

//replaces all occurances of needle with replacement. returns the GString
GString * 
g_string_replace (GString * haystack, gchar * needle, gchar * replacement)
{
	GString * NewString;
	guint pos;
	guint needlelen = strlen (needle);

	NewString = g_string_new ("");

	/* loop for each char in haystack */
	for (pos = 0; pos <= haystack->len; pos++) {
		
		/* test if needle begins at this position */
		
		if (strncmp (&haystack->str[pos], needle, needlelen) == 0) {
		
			/* add replacement to new string */
			NewString = g_string_append (NewString, replacement);
			
			/* new position in haystack is old position + length of needle */
			pos += needlelen - 1;
		}
		else {
			/* add scaned char to new string */
			NewString = g_string_append_c(NewString, haystack->str[pos]);
		}

	}
        
	return NewString;
}

//finds first occurence of a string in haystack, return its position
gint
g_string_find(GString *haystack, gchar *find)
{
	guint i, j, find_len;
	gboolean match;

	/* exit if haystack or find are empty */
	g_assert(haystack != NULL);
	g_assert(find != NULL);

	/* get length of find string */
	find_len = strlen(find);

	/* test find length; if 0 - return -1 as error */	
	if (find_len == 0) {
		return -1;
	}

	for (i = 0; i < haystack->len; i++) { // scan haystack
		if (find[0] == haystack->str[i]) { // check if str[i] could be the beginning of find
			match = TRUE; // set found match

			/* scan haystack for length of find and make sure, that there is no 
			buffer overflow due to the end of haystack */
			for (j = 1; j < find_len && (j+i) < haystack->len; j++) {
				if (find[j] != haystack->str[j+i]) { //compare the chars, which are scanned
					match = FALSE; // set match to FALSE if they differ
					break; //exit loop - can be removed, but it saves CPU time
				}
			}
	  
			/* return position of first char of find in string, if there is a match */
			if (match)
				return i;
		}
	}
	/* string not found; return -1 as error */	
	return -1;
}
